/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a ListDeployments operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDeploymentsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListDeploymentsRequest.Builder, ListDeploymentsRequest> {
    private final String applicationName;

    private final String deploymentGroupName;

    private final List<String> includeOnlyStatuses;

    private final TimeRange createTimeRange;

    private final String nextToken;

    private ListDeploymentsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.includeOnlyStatuses = builder.includeOnlyStatuses;
        this.createTimeRange = builder.createTimeRange;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
     * </p>
     * 
     * @return The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The name of an existing deployment group for the specified application.
     * </p>
     * 
     * @return The name of an existing deployment group for the specified application.
     */
    public String deploymentGroupName() {
        return deploymentGroupName;
    }

    /**
     * <p>
     * A subset of deployments to list by status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Created: Include created deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Queued: Include queued deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * In Progress: Include in-progress deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded: Include successful deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed: Include failed deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Stopped: Include stopped deployments in the resulting list.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A subset of deployments to list by status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Created: Include created deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Queued: Include queued deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In Progress: Include in-progress deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded: Include successful deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed: Include failed deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Stopped: Include stopped deployments in the resulting list.
     *         </p>
     *         </li>
     * @see DeploymentStatus
     */
    public List<String> includeOnlyStatuses() {
        return includeOnlyStatuses;
    }

    /**
     * <p>
     * A time range (start and end) for returning a subset of the list of deployments.
     * </p>
     * 
     * @return A time range (start and end) for returning a subset of the list of deployments.
     */
    public TimeRange createTimeRange() {
        return createTimeRange;
    }

    /**
     * <p>
     * An identifier returned from the previous list deployments call. It can be used to return the next set of
     * deployments in the list.
     * </p>
     * 
     * @return An identifier returned from the previous list deployments call. It can be used to return the next set of
     *         deployments in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((deploymentGroupName() == null) ? 0 : deploymentGroupName().hashCode());
        hashCode = 31 * hashCode + ((includeOnlyStatuses() == null) ? 0 : includeOnlyStatuses().hashCode());
        hashCode = 31 * hashCode + ((createTimeRange() == null) ? 0 : createTimeRange().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsRequest)) {
            return false;
        }
        ListDeploymentsRequest other = (ListDeploymentsRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroupName() == null ^ this.deploymentGroupName() == null) {
            return false;
        }
        if (other.deploymentGroupName() != null && !other.deploymentGroupName().equals(this.deploymentGroupName())) {
            return false;
        }
        if (other.includeOnlyStatuses() == null ^ this.includeOnlyStatuses() == null) {
            return false;
        }
        if (other.includeOnlyStatuses() != null && !other.includeOnlyStatuses().equals(this.includeOnlyStatuses())) {
            return false;
        }
        if (other.createTimeRange() == null ^ this.createTimeRange() == null) {
            return false;
        }
        if (other.createTimeRange() != null && !other.createTimeRange().equals(this.createTimeRange())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (deploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(deploymentGroupName()).append(",");
        }
        if (includeOnlyStatuses() != null) {
            sb.append("IncludeOnlyStatuses: ").append(includeOnlyStatuses()).append(",");
        }
        if (createTimeRange() != null) {
            sb.append("CreateTimeRange: ").append(createTimeRange()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDeploymentsRequest> {
        /**
         * <p>
         * The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
         * </p>
         * 
         * @param applicationName
         *        The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The name of an existing deployment group for the specified application.
         * </p>
         * 
         * @param deploymentGroupName
         *        The name of an existing deployment group for the specified application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupName(String deploymentGroupName);

        /**
         * <p>
         * A subset of deployments to list by status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Created: Include created deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Queued: Include queued deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * In Progress: Include in-progress deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: Include successful deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: Include failed deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Stopped: Include stopped deployments in the resulting list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param includeOnlyStatuses
         *        A subset of deployments to list by status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Created: Include created deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Queued: Include queued deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In Progress: Include in-progress deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: Include successful deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: Include failed deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Stopped: Include stopped deployments in the resulting list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder includeOnlyStatuses(Collection<String> includeOnlyStatuses);

        /**
         * <p>
         * A subset of deployments to list by status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Created: Include created deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Queued: Include queued deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * In Progress: Include in-progress deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: Include successful deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: Include failed deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Stopped: Include stopped deployments in the resulting list.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setIncludeOnlyStatuses(java.util.Collection)} or
         * {@link #withIncludeOnlyStatuses(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param includeOnlyStatuses
         *        A subset of deployments to list by status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Created: Include created deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Queued: Include queued deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In Progress: Include in-progress deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: Include successful deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: Include failed deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Stopped: Include stopped deployments in the resulting list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder includeOnlyStatuses(String... includeOnlyStatuses);

        /**
         * <p>
         * A subset of deployments to list by status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Created: Include created deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Queued: Include queued deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * In Progress: Include in-progress deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: Include successful deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: Include failed deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Stopped: Include stopped deployments in the resulting list.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setIncludeOnlyStatuses(java.util.Collection)} or
         * {@link #withIncludeOnlyStatuses(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param includeOnlyStatuses
         *        A subset of deployments to list by status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Created: Include created deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Queued: Include queued deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In Progress: Include in-progress deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: Include successful deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: Include failed deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Stopped: Include stopped deployments in the resulting list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder includeOnlyStatuses(DeploymentStatus... includeOnlyStatuses);

        /**
         * <p>
         * A time range (start and end) for returning a subset of the list of deployments.
         * </p>
         * 
         * @param createTimeRange
         *        A time range (start and end) for returning a subset of the list of deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimeRange(TimeRange createTimeRange);

        /**
         * <p>
         * An identifier returned from the previous list deployments call. It can be used to return the next set of
         * deployments in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier returned from the previous list deployments call. It can be used to return the next set
         *        of deployments in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private String deploymentGroupName;

        private List<String> includeOnlyStatuses = new SdkInternalList<>();

        private TimeRange createTimeRange;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentsRequest model) {
            setApplicationName(model.applicationName);
            setDeploymentGroupName(model.deploymentGroupName);
            setIncludeOnlyStatuses(model.includeOnlyStatuses);
            setCreateTimeRange(model.createTimeRange);
            setNextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final Collection<String> getIncludeOnlyStatuses() {
            return includeOnlyStatuses;
        }

        @Override
        public final Builder includeOnlyStatuses(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnlyStatuses(String... includeOnlyStatuses) {
            if (this.includeOnlyStatuses == null) {
                this.includeOnlyStatuses = new SdkInternalList<>(includeOnlyStatuses.length);
            }
            for (String e : includeOnlyStatuses) {
                this.includeOnlyStatuses.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnlyStatuses(DeploymentStatus... includeOnlyStatuses) {
            if (this.includeOnlyStatuses == null) {
                this.includeOnlyStatuses = new SdkInternalList<String>(includeOnlyStatuses.length);
            }
            for (DeploymentStatus ele : includeOnlyStatuses) {
                this.includeOnlyStatuses.add(ele.toString());
            }
            return this;
        }

        public final void setIncludeOnlyStatuses(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
        }

        @SafeVarargs
        public final void setIncludeOnlyStatuses(String... includeOnlyStatuses) {
            if (this.includeOnlyStatuses == null) {
                this.includeOnlyStatuses = new SdkInternalList<>(includeOnlyStatuses.length);
            }
            for (String e : includeOnlyStatuses) {
                this.includeOnlyStatuses.add(e);
            }
        }

        @SafeVarargs
        public final void setIncludeOnlyStatuses(DeploymentStatus... includeOnlyStatuses) {
            if (this.includeOnlyStatuses == null) {
                this.includeOnlyStatuses = new SdkInternalList<String>(includeOnlyStatuses.length);
            }
            for (DeploymentStatus ele : includeOnlyStatuses) {
                this.includeOnlyStatuses.add(ele.toString());
            }
        }

        public final TimeRange getCreateTimeRange() {
            return createTimeRange;
        }

        @Override
        public final Builder createTimeRange(TimeRange createTimeRange) {
            this.createTimeRange = createTimeRange;
            return this;
        }

        public final void setCreateTimeRange(TimeRange createTimeRange) {
            this.createTimeRange = createTimeRange;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentsRequest build() {
            return new ListDeploymentsRequest(this);
        }
    }
}
