/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a ListDeploymentInstances operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDeploymentInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDeploymentInstancesResponse.Builder, ListDeploymentInstancesResponse> {
    private final List<String> instancesList;

    private final String nextToken;

    private ListDeploymentInstancesResponse(BuilderImpl builder) {
        this.instancesList = builder.instancesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of instance IDs.
     * </p>
     * 
     * @return A list of instance IDs.
     */
    public List<String> instancesList() {
        return instancesList;
    }

    /**
     * <p>
     * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list
     * deployment instances call to return the next set of deployment instances in the list.
     * </p>
     * 
     * @return If a large amount of information is returned, an identifier is also returned. It can be used in a
     *         subsequent list deployment instances call to return the next set of deployment instances in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instancesList() == null) ? 0 : instancesList().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentInstancesResponse)) {
            return false;
        }
        ListDeploymentInstancesResponse other = (ListDeploymentInstancesResponse) obj;
        if (other.instancesList() == null ^ this.instancesList() == null) {
            return false;
        }
        if (other.instancesList() != null && !other.instancesList().equals(this.instancesList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instancesList() != null) {
            sb.append("InstancesList: ").append(instancesList()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDeploymentInstancesResponse> {
        /**
         * <p>
         * A list of instance IDs.
         * </p>
         * 
         * @param instancesList
         *        A list of instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesList(Collection<String> instancesList);

        /**
         * <p>
         * A list of instance IDs.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstancesList(java.util.Collection)} or {@link #withInstancesList(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param instancesList
         *        A list of instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesList(String... instancesList);

        /**
         * <p>
         * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent
         * list deployment instances call to return the next set of deployment instances in the list.
         * </p>
         * 
         * @param nextToken
         *        If a large amount of information is returned, an identifier is also returned. It can be used in a
         *        subsequent list deployment instances call to return the next set of deployment instances in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> instancesList = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentInstancesResponse model) {
            setInstancesList(model.instancesList);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getInstancesList() {
            return instancesList;
        }

        @Override
        public final Builder instancesList(Collection<String> instancesList) {
            this.instancesList = InstancesListCopier.copy(instancesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancesList(String... instancesList) {
            if (this.instancesList == null) {
                this.instancesList = new SdkInternalList<>(instancesList.length);
            }
            for (String e : instancesList) {
                this.instancesList.add(e);
            }
            return this;
        }

        public final void setInstancesList(Collection<String> instancesList) {
            this.instancesList = InstancesListCopier.copy(instancesList);
        }

        @SafeVarargs
        public final void setInstancesList(String... instancesList) {
            if (this.instancesList == null) {
                this.instancesList = new SdkInternalList<>(instancesList.length);
            }
            for (String e : instancesList) {
                this.instancesList.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentInstancesResponse build() {
            return new ListDeploymentInstancesResponse(this);
        }
    }
}
