/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a ListDeploymentInstances operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDeploymentInstancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListDeploymentInstancesRequest.Builder, ListDeploymentInstancesRequest> {
    private final String deploymentId;

    private final String nextToken;

    private final List<String> instanceStatusFilter;

    private final List<String> instanceTypeFilter;

    private ListDeploymentInstancesRequest(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.nextToken = builder.nextToken;
        this.instanceStatusFilter = builder.instanceStatusFilter;
        this.instanceTypeFilter = builder.instanceTypeFilter;
    }

    /**
     * <p>
     * The unique ID of a deployment.
     * </p>
     * 
     * @return The unique ID of a deployment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * An identifier returned from the previous list deployment instances call. It can be used to return the next set of
     * deployment instances in the list.
     * </p>
     * 
     * @return An identifier returned from the previous list deployment instances call. It can be used to return the
     *         next set of deployment instances in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A subset of instances to list by status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending: Include those instance with pending deployments.
     * </p>
     * </li>
     * <li>
     * <p>
     * InProgress: Include those instance where deployments are still in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded: Include those instances with successful deployments.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed: Include those instance with failed deployments.
     * </p>
     * </li>
     * <li>
     * <p>
     * Skipped: Include those instance with skipped deployments.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unknown: Include those instance with deployments in an unknown state.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A subset of instances to list by status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: Include those instance with pending deployments.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         InProgress: Include those instance where deployments are still in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded: Include those instances with successful deployments.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed: Include those instance with failed deployments.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Skipped: Include those instance with skipped deployments.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Unknown: Include those instance with deployments in an unknown state.
     *         </p>
     *         </li>
     * @see InstanceStatus
     */
    public List<String> instanceStatusFilter() {
        return instanceStatusFilter;
    }

    /**
     * <p>
     * The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in
     * the replacement environment ("GREEN"), for which you want to view instance information.
     * </p>
     * 
     * @return The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or
     *         those in the replacement environment ("GREEN"), for which you want to view instance information.
     * @see InstanceType
     */
    public List<String> instanceTypeFilter() {
        return instanceTypeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentId() == null) ? 0 : deploymentId().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((instanceStatusFilter() == null) ? 0 : instanceStatusFilter().hashCode());
        hashCode = 31 * hashCode + ((instanceTypeFilter() == null) ? 0 : instanceTypeFilter().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentInstancesRequest)) {
            return false;
        }
        ListDeploymentInstancesRequest other = (ListDeploymentInstancesRequest) obj;
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.instanceStatusFilter() == null ^ this.instanceStatusFilter() == null) {
            return false;
        }
        if (other.instanceStatusFilter() != null && !other.instanceStatusFilter().equals(this.instanceStatusFilter())) {
            return false;
        }
        if (other.instanceTypeFilter() == null ^ this.instanceTypeFilter() == null) {
            return false;
        }
        if (other.instanceTypeFilter() != null && !other.instanceTypeFilter().equals(this.instanceTypeFilter())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentId() != null) {
            sb.append("DeploymentId: ").append(deploymentId()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (instanceStatusFilter() != null) {
            sb.append("InstanceStatusFilter: ").append(instanceStatusFilter()).append(",");
        }
        if (instanceTypeFilter() != null) {
            sb.append("InstanceTypeFilter: ").append(instanceTypeFilter()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDeploymentInstancesRequest> {
        /**
         * <p>
         * The unique ID of a deployment.
         * </p>
         * 
         * @param deploymentId
         *        The unique ID of a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * An identifier returned from the previous list deployment instances call. It can be used to return the next
         * set of deployment instances in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier returned from the previous list deployment instances call. It can be used to return the
         *        next set of deployment instances in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A subset of instances to list by status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: Include those instance with pending deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * InProgress: Include those instance where deployments are still in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: Include those instances with successful deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: Include those instance with failed deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * Skipped: Include those instance with skipped deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * Unknown: Include those instance with deployments in an unknown state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceStatusFilter
         *        A subset of instances to list by status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: Include those instance with pending deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InProgress: Include those instance where deployments are still in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: Include those instances with successful deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: Include those instance with failed deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Skipped: Include those instance with skipped deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Unknown: Include those instance with deployments in an unknown state.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder instanceStatusFilter(Collection<String> instanceStatusFilter);

        /**
         * <p>
         * A subset of instances to list by status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: Include those instance with pending deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * InProgress: Include those instance where deployments are still in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: Include those instances with successful deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: Include those instance with failed deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * Skipped: Include those instance with skipped deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * Unknown: Include those instance with deployments in an unknown state.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceStatusFilter(java.util.Collection)} or
         * {@link #withInstanceStatusFilter(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param instanceStatusFilter
         *        A subset of instances to list by status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: Include those instance with pending deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InProgress: Include those instance where deployments are still in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: Include those instances with successful deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: Include those instance with failed deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Skipped: Include those instance with skipped deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Unknown: Include those instance with deployments in an unknown state.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder instanceStatusFilter(String... instanceStatusFilter);

        /**
         * <p>
         * A subset of instances to list by status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: Include those instance with pending deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * InProgress: Include those instance where deployments are still in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: Include those instances with successful deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: Include those instance with failed deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * Skipped: Include those instance with skipped deployments.
         * </p>
         * </li>
         * <li>
         * <p>
         * Unknown: Include those instance with deployments in an unknown state.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceStatusFilter(java.util.Collection)} or
         * {@link #withInstanceStatusFilter(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param instanceStatusFilter
         *        A subset of instances to list by status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: Include those instance with pending deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InProgress: Include those instance where deployments are still in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: Include those instances with successful deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: Include those instance with failed deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Skipped: Include those instance with skipped deployments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Unknown: Include those instance with deployments in an unknown state.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder instanceStatusFilter(InstanceStatus... instanceStatusFilter);

        /**
         * <p>
         * The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those
         * in the replacement environment ("GREEN"), for which you want to view instance information.
         * </p>
         * 
         * @param instanceTypeFilter
         *        The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or
         *        those in the replacement environment ("GREEN"), for which you want to view instance information.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceTypeFilter(Collection<String> instanceTypeFilter);

        /**
         * <p>
         * The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those
         * in the replacement environment ("GREEN"), for which you want to view instance information.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceTypeFilter(java.util.Collection)} or {@link #withInstanceTypeFilter(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param instanceTypeFilter
         *        The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or
         *        those in the replacement environment ("GREEN"), for which you want to view instance information.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceTypeFilter(String... instanceTypeFilter);

        /**
         * <p>
         * The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those
         * in the replacement environment ("GREEN"), for which you want to view instance information.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceTypeFilter(java.util.Collection)} or {@link #withInstanceTypeFilter(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param instanceTypeFilter
         *        The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or
         *        those in the replacement environment ("GREEN"), for which you want to view instance information.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceTypeFilter(InstanceType... instanceTypeFilter);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String nextToken;

        private List<String> instanceStatusFilter = new SdkInternalList<>();

        private List<String> instanceTypeFilter = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentInstancesRequest model) {
            setDeploymentId(model.deploymentId);
            setNextToken(model.nextToken);
            setInstanceStatusFilter(model.instanceStatusFilter);
            setInstanceTypeFilter(model.instanceTypeFilter);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getInstanceStatusFilter() {
            return instanceStatusFilter;
        }

        @Override
        public final Builder instanceStatusFilter(Collection<String> instanceStatusFilter) {
            this.instanceStatusFilter = InstanceStatusListCopier.copy(instanceStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatusFilter(String... instanceStatusFilter) {
            if (this.instanceStatusFilter == null) {
                this.instanceStatusFilter = new SdkInternalList<>(instanceStatusFilter.length);
            }
            for (String e : instanceStatusFilter) {
                this.instanceStatusFilter.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatusFilter(InstanceStatus... instanceStatusFilter) {
            if (this.instanceStatusFilter == null) {
                this.instanceStatusFilter = new SdkInternalList<String>(instanceStatusFilter.length);
            }
            for (InstanceStatus ele : instanceStatusFilter) {
                this.instanceStatusFilter.add(ele.toString());
            }
            return this;
        }

        public final void setInstanceStatusFilter(Collection<String> instanceStatusFilter) {
            this.instanceStatusFilter = InstanceStatusListCopier.copy(instanceStatusFilter);
        }

        @SafeVarargs
        public final void setInstanceStatusFilter(String... instanceStatusFilter) {
            if (this.instanceStatusFilter == null) {
                this.instanceStatusFilter = new SdkInternalList<>(instanceStatusFilter.length);
            }
            for (String e : instanceStatusFilter) {
                this.instanceStatusFilter.add(e);
            }
        }

        @SafeVarargs
        public final void setInstanceStatusFilter(InstanceStatus... instanceStatusFilter) {
            if (this.instanceStatusFilter == null) {
                this.instanceStatusFilter = new SdkInternalList<String>(instanceStatusFilter.length);
            }
            for (InstanceStatus ele : instanceStatusFilter) {
                this.instanceStatusFilter.add(ele.toString());
            }
        }

        public final Collection<String> getInstanceTypeFilter() {
            return instanceTypeFilter;
        }

        @Override
        public final Builder instanceTypeFilter(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = InstanceTypeListCopier.copy(instanceTypeFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeFilter(String... instanceTypeFilter) {
            if (this.instanceTypeFilter == null) {
                this.instanceTypeFilter = new SdkInternalList<>(instanceTypeFilter.length);
            }
            for (String e : instanceTypeFilter) {
                this.instanceTypeFilter.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeFilter(InstanceType... instanceTypeFilter) {
            if (this.instanceTypeFilter == null) {
                this.instanceTypeFilter = new SdkInternalList<String>(instanceTypeFilter.length);
            }
            for (InstanceType ele : instanceTypeFilter) {
                this.instanceTypeFilter.add(ele.toString());
            }
            return this;
        }

        public final void setInstanceTypeFilter(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = InstanceTypeListCopier.copy(instanceTypeFilter);
        }

        @SafeVarargs
        public final void setInstanceTypeFilter(String... instanceTypeFilter) {
            if (this.instanceTypeFilter == null) {
                this.instanceTypeFilter = new SdkInternalList<>(instanceTypeFilter.length);
            }
            for (String e : instanceTypeFilter) {
                this.instanceTypeFilter.add(e);
            }
        }

        @SafeVarargs
        public final void setInstanceTypeFilter(InstanceType... instanceTypeFilter) {
            if (this.instanceTypeFilter == null) {
                this.instanceTypeFilter = new SdkInternalList<String>(instanceTypeFilter.length);
            }
            for (InstanceType ele : instanceTypeFilter) {
                this.instanceTypeFilter.add(ele.toString());
            }
        }

        @Override
        public ListDeploymentInstancesRequest build() {
            return new ListDeploymentInstancesRequest(this);
        }
    }
}
