/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a ListDeploymentGroups operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDeploymentGroupsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDeploymentGroupsResponse.Builder, ListDeploymentGroupsResponse> {
    private final String applicationName;

    private final List<String> deploymentGroups;

    private final String nextToken;

    private ListDeploymentGroupsResponse(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroups = builder.deploymentGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The application name.
     * </p>
     * 
     * @return The application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * A list of corresponding deployment group names.
     * </p>
     * 
     * @return A list of corresponding deployment group names.
     */
    public List<String> deploymentGroups() {
        return deploymentGroups;
    }

    /**
     * <p>
     * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list
     * deployment groups call to return the next set of deployment groups in the list.
     * </p>
     * 
     * @return If a large amount of information is returned, an identifier is also returned. It can be used in a
     *         subsequent list deployment groups call to return the next set of deployment groups in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((deploymentGroups() == null) ? 0 : deploymentGroups().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentGroupsResponse)) {
            return false;
        }
        ListDeploymentGroupsResponse other = (ListDeploymentGroupsResponse) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroups() == null ^ this.deploymentGroups() == null) {
            return false;
        }
        if (other.deploymentGroups() != null && !other.deploymentGroups().equals(this.deploymentGroups())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (deploymentGroups() != null) {
            sb.append("DeploymentGroups: ").append(deploymentGroups()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDeploymentGroupsResponse> {
        /**
         * <p>
         * The application name.
         * </p>
         * 
         * @param applicationName
         *        The application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * A list of corresponding deployment group names.
         * </p>
         * 
         * @param deploymentGroups
         *        A list of corresponding deployment group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroups(Collection<String> deploymentGroups);

        /**
         * <p>
         * A list of corresponding deployment group names.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDeploymentGroups(java.util.Collection)} or {@link #withDeploymentGroups(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param deploymentGroups
         *        A list of corresponding deployment group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroups(String... deploymentGroups);

        /**
         * <p>
         * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent
         * list deployment groups call to return the next set of deployment groups in the list.
         * </p>
         * 
         * @param nextToken
         *        If a large amount of information is returned, an identifier is also returned. It can be used in a
         *        subsequent list deployment groups call to return the next set of deployment groups in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private List<String> deploymentGroups = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentGroupsResponse model) {
            setApplicationName(model.applicationName);
            setDeploymentGroups(model.deploymentGroups);
            setNextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<String> getDeploymentGroups() {
            return deploymentGroups;
        }

        @Override
        public final Builder deploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroups(String... deploymentGroups) {
            if (this.deploymentGroups == null) {
                this.deploymentGroups = new SdkInternalList<>(deploymentGroups.length);
            }
            for (String e : deploymentGroups) {
                this.deploymentGroups.add(e);
            }
            return this;
        }

        public final void setDeploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
        }

        @SafeVarargs
        public final void setDeploymentGroups(String... deploymentGroups) {
            if (this.deploymentGroups == null) {
                this.deploymentGroups = new SdkInternalList<>(deploymentGroups.length);
            }
            for (String e : deploymentGroups) {
                this.deploymentGroups.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentGroupsResponse build() {
            return new ListDeploymentGroupsResponse(this);
        }
    }
}
