/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a ListDeploymentConfigs operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDeploymentConfigsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDeploymentConfigsResponse.Builder, ListDeploymentConfigsResponse> {
    private final List<String> deploymentConfigsList;

    private final String nextToken;

    private ListDeploymentConfigsResponse(BuilderImpl builder) {
        this.deploymentConfigsList = builder.deploymentConfigsList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of deployment configurations, including built-in configurations such as CodeDeployDefault.OneAtATime.
     * </p>
     * 
     * @return A list of deployment configurations, including built-in configurations such as
     *         CodeDeployDefault.OneAtATime.
     */
    public List<String> deploymentConfigsList() {
        return deploymentConfigsList;
    }

    /**
     * <p>
     * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list
     * deployment configurations call to return the next set of deployment configurations in the list.
     * </p>
     * 
     * @return If a large amount of information is returned, an identifier is also returned. It can be used in a
     *         subsequent list deployment configurations call to return the next set of deployment configurations in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentConfigsList() == null) ? 0 : deploymentConfigsList().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentConfigsResponse)) {
            return false;
        }
        ListDeploymentConfigsResponse other = (ListDeploymentConfigsResponse) obj;
        if (other.deploymentConfigsList() == null ^ this.deploymentConfigsList() == null) {
            return false;
        }
        if (other.deploymentConfigsList() != null && !other.deploymentConfigsList().equals(this.deploymentConfigsList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentConfigsList() != null) {
            sb.append("DeploymentConfigsList: ").append(deploymentConfigsList()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDeploymentConfigsResponse> {
        /**
         * <p>
         * A list of deployment configurations, including built-in configurations such as CodeDeployDefault.OneAtATime.
         * </p>
         * 
         * @param deploymentConfigsList
         *        A list of deployment configurations, including built-in configurations such as
         *        CodeDeployDefault.OneAtATime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigsList(Collection<String> deploymentConfigsList);

        /**
         * <p>
         * A list of deployment configurations, including built-in configurations such as CodeDeployDefault.OneAtATime.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDeploymentConfigsList(java.util.Collection)} or
         * {@link #withDeploymentConfigsList(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param deploymentConfigsList
         *        A list of deployment configurations, including built-in configurations such as
         *        CodeDeployDefault.OneAtATime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigsList(String... deploymentConfigsList);

        /**
         * <p>
         * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent
         * list deployment configurations call to return the next set of deployment configurations in the list.
         * </p>
         * 
         * @param nextToken
         *        If a large amount of information is returned, an identifier is also returned. It can be used in a
         *        subsequent list deployment configurations call to return the next set of deployment configurations in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> deploymentConfigsList = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentConfigsResponse model) {
            setDeploymentConfigsList(model.deploymentConfigsList);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getDeploymentConfigsList() {
            return deploymentConfigsList;
        }

        @Override
        public final Builder deploymentConfigsList(Collection<String> deploymentConfigsList) {
            this.deploymentConfigsList = DeploymentConfigsListCopier.copy(deploymentConfigsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentConfigsList(String... deploymentConfigsList) {
            if (this.deploymentConfigsList == null) {
                this.deploymentConfigsList = new SdkInternalList<>(deploymentConfigsList.length);
            }
            for (String e : deploymentConfigsList) {
                this.deploymentConfigsList.add(e);
            }
            return this;
        }

        public final void setDeploymentConfigsList(Collection<String> deploymentConfigsList) {
            this.deploymentConfigsList = DeploymentConfigsListCopier.copy(deploymentConfigsList);
        }

        @SafeVarargs
        public final void setDeploymentConfigsList(String... deploymentConfigsList) {
            if (this.deploymentConfigsList == null) {
                this.deploymentConfigsList = new SdkInternalList<>(deploymentConfigsList.length);
            }
            for (String e : deploymentConfigsList) {
                this.deploymentConfigsList.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentConfigsResponse build() {
            return new ListDeploymentConfigsResponse(this);
        }
    }
}
