/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a ListApplications operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListApplicationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListApplicationsResponse.Builder, ListApplicationsResponse> {
    private final List<String> applications;

    private final String nextToken;

    private ListApplicationsResponse(BuilderImpl builder) {
        this.applications = builder.applications;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of application names.
     * </p>
     * 
     * @return A list of application names.
     */
    public List<String> applications() {
        return applications;
    }

    /**
     * <p>
     * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list
     * applications call to return the next set of applications, will also be returned. in the list.
     * </p>
     * 
     * @return If a large amount of information is returned, an identifier is also returned. It can be used in a
     *         subsequent list applications call to return the next set of applications, will also be returned. in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applications() == null) ? 0 : applications().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse) obj;
        if (other.applications() == null ^ this.applications() == null) {
            return false;
        }
        if (other.applications() != null && !other.applications().equals(this.applications())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applications() != null) {
            sb.append("Applications: ").append(applications()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListApplicationsResponse> {
        /**
         * <p>
         * A list of application names.
         * </p>
         * 
         * @param applications
         *        A list of application names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<String> applications);

        /**
         * <p>
         * A list of application names.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setApplications(java.util.Collection)} or {@link #withApplications(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param applications
         *        A list of application names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(String... applications);

        /**
         * <p>
         * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent
         * list applications call to return the next set of applications, will also be returned. in the list.
         * </p>
         * 
         * @param nextToken
         *        If a large amount of information is returned, an identifier is also returned. It can be used in a
         *        subsequent list applications call to return the next set of applications, will also be returned. in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> applications = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            setApplications(model.applications);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getApplications() {
            return applications;
        }

        @Override
        public final Builder applications(Collection<String> applications) {
            this.applications = ApplicationsListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(String... applications) {
            if (this.applications == null) {
                this.applications = new SdkInternalList<>(applications.length);
            }
            for (String e : applications) {
                this.applications.add(e);
            }
            return this;
        }

        public final void setApplications(Collection<String> applications) {
            this.applications = ApplicationsListCopier.copy(applications);
        }

        @SafeVarargs
        public final void setApplications(String... applications) {
            if (this.applications == null) {
                this.applications = new SdkInternalList<>(applications.length);
            }
            for (String e : applications) {
                this.applications.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }
    }
}
