/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a ListApplicationRevisions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListApplicationRevisionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListApplicationRevisionsResponse.Builder, ListApplicationRevisionsResponse> {
    private final List<RevisionLocation> revisions;

    private final String nextToken;

    private ListApplicationRevisionsResponse(BuilderImpl builder) {
        this.revisions = builder.revisions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of locations that contain the matching revisions.
     * </p>
     * 
     * @return A list of locations that contain the matching revisions.
     */
    public List<RevisionLocation> revisions() {
        return revisions;
    }

    /**
     * <p>
     * If a large amount of information is returned, an identifier will also be returned. It can be used in a subsequent
     * list application revisions call to return the next set of application revisions in the list.
     * </p>
     * 
     * @return If a large amount of information is returned, an identifier will also be returned. It can be used in a
     *         subsequent list application revisions call to return the next set of application revisions in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((revisions() == null) ? 0 : revisions().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationRevisionsResponse)) {
            return false;
        }
        ListApplicationRevisionsResponse other = (ListApplicationRevisionsResponse) obj;
        if (other.revisions() == null ^ this.revisions() == null) {
            return false;
        }
        if (other.revisions() != null && !other.revisions().equals(this.revisions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (revisions() != null) {
            sb.append("Revisions: ").append(revisions()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListApplicationRevisionsResponse> {
        /**
         * <p>
         * A list of locations that contain the matching revisions.
         * </p>
         * 
         * @param revisions
         *        A list of locations that contain the matching revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(Collection<RevisionLocation> revisions);

        /**
         * <p>
         * A list of locations that contain the matching revisions.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRevisions(java.util.Collection)} or {@link #withRevisions(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param revisions
         *        A list of locations that contain the matching revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(RevisionLocation... revisions);

        /**
         * <p>
         * If a large amount of information is returned, an identifier will also be returned. It can be used in a
         * subsequent list application revisions call to return the next set of application revisions in the list.
         * </p>
         * 
         * @param nextToken
         *        If a large amount of information is returned, an identifier will also be returned. It can be used in a
         *        subsequent list application revisions call to return the next set of application revisions in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<RevisionLocation> revisions = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationRevisionsResponse model) {
            setRevisions(model.revisions);
            setNextToken(model.nextToken);
        }

        public final Collection<RevisionLocation> getRevisions() {
            return revisions;
        }

        @Override
        public final Builder revisions(Collection<RevisionLocation> revisions) {
            this.revisions = RevisionLocationListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionLocation... revisions) {
            if (this.revisions == null) {
                this.revisions = new SdkInternalList<>(revisions.length);
            }
            for (RevisionLocation e : revisions) {
                this.revisions.add(e);
            }
            return this;
        }

        public final void setRevisions(Collection<RevisionLocation> revisions) {
            this.revisions = RevisionLocationListCopier.copy(revisions);
        }

        @SafeVarargs
        public final void setRevisions(RevisionLocation... revisions) {
            if (this.revisions == null) {
                this.revisions = new SdkInternalList<>(revisions.length);
            }
            for (RevisionLocation e : revisions) {
                this.revisions.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListApplicationRevisionsResponse build() {
            return new ListApplicationRevisionsResponse(this);
        }
    }
}
