/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a ListApplicationRevisions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListApplicationRevisionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListApplicationRevisionsRequest.Builder, ListApplicationRevisionsRequest> {
    private final String applicationName;

    private final String sortBy;

    private final String sortOrder;

    private final String s3Bucket;

    private final String s3KeyPrefix;

    private final String deployed;

    private final String nextToken;

    private ListApplicationRevisionsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.s3Bucket = builder.s3Bucket;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.deployed = builder.deployed;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
     * </p>
     * 
     * @return The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The column name to use to sort the list results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * registerTime: Sort by the time the revisions were registered with AWS CodeDeploy.
     * </p>
     * </li>
     * <li>
     * <p>
     * firstUsedTime: Sort by the time the revisions were first used in a deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * lastUsedTime: Sort by the time the revisions were last used in a deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If not specified or set to null, the results will be returned in an arbitrary order.
     * </p>
     * 
     * @return The column name to use to sort the list results:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         registerTime: Sort by the time the revisions were registered with AWS CodeDeploy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         firstUsedTime: Sort by the time the revisions were first used in a deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         lastUsedTime: Sort by the time the revisions were last used in a deployment.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If not specified or set to null, the results will be returned in an arbitrary order.
     * @see ApplicationRevisionSortBy
     */
    public String sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * The order in which to sort the list results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ascending: ascending order.
     * </p>
     * </li>
     * <li>
     * <p>
     * descending: descending order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If not specified, the results will be sorted in ascending order.
     * </p>
     * <p>
     * If set to null, the results will be sorted in an arbitrary order.
     * </p>
     * 
     * @return The order in which to sort the list results:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ascending: ascending order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         descending: descending order.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If not specified, the results will be sorted in ascending order.
     *         </p>
     *         <p>
     *         If set to null, the results will be sorted in an arbitrary order.
     * @see SortOrder
     */
    public String sortOrder() {
        return sortOrder;
    }

    /**
     * <p>
     * An Amazon S3 bucket name to limit the search for revisions.
     * </p>
     * <p>
     * If set to null, all of the user's buckets will be searched.
     * </p>
     * 
     * @return An Amazon S3 bucket name to limit the search for revisions.</p>
     *         <p>
     *         If set to null, all of the user's buckets will be searched.
     */
    public String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * A key prefix for the set of Amazon S3 objects to limit the search for revisions.
     * </p>
     * 
     * @return A key prefix for the set of Amazon S3 objects to limit the search for revisions.
     */
    public String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * Whether to list revisions based on whether the revision is the target revision of an deployment group:
     * </p>
     * <ul>
     * <li>
     * <p>
     * include: List revisions that are target revisions of a deployment group.
     * </p>
     * </li>
     * <li>
     * <p>
     * exclude: Do not list revisions that are target revisions of a deployment group.
     * </p>
     * </li>
     * <li>
     * <p>
     * ignore: List all revisions.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Whether to list revisions based on whether the revision is the target revision of an deployment
     *         group:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         include: List revisions that are target revisions of a deployment group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         exclude: Do not list revisions that are target revisions of a deployment group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ignore: List all revisions.
     *         </p>
     *         </li>
     * @see ListStateFilterAction
     */
    public String deployed() {
        return deployed;
    }

    /**
     * <p>
     * An identifier returned from the previous list application revisions call. It can be used to return the next set
     * of applications in the list.
     * </p>
     * 
     * @return An identifier returned from the previous list application revisions call. It can be used to return the
     *         next set of applications in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((sortBy() == null) ? 0 : sortBy().hashCode());
        hashCode = 31 * hashCode + ((sortOrder() == null) ? 0 : sortOrder().hashCode());
        hashCode = 31 * hashCode + ((s3Bucket() == null) ? 0 : s3Bucket().hashCode());
        hashCode = 31 * hashCode + ((s3KeyPrefix() == null) ? 0 : s3KeyPrefix().hashCode());
        hashCode = 31 * hashCode + ((deployed() == null) ? 0 : deployed().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationRevisionsRequest)) {
            return false;
        }
        ListApplicationRevisionsRequest other = (ListApplicationRevisionsRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.sortBy() == null ^ this.sortBy() == null) {
            return false;
        }
        if (other.sortBy() != null && !other.sortBy().equals(this.sortBy())) {
            return false;
        }
        if (other.sortOrder() == null ^ this.sortOrder() == null) {
            return false;
        }
        if (other.sortOrder() != null && !other.sortOrder().equals(this.sortOrder())) {
            return false;
        }
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3KeyPrefix() == null ^ this.s3KeyPrefix() == null) {
            return false;
        }
        if (other.s3KeyPrefix() != null && !other.s3KeyPrefix().equals(this.s3KeyPrefix())) {
            return false;
        }
        if (other.deployed() == null ^ this.deployed() == null) {
            return false;
        }
        if (other.deployed() != null && !other.deployed().equals(this.deployed())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (sortBy() != null) {
            sb.append("SortBy: ").append(sortBy()).append(",");
        }
        if (sortOrder() != null) {
            sb.append("SortOrder: ").append(sortOrder()).append(",");
        }
        if (s3Bucket() != null) {
            sb.append("S3Bucket: ").append(s3Bucket()).append(",");
        }
        if (s3KeyPrefix() != null) {
            sb.append("S3KeyPrefix: ").append(s3KeyPrefix()).append(",");
        }
        if (deployed() != null) {
            sb.append("Deployed: ").append(deployed()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListApplicationRevisionsRequest> {
        /**
         * <p>
         * The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
         * </p>
         * 
         * @param applicationName
         *        The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The column name to use to sort the list results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * registerTime: Sort by the time the revisions were registered with AWS CodeDeploy.
         * </p>
         * </li>
         * <li>
         * <p>
         * firstUsedTime: Sort by the time the revisions were first used in a deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * lastUsedTime: Sort by the time the revisions were last used in a deployment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If not specified or set to null, the results will be returned in an arbitrary order.
         * </p>
         * 
         * @param sortBy
         *        The column name to use to sort the list results:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        registerTime: Sort by the time the revisions were registered with AWS CodeDeploy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        firstUsedTime: Sort by the time the revisions were first used in a deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        lastUsedTime: Sort by the time the revisions were last used in a deployment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If not specified or set to null, the results will be returned in an arbitrary order.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationRevisionSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The column name to use to sort the list results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * registerTime: Sort by the time the revisions were registered with AWS CodeDeploy.
         * </p>
         * </li>
         * <li>
         * <p>
         * firstUsedTime: Sort by the time the revisions were first used in a deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * lastUsedTime: Sort by the time the revisions were last used in a deployment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If not specified or set to null, the results will be returned in an arbitrary order.
         * </p>
         * 
         * @param sortBy
         *        The column name to use to sort the list results:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        registerTime: Sort by the time the revisions were registered with AWS CodeDeploy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        firstUsedTime: Sort by the time the revisions were first used in a deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        lastUsedTime: Sort by the time the revisions were last used in a deployment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If not specified or set to null, the results will be returned in an arbitrary order.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationRevisionSortBy
         */
        Builder sortBy(ApplicationRevisionSortBy sortBy);

        /**
         * <p>
         * The order in which to sort the list results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ascending: ascending order.
         * </p>
         * </li>
         * <li>
         * <p>
         * descending: descending order.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If not specified, the results will be sorted in ascending order.
         * </p>
         * <p>
         * If set to null, the results will be sorted in an arbitrary order.
         * </p>
         * 
         * @param sortOrder
         *        The order in which to sort the list results:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ascending: ascending order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        descending: descending order.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If not specified, the results will be sorted in ascending order.
         *        </p>
         *        <p>
         *        If set to null, the results will be sorted in an arbitrary order.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order in which to sort the list results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ascending: ascending order.
         * </p>
         * </li>
         * <li>
         * <p>
         * descending: descending order.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If not specified, the results will be sorted in ascending order.
         * </p>
         * <p>
         * If set to null, the results will be sorted in an arbitrary order.
         * </p>
         * 
         * @param sortOrder
         *        The order in which to sort the list results:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ascending: ascending order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        descending: descending order.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If not specified, the results will be sorted in ascending order.
         *        </p>
         *        <p>
         *        If set to null, the results will be sorted in an arbitrary order.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * An Amazon S3 bucket name to limit the search for revisions.
         * </p>
         * <p>
         * If set to null, all of the user's buckets will be searched.
         * </p>
         * 
         * @param s3Bucket
         *        An Amazon S3 bucket name to limit the search for revisions.</p>
         *        <p>
         *        If set to null, all of the user's buckets will be searched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * A key prefix for the set of Amazon S3 objects to limit the search for revisions.
         * </p>
         * 
         * @param s3KeyPrefix
         *        A key prefix for the set of Amazon S3 objects to limit the search for revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * Whether to list revisions based on whether the revision is the target revision of an deployment group:
         * </p>
         * <ul>
         * <li>
         * <p>
         * include: List revisions that are target revisions of a deployment group.
         * </p>
         * </li>
         * <li>
         * <p>
         * exclude: Do not list revisions that are target revisions of a deployment group.
         * </p>
         * </li>
         * <li>
         * <p>
         * ignore: List all revisions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deployed
         *        Whether to list revisions based on whether the revision is the target revision of an deployment
         *        group:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        include: List revisions that are target revisions of a deployment group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        exclude: Do not list revisions that are target revisions of a deployment group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ignore: List all revisions.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListStateFilterAction
         */
        Builder deployed(String deployed);

        /**
         * <p>
         * Whether to list revisions based on whether the revision is the target revision of an deployment group:
         * </p>
         * <ul>
         * <li>
         * <p>
         * include: List revisions that are target revisions of a deployment group.
         * </p>
         * </li>
         * <li>
         * <p>
         * exclude: Do not list revisions that are target revisions of a deployment group.
         * </p>
         * </li>
         * <li>
         * <p>
         * ignore: List all revisions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deployed
         *        Whether to list revisions based on whether the revision is the target revision of an deployment
         *        group:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        include: List revisions that are target revisions of a deployment group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        exclude: Do not list revisions that are target revisions of a deployment group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ignore: List all revisions.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListStateFilterAction
         */
        Builder deployed(ListStateFilterAction deployed);

        /**
         * <p>
         * An identifier returned from the previous list application revisions call. It can be used to return the next
         * set of applications in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier returned from the previous list application revisions call. It can be used to return the
         *        next set of applications in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private String sortBy;

        private String sortOrder;

        private String s3Bucket;

        private String s3KeyPrefix;

        private String deployed;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationRevisionsRequest model) {
            setApplicationName(model.applicationName);
            setSortBy(model.sortBy);
            setSortOrder(model.sortOrder);
            setS3Bucket(model.s3Bucket);
            setS3KeyPrefix(model.s3KeyPrefix);
            setDeployed(model.deployed);
            setNextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getSortBy() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ApplicationRevisionSortBy sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final void setSortBy(ApplicationRevisionSortBy sortBy) {
            this.sortBy(sortBy.toString());
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final void setSortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getDeployed() {
            return deployed;
        }

        @Override
        public final Builder deployed(String deployed) {
            this.deployed = deployed;
            return this;
        }

        @Override
        public final Builder deployed(ListStateFilterAction deployed) {
            this.deployed(deployed.toString());
            return this;
        }

        public final void setDeployed(String deployed) {
            this.deployed = deployed;
        }

        public final void setDeployed(ListStateFilterAction deployed) {
            this.deployed(deployed.toString());
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListApplicationRevisionsRequest build() {
            return new ListApplicationRevisionsRequest(this);
        }
    }
}
