/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.transform.LifecycleEventMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment lifecycle event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LifecycleEvent implements StructuredPojo, ToCopyableBuilder<LifecycleEvent.Builder, LifecycleEvent> {
    private final String lifecycleEventName;

    private final Diagnostics diagnostics;

    private final Date startTime;

    private final Date endTime;

    private final String status;

    private LifecycleEvent(BuilderImpl builder) {
        this.lifecycleEventName = builder.lifecycleEventName;
        this.diagnostics = builder.diagnostics;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The deployment lifecycle event name, such as ApplicationStop, BeforeInstall, AfterInstall, ApplicationStart, or
     * ValidateService.
     * </p>
     * 
     * @return The deployment lifecycle event name, such as ApplicationStop, BeforeInstall, AfterInstall,
     *         ApplicationStart, or ValidateService.
     */
    public String lifecycleEventName() {
        return lifecycleEventName;
    }

    /**
     * <p>
     * Diagnostic information about the deployment lifecycle event.
     * </p>
     * 
     * @return Diagnostic information about the deployment lifecycle event.
     */
    public Diagnostics diagnostics() {
        return diagnostics;
    }

    /**
     * <p>
     * A timestamp indicating when the deployment lifecycle event started.
     * </p>
     * 
     * @return A timestamp indicating when the deployment lifecycle event started.
     */
    public Date startTime() {
        return startTime;
    }

    /**
     * <p>
     * A timestamp indicating when the deployment lifecycle event ended.
     * </p>
     * 
     * @return A timestamp indicating when the deployment lifecycle event ended.
     */
    public Date endTime() {
        return endTime;
    }

    /**
     * <p>
     * The deployment lifecycle event status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending: The deployment lifecycle event is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * InProgress: The deployment lifecycle event is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded: The deployment lifecycle event ran successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed: The deployment lifecycle event has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Skipped: The deployment lifecycle event has been skipped.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unknown: The deployment lifecycle event is unknown.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The deployment lifecycle event status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: The deployment lifecycle event is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         InProgress: The deployment lifecycle event is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded: The deployment lifecycle event ran successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed: The deployment lifecycle event has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Skipped: The deployment lifecycle event has been skipped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Unknown: The deployment lifecycle event is unknown.
     *         </p>
     *         </li>
     * @see LifecycleEventStatus
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((lifecycleEventName() == null) ? 0 : lifecycleEventName().hashCode());
        hashCode = 31 * hashCode + ((diagnostics() == null) ? 0 : diagnostics().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleEvent)) {
            return false;
        }
        LifecycleEvent other = (LifecycleEvent) obj;
        if (other.lifecycleEventName() == null ^ this.lifecycleEventName() == null) {
            return false;
        }
        if (other.lifecycleEventName() != null && !other.lifecycleEventName().equals(this.lifecycleEventName())) {
            return false;
        }
        if (other.diagnostics() == null ^ this.diagnostics() == null) {
            return false;
        }
        if (other.diagnostics() != null && !other.diagnostics().equals(this.diagnostics())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (lifecycleEventName() != null) {
            sb.append("LifecycleEventName: ").append(lifecycleEventName()).append(",");
        }
        if (diagnostics() != null) {
            sb.append("Diagnostics: ").append(diagnostics()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LifecycleEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LifecycleEvent> {
        /**
         * <p>
         * The deployment lifecycle event name, such as ApplicationStop, BeforeInstall, AfterInstall, ApplicationStart,
         * or ValidateService.
         * </p>
         * 
         * @param lifecycleEventName
         *        The deployment lifecycle event name, such as ApplicationStop, BeforeInstall, AfterInstall,
         *        ApplicationStart, or ValidateService.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleEventName(String lifecycleEventName);

        /**
         * <p>
         * Diagnostic information about the deployment lifecycle event.
         * </p>
         * 
         * @param diagnostics
         *        Diagnostic information about the deployment lifecycle event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diagnostics(Diagnostics diagnostics);

        /**
         * <p>
         * A timestamp indicating when the deployment lifecycle event started.
         * </p>
         * 
         * @param startTime
         *        A timestamp indicating when the deployment lifecycle event started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Date startTime);

        /**
         * <p>
         * A timestamp indicating when the deployment lifecycle event ended.
         * </p>
         * 
         * @param endTime
         *        A timestamp indicating when the deployment lifecycle event ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Date endTime);

        /**
         * <p>
         * The deployment lifecycle event status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The deployment lifecycle event is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * InProgress: The deployment lifecycle event is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: The deployment lifecycle event ran successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: The deployment lifecycle event has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Skipped: The deployment lifecycle event has been skipped.
         * </p>
         * </li>
         * <li>
         * <p>
         * Unknown: The deployment lifecycle event is unknown.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The deployment lifecycle event status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The deployment lifecycle event is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InProgress: The deployment lifecycle event is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: The deployment lifecycle event ran successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: The deployment lifecycle event has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Skipped: The deployment lifecycle event has been skipped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Unknown: The deployment lifecycle event is unknown.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleEventStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The deployment lifecycle event status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The deployment lifecycle event is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * InProgress: The deployment lifecycle event is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: The deployment lifecycle event ran successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: The deployment lifecycle event has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Skipped: The deployment lifecycle event has been skipped.
         * </p>
         * </li>
         * <li>
         * <p>
         * Unknown: The deployment lifecycle event is unknown.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The deployment lifecycle event status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The deployment lifecycle event is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InProgress: The deployment lifecycle event is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: The deployment lifecycle event ran successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: The deployment lifecycle event has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Skipped: The deployment lifecycle event has been skipped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Unknown: The deployment lifecycle event is unknown.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleEventStatus
         */
        Builder status(LifecycleEventStatus status);
    }

    private static final class BuilderImpl implements Builder {
        private String lifecycleEventName;

        private Diagnostics diagnostics;

        private Date startTime;

        private Date endTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleEvent model) {
            setLifecycleEventName(model.lifecycleEventName);
            setDiagnostics(model.diagnostics);
            setStartTime(model.startTime);
            setEndTime(model.endTime);
            setStatus(model.status);
        }

        public final String getLifecycleEventName() {
            return lifecycleEventName;
        }

        @Override
        public final Builder lifecycleEventName(String lifecycleEventName) {
            this.lifecycleEventName = lifecycleEventName;
            return this;
        }

        public final void setLifecycleEventName(String lifecycleEventName) {
            this.lifecycleEventName = lifecycleEventName;
        }

        public final Diagnostics getDiagnostics() {
            return diagnostics;
        }

        @Override
        public final Builder diagnostics(Diagnostics diagnostics) {
            this.diagnostics = diagnostics;
            return this;
        }

        public final void setDiagnostics(Diagnostics diagnostics) {
            this.diagnostics = diagnostics;
        }

        public final Date getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
        }

        public final Date getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy(endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy(endTime);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecycleEventStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(LifecycleEventStatus status) {
            this.status(status.toString());
        }

        @Override
        public LifecycleEvent build() {
            return new LifecycleEvent(this);
        }
    }
}
