/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.transform.LastDeploymentInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the most recent attempted or successful deployment to a deployment group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LastDeploymentInfo implements StructuredPojo, ToCopyableBuilder<LastDeploymentInfo.Builder, LastDeploymentInfo> {
    private final String deploymentId;

    private final String status;

    private final Date endTime;

    private final Date createTime;

    private LastDeploymentInfo(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.status = builder.status;
        this.endTime = builder.endTime;
        this.createTime = builder.createTime;
    }

    /**
     * <p>
     * The deployment ID.
     * </p>
     * 
     * @return The deployment ID.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The status of the most recent deployment.
     * </p>
     * 
     * @return The status of the most recent deployment.
     * @see DeploymentStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A timestamp indicating when the most recent deployment to the deployment group completed.
     * </p>
     * 
     * @return A timestamp indicating when the most recent deployment to the deployment group completed.
     */
    public Date endTime() {
        return endTime;
    }

    /**
     * <p>
     * A timestamp indicating when the most recent deployment to the deployment group started.
     * </p>
     * 
     * @return A timestamp indicating when the most recent deployment to the deployment group started.
     */
    public Date createTime() {
        return createTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentId() == null) ? 0 : deploymentId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        hashCode = 31 * hashCode + ((createTime() == null) ? 0 : createTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastDeploymentInfo)) {
            return false;
        }
        LastDeploymentInfo other = (LastDeploymentInfo) obj;
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentId() != null) {
            sb.append("DeploymentId: ").append(deploymentId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (createTime() != null) {
            sb.append("CreateTime: ").append(createTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LastDeploymentInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LastDeploymentInfo> {
        /**
         * <p>
         * The deployment ID.
         * </p>
         * 
         * @param deploymentId
         *        The deployment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The status of the most recent deployment.
         * </p>
         * 
         * @param status
         *        The status of the most recent deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the most recent deployment.
         * </p>
         * 
         * @param status
         *        The status of the most recent deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(DeploymentStatus status);

        /**
         * <p>
         * A timestamp indicating when the most recent deployment to the deployment group completed.
         * </p>
         * 
         * @param endTime
         *        A timestamp indicating when the most recent deployment to the deployment group completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Date endTime);

        /**
         * <p>
         * A timestamp indicating when the most recent deployment to the deployment group started.
         * </p>
         * 
         * @param createTime
         *        A timestamp indicating when the most recent deployment to the deployment group started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Date createTime);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String status;

        private Date endTime;

        private Date createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LastDeploymentInfo model) {
            setDeploymentId(model.deploymentId);
            setStatus(model.status);
            setEndTime(model.endTime);
            setCreateTime(model.createTime);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(DeploymentStatus status) {
            this.status(status.toString());
        }

        public final Date getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy(endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy(endTime);
        }

        public final Date getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Date createTime) {
            this.createTime = StandardMemberCopier.copy(createTime);
            return this;
        }

        public final void setCreateTime(Date createTime) {
            this.createTime = StandardMemberCopier.copy(createTime);
        }

        @Override
        public LastDeploymentInfo build() {
            return new LastDeploymentInfo(this);
        }
    }
}
