/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.transform.InstanceSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an instance in a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceSummary implements StructuredPojo, ToCopyableBuilder<InstanceSummary.Builder, InstanceSummary> {
    private final String deploymentId;

    private final String instanceId;

    private final String status;

    private final Date lastUpdatedAt;

    private final List<LifecycleEvent> lifecycleEvents;

    private final String instanceType;

    private InstanceSummary(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.instanceId = builder.instanceId;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleEvents = builder.lifecycleEvents;
        this.instanceType = builder.instanceType;
    }

    /**
     * <p>
     * The deployment ID.
     * </p>
     * 
     * @return The deployment ID.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The deployment status for this instance:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending: The deployment is pending for this instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * In Progress: The deployment is in progress for this instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded: The deployment has succeeded for this instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed: The deployment has failed for this instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Skipped: The deployment has been skipped for this instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unknown: The deployment status is unknown for this instance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The deployment status for this instance:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: The deployment is pending for this instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In Progress: The deployment is in progress for this instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded: The deployment has succeeded for this instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed: The deployment has failed for this instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Skipped: The deployment has been skipped for this instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Unknown: The deployment status is unknown for this instance.
     *         </p>
     *         </li>
     * @see InstanceStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A timestamp indicating when the instance information was last updated.
     * </p>
     * 
     * @return A timestamp indicating when the instance information was last updated.
     */
    public Date lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A list of lifecycle events for this instance.
     * </p>
     * 
     * @return A list of lifecycle events for this instance.
     */
    public List<LifecycleEvent> lifecycleEvents() {
        return lifecycleEvents;
    }

    /**
     * <p>
     * Information about which environment an instance belongs to in a blue/green deployment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * BLUE: The instance is part of the original environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * GREEN: The instance is part of the replacement environment.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about which environment an instance belongs to in a blue/green deployment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         BLUE: The instance is part of the original environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GREEN: The instance is part of the replacement environment.
     *         </p>
     *         </li>
     * @see InstanceType
     */
    public String instanceType() {
        return instanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentId() == null) ? 0 : deploymentId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedAt() == null) ? 0 : lastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + ((lifecycleEvents() == null) ? 0 : lifecycleEvents().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary) obj;
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.lastUpdatedAt() == null ^ this.lastUpdatedAt() == null) {
            return false;
        }
        if (other.lastUpdatedAt() != null && !other.lastUpdatedAt().equals(this.lastUpdatedAt())) {
            return false;
        }
        if (other.lifecycleEvents() == null ^ this.lifecycleEvents() == null) {
            return false;
        }
        if (other.lifecycleEvents() != null && !other.lifecycleEvents().equals(this.lifecycleEvents())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentId() != null) {
            sb.append("DeploymentId: ").append(deploymentId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (lastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(lastUpdatedAt()).append(",");
        }
        if (lifecycleEvents() != null) {
            sb.append("LifecycleEvents: ").append(lifecycleEvents()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceSummary> {
        /**
         * <p>
         * The deployment ID.
         * </p>
         * 
         * @param deploymentId
         *        The deployment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The deployment status for this instance:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The deployment is pending for this instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * In Progress: The deployment is in progress for this instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: The deployment has succeeded for this instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: The deployment has failed for this instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Skipped: The deployment has been skipped for this instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Unknown: The deployment status is unknown for this instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The deployment status for this instance:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The deployment is pending for this instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In Progress: The deployment is in progress for this instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: The deployment has succeeded for this instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: The deployment has failed for this instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Skipped: The deployment has been skipped for this instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Unknown: The deployment status is unknown for this instance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The deployment status for this instance:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The deployment is pending for this instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * In Progress: The deployment is in progress for this instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: The deployment has succeeded for this instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: The deployment has failed for this instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Skipped: The deployment has been skipped for this instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Unknown: The deployment status is unknown for this instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The deployment status for this instance:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The deployment is pending for this instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In Progress: The deployment is in progress for this instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: The deployment has succeeded for this instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: The deployment has failed for this instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Skipped: The deployment has been skipped for this instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Unknown: The deployment status is unknown for this instance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder status(InstanceStatus status);

        /**
         * <p>
         * A timestamp indicating when the instance information was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        A timestamp indicating when the instance information was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Date lastUpdatedAt);

        /**
         * <p>
         * A list of lifecycle events for this instance.
         * </p>
         * 
         * @param lifecycleEvents
         *        A list of lifecycle events for this instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleEvents(Collection<LifecycleEvent> lifecycleEvents);

        /**
         * <p>
         * A list of lifecycle events for this instance.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLifecycleEvents(java.util.Collection)} or {@link #withLifecycleEvents(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param lifecycleEvents
         *        A list of lifecycle events for this instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleEvents(LifecycleEvent... lifecycleEvents);

        /**
         * <p>
         * Information about which environment an instance belongs to in a blue/green deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * BLUE: The instance is part of the original environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * GREEN: The instance is part of the replacement environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceType
         *        Information about which environment an instance belongs to in a blue/green deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        BLUE: The instance is part of the original environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GREEN: The instance is part of the replacement environment.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Information about which environment an instance belongs to in a blue/green deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * BLUE: The instance is part of the original environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * GREEN: The instance is part of the replacement environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceType
         *        Information about which environment an instance belongs to in a blue/green deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        BLUE: The instance is part of the original environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GREEN: The instance is part of the replacement environment.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String instanceId;

        private String status;

        private Date lastUpdatedAt;

        private List<LifecycleEvent> lifecycleEvents = new SdkInternalList<>();

        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSummary model) {
            setDeploymentId(model.deploymentId);
            setInstanceId(model.instanceId);
            setStatus(model.status);
            setLastUpdatedAt(model.lastUpdatedAt);
            setLifecycleEvents(model.lifecycleEvents);
            setInstanceType(model.instanceType);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(InstanceStatus status) {
            this.status(status.toString());
        }

        public final Date getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Date lastUpdatedAt) {
            this.lastUpdatedAt = StandardMemberCopier.copy(lastUpdatedAt);
            return this;
        }

        public final void setLastUpdatedAt(Date lastUpdatedAt) {
            this.lastUpdatedAt = StandardMemberCopier.copy(lastUpdatedAt);
        }

        public final Collection<LifecycleEvent> getLifecycleEvents() {
            return lifecycleEvents;
        }

        @Override
        public final Builder lifecycleEvents(Collection<LifecycleEvent> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copy(lifecycleEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleEvents(LifecycleEvent... lifecycleEvents) {
            if (this.lifecycleEvents == null) {
                this.lifecycleEvents = new SdkInternalList<>(lifecycleEvents.length);
            }
            for (LifecycleEvent e : lifecycleEvents) {
                this.lifecycleEvents.add(e);
            }
            return this;
        }

        public final void setLifecycleEvents(Collection<LifecycleEvent> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copy(lifecycleEvents);
        }

        @SafeVarargs
        public final void setLifecycleEvents(LifecycleEvent... lifecycleEvents) {
            if (this.lifecycleEvents == null) {
                this.lifecycleEvents = new SdkInternalList<>(lifecycleEvents.length);
            }
            for (LifecycleEvent e : lifecycleEvents) {
                this.lifecycleEvents.add(e);
            }
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        @Override
        public InstanceSummary build() {
            return new InstanceSummary(this);
        }
    }
}
