/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.transform.InstanceInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an on-premises instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceInfo implements StructuredPojo, ToCopyableBuilder<InstanceInfo.Builder, InstanceInfo> {
    private final String instanceName;

    private final String iamSessionArn;

    private final String iamUserArn;

    private final String instanceArn;

    private final Date registerTime;

    private final Date deregisterTime;

    private final List<Tag> tags;

    private InstanceInfo(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.iamSessionArn = builder.iamSessionArn;
        this.iamUserArn = builder.iamUserArn;
        this.instanceArn = builder.instanceArn;
        this.registerTime = builder.registerTime;
        this.deregisterTime = builder.deregisterTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the on-premises instance.
     * </p>
     * 
     * @return The name of the on-premises instance.
     */
    public String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The ARN of the IAM session associated with the on-premises instance.
     * </p>
     * 
     * @return The ARN of the IAM session associated with the on-premises instance.
     */
    public String iamSessionArn() {
        return iamSessionArn;
    }

    /**
     * <p>
     * The IAM user ARN associated with the on-premises instance.
     * </p>
     * 
     * @return The IAM user ARN associated with the on-premises instance.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * The ARN of the on-premises instance.
     * </p>
     * 
     * @return The ARN of the on-premises instance.
     */
    public String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The time at which the on-premises instance was registered.
     * </p>
     * 
     * @return The time at which the on-premises instance was registered.
     */
    public Date registerTime() {
        return registerTime;
    }

    /**
     * <p>
     * If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.
     * </p>
     * 
     * @return If the on-premises instance was deregistered, the time at which the on-premises instance was
     *         deregistered.
     */
    public Date deregisterTime() {
        return deregisterTime;
    }

    /**
     * <p>
     * The tags currently associated with the on-premises instance.
     * </p>
     * 
     * @return The tags currently associated with the on-premises instance.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceName() == null) ? 0 : instanceName().hashCode());
        hashCode = 31 * hashCode + ((iamSessionArn() == null) ? 0 : iamSessionArn().hashCode());
        hashCode = 31 * hashCode + ((iamUserArn() == null) ? 0 : iamUserArn().hashCode());
        hashCode = 31 * hashCode + ((instanceArn() == null) ? 0 : instanceArn().hashCode());
        hashCode = 31 * hashCode + ((registerTime() == null) ? 0 : registerTime().hashCode());
        hashCode = 31 * hashCode + ((deregisterTime() == null) ? 0 : deregisterTime().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo other = (InstanceInfo) obj;
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        if (other.iamSessionArn() == null ^ this.iamSessionArn() == null) {
            return false;
        }
        if (other.iamSessionArn() != null && !other.iamSessionArn().equals(this.iamSessionArn())) {
            return false;
        }
        if (other.iamUserArn() == null ^ this.iamUserArn() == null) {
            return false;
        }
        if (other.iamUserArn() != null && !other.iamUserArn().equals(this.iamUserArn())) {
            return false;
        }
        if (other.instanceArn() == null ^ this.instanceArn() == null) {
            return false;
        }
        if (other.instanceArn() != null && !other.instanceArn().equals(this.instanceArn())) {
            return false;
        }
        if (other.registerTime() == null ^ this.registerTime() == null) {
            return false;
        }
        if (other.registerTime() != null && !other.registerTime().equals(this.registerTime())) {
            return false;
        }
        if (other.deregisterTime() == null ^ this.deregisterTime() == null) {
            return false;
        }
        if (other.deregisterTime() != null && !other.deregisterTime().equals(this.deregisterTime())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceName() != null) {
            sb.append("InstanceName: ").append(instanceName()).append(",");
        }
        if (iamSessionArn() != null) {
            sb.append("IamSessionArn: ").append(iamSessionArn()).append(",");
        }
        if (iamUserArn() != null) {
            sb.append("IamUserArn: ").append(iamUserArn()).append(",");
        }
        if (instanceArn() != null) {
            sb.append("InstanceArn: ").append(instanceArn()).append(",");
        }
        if (registerTime() != null) {
            sb.append("RegisterTime: ").append(registerTime()).append(",");
        }
        if (deregisterTime() != null) {
            sb.append("DeregisterTime: ").append(deregisterTime()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceInfo> {
        /**
         * <p>
         * The name of the on-premises instance.
         * </p>
         * 
         * @param instanceName
         *        The name of the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The ARN of the IAM session associated with the on-premises instance.
         * </p>
         * 
         * @param iamSessionArn
         *        The ARN of the IAM session associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamSessionArn(String iamSessionArn);

        /**
         * <p>
         * The IAM user ARN associated with the on-premises instance.
         * </p>
         * 
         * @param iamUserArn
         *        The IAM user ARN associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * The ARN of the on-premises instance.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The time at which the on-premises instance was registered.
         * </p>
         * 
         * @param registerTime
         *        The time at which the on-premises instance was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registerTime(Date registerTime);

        /**
         * <p>
         * If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.
         * </p>
         * 
         * @param deregisterTime
         *        If the on-premises instance was deregistered, the time at which the on-premises instance was
         *        deregistered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregisterTime(Date deregisterTime);

        /**
         * <p>
         * The tags currently associated with the on-premises instance.
         * </p>
         * 
         * @param tags
         *        The tags currently associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags currently associated with the on-premises instance.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
         * existing values.
         * </p>
         * 
         * @param tags
         *        The tags currently associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceName;

        private String iamSessionArn;

        private String iamUserArn;

        private String instanceArn;

        private Date registerTime;

        private Date deregisterTime;

        private List<Tag> tags = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInfo model) {
            setInstanceName(model.instanceName);
            setIamSessionArn(model.iamSessionArn);
            setIamUserArn(model.iamUserArn);
            setInstanceArn(model.instanceArn);
            setRegisterTime(model.registerTime);
            setDeregisterTime(model.deregisterTime);
            setTags(model.tags);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getIamSessionArn() {
            return iamSessionArn;
        }

        @Override
        public final Builder iamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
            return this;
        }

        public final void setIamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final Date getRegisterTime() {
            return registerTime;
        }

        @Override
        public final Builder registerTime(Date registerTime) {
            this.registerTime = StandardMemberCopier.copy(registerTime);
            return this;
        }

        public final void setRegisterTime(Date registerTime) {
            this.registerTime = StandardMemberCopier.copy(registerTime);
        }

        public final Date getDeregisterTime() {
            return deregisterTime;
        }

        @Override
        public final Builder deregisterTime(Date deregisterTime) {
            this.deregisterTime = StandardMemberCopier.copy(deregisterTime);
            return this;
        }

        public final void setDeregisterTime(Date deregisterTime) {
            this.deregisterTime = StandardMemberCopier.copy(deregisterTime);
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList<>(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList<>(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        @Override
        public InstanceInfo build() {
            return new InstanceInfo(this);
        }
    }
}
