/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.GreenFleetProvisioningOptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the instances that belong to the replacement environment in a blue/green deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GreenFleetProvisioningOption implements StructuredPojo,
        ToCopyableBuilder<GreenFleetProvisioningOption.Builder, GreenFleetProvisioningOption> {
    private final String action;

    private GreenFleetProvisioningOption(BuilderImpl builder) {
        this.action = builder.action;
    }

    /**
     * <p>
     * The method used to add instances to a replacement environment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISCOVER_EXISTING: Use instances that already exist or will be created manually.
     * </p>
     * </li>
     * <li>
     * <p>
     * COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create instances in a new
     * Auto Scaling group.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The method used to add instances to a replacement environment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DISCOVER_EXISTING: Use instances that already exist or will be created manually.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create instances
     *         in a new Auto Scaling group.
     *         </p>
     *         </li>
     * @see GreenFleetProvisioningAction
     */
    public String action() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((action() == null) ? 0 : action().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GreenFleetProvisioningOption)) {
            return false;
        }
        GreenFleetProvisioningOption other = (GreenFleetProvisioningOption) obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (action() != null) {
            sb.append("Action: ").append(action()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GreenFleetProvisioningOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, GreenFleetProvisioningOption> {
        /**
         * <p>
         * The method used to add instances to a replacement environment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISCOVER_EXISTING: Use instances that already exist or will be created manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create instances in a
         * new Auto Scaling group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The method used to add instances to a replacement environment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISCOVER_EXISTING: Use instances that already exist or will be created manually.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create
         *        instances in a new Auto Scaling group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GreenFleetProvisioningAction
         */
        Builder action(String action);

        /**
         * <p>
         * The method used to add instances to a replacement environment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISCOVER_EXISTING: Use instances that already exist or will be created manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create instances in a
         * new Auto Scaling group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The method used to add instances to a replacement environment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISCOVER_EXISTING: Use instances that already exist or will be created manually.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create
         *        instances in a new Auto Scaling group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GreenFleetProvisioningAction
         */
        Builder action(GreenFleetProvisioningAction action);
    }

    private static final class BuilderImpl implements Builder {
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(GreenFleetProvisioningOption model) {
            setAction(model.action);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GreenFleetProvisioningAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final void setAction(GreenFleetProvisioningAction action) {
            this.action(action.toString());
        }

        @Override
        public GreenFleetProvisioningOption build() {
            return new GreenFleetProvisioningOption(this);
        }
    }
}
