/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.GitHubLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the location of application artifacts stored in GitHub.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GitHubLocation implements StructuredPojo, ToCopyableBuilder<GitHubLocation.Builder, GitHubLocation> {
    private final String repository;

    private final String commitId;

    private GitHubLocation(BuilderImpl builder) {
        this.repository = builder.repository;
        this.commitId = builder.commitId;
    }

    /**
     * <p>
     * The GitHub account and repository pair that stores a reference to the commit that represents the bundled
     * artifacts for the application revision.
     * </p>
     * <p>
     * Specified as account/repository.
     * </p>
     * 
     * @return The GitHub account and repository pair that stores a reference to the commit that represents the bundled
     *         artifacts for the application revision. </p>
     *         <p>
     *         Specified as account/repository.
     */
    public String repository() {
        return repository;
    }

    /**
     * <p>
     * The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision.
     * </p>
     * 
     * @return The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application
     *         revision.
     */
    public String commitId() {
        return commitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((repository() == null) ? 0 : repository().hashCode());
        hashCode = 31 * hashCode + ((commitId() == null) ? 0 : commitId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitHubLocation)) {
            return false;
        }
        GitHubLocation other = (GitHubLocation) obj;
        if (other.repository() == null ^ this.repository() == null) {
            return false;
        }
        if (other.repository() != null && !other.repository().equals(this.repository())) {
            return false;
        }
        if (other.commitId() == null ^ this.commitId() == null) {
            return false;
        }
        if (other.commitId() != null && !other.commitId().equals(this.commitId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (repository() != null) {
            sb.append("Repository: ").append(repository()).append(",");
        }
        if (commitId() != null) {
            sb.append("CommitId: ").append(commitId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GitHubLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, GitHubLocation> {
        /**
         * <p>
         * The GitHub account and repository pair that stores a reference to the commit that represents the bundled
         * artifacts for the application revision.
         * </p>
         * <p>
         * Specified as account/repository.
         * </p>
         * 
         * @param repository
         *        The GitHub account and repository pair that stores a reference to the commit that represents the
         *        bundled artifacts for the application revision. </p>
         *        <p>
         *        Specified as account/repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision.
         * </p>
         * 
         * @param commitId
         *        The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application
         *        revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);
    }

    private static final class BuilderImpl implements Builder {
        private String repository;

        private String commitId;

        private BuilderImpl() {
        }

        private BuilderImpl(GitHubLocation model) {
            setRepository(model.repository);
            setCommitId(model.commitId);
        }

        public final String getRepository() {
            return repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getCommitId() {
            return commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public GitHubLocation build() {
            return new GitHubLocation(this);
        }
    }
}
