/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a GetOnPremisesInstance operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOnPremisesInstanceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetOnPremisesInstanceResponse.Builder, GetOnPremisesInstanceResponse> {
    private final InstanceInfo instanceInfo;

    private GetOnPremisesInstanceResponse(BuilderImpl builder) {
        this.instanceInfo = builder.instanceInfo;
    }

    /**
     * <p>
     * Information about the on-premises instance.
     * </p>
     * 
     * @return Information about the on-premises instance.
     */
    public InstanceInfo instanceInfo() {
        return instanceInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceInfo() == null) ? 0 : instanceInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOnPremisesInstanceResponse)) {
            return false;
        }
        GetOnPremisesInstanceResponse other = (GetOnPremisesInstanceResponse) obj;
        if (other.instanceInfo() == null ^ this.instanceInfo() == null) {
            return false;
        }
        if (other.instanceInfo() != null && !other.instanceInfo().equals(this.instanceInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceInfo() != null) {
            sb.append("InstanceInfo: ").append(instanceInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetOnPremisesInstanceResponse> {
        /**
         * <p>
         * Information about the on-premises instance.
         * </p>
         * 
         * @param instanceInfo
         *        Information about the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInfo(InstanceInfo instanceInfo);
    }

    private static final class BuilderImpl implements Builder {
        private InstanceInfo instanceInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOnPremisesInstanceResponse model) {
            setInstanceInfo(model.instanceInfo);
        }

        public final InstanceInfo getInstanceInfo() {
            return instanceInfo;
        }

        @Override
        public final Builder instanceInfo(InstanceInfo instanceInfo) {
            this.instanceInfo = instanceInfo;
            return this;
        }

        public final void setInstanceInfo(InstanceInfo instanceInfo) {
            this.instanceInfo = instanceInfo;
        }

        @Override
        public GetOnPremisesInstanceResponse build() {
            return new GetOnPremisesInstanceResponse(this);
        }
    }
}
