/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a GetDeployment operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDeploymentResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDeploymentResponse.Builder, GetDeploymentResponse> {
    private final DeploymentInfo deploymentInfo;

    private GetDeploymentResponse(BuilderImpl builder) {
        this.deploymentInfo = builder.deploymentInfo;
    }

    /**
     * <p>
     * Information about the deployment.
     * </p>
     * 
     * @return Information about the deployment.
     */
    public DeploymentInfo deploymentInfo() {
        return deploymentInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentInfo() == null) ? 0 : deploymentInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentResponse)) {
            return false;
        }
        GetDeploymentResponse other = (GetDeploymentResponse) obj;
        if (other.deploymentInfo() == null ^ this.deploymentInfo() == null) {
            return false;
        }
        if (other.deploymentInfo() != null && !other.deploymentInfo().equals(this.deploymentInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentInfo() != null) {
            sb.append("DeploymentInfo: ").append(deploymentInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetDeploymentResponse> {
        /**
         * <p>
         * Information about the deployment.
         * </p>
         * 
         * @param deploymentInfo
         *        Information about the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentInfo(DeploymentInfo deploymentInfo);
    }

    private static final class BuilderImpl implements Builder {
        private DeploymentInfo deploymentInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentResponse model) {
            setDeploymentInfo(model.deploymentInfo);
        }

        public final DeploymentInfo getDeploymentInfo() {
            return deploymentInfo;
        }

        @Override
        public final Builder deploymentInfo(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
            return this;
        }

        public final void setDeploymentInfo(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
        }

        @Override
        public GetDeploymentResponse build() {
            return new GetDeploymentResponse(this);
        }
    }
}
