/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a GetDeployment operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDeploymentRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetDeploymentRequest.Builder, GetDeploymentRequest> {
    private final String deploymentId;

    private GetDeploymentRequest(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
    }

    /**
     * <p>
     * A deployment ID associated with the applicable IAM user or AWS account.
     * </p>
     * 
     * @return A deployment ID associated with the applicable IAM user or AWS account.
     */
    public String deploymentId() {
        return deploymentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentId() == null) ? 0 : deploymentId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentRequest)) {
            return false;
        }
        GetDeploymentRequest other = (GetDeploymentRequest) obj;
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentId() != null) {
            sb.append("DeploymentId: ").append(deploymentId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetDeploymentRequest> {
        /**
         * <p>
         * A deployment ID associated with the applicable IAM user or AWS account.
         * </p>
         * 
         * @param deploymentId
         *        A deployment ID associated with the applicable IAM user or AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentRequest model) {
            setDeploymentId(model.deploymentId);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public GetDeploymentRequest build() {
            return new GetDeploymentRequest(this);
        }
    }
}
