/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a GetDeploymentGroup operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDeploymentGroupResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDeploymentGroupResponse.Builder, GetDeploymentGroupResponse> {
    private final DeploymentGroupInfo deploymentGroupInfo;

    private GetDeploymentGroupResponse(BuilderImpl builder) {
        this.deploymentGroupInfo = builder.deploymentGroupInfo;
    }

    /**
     * <p>
     * Information about the deployment group.
     * </p>
     * 
     * @return Information about the deployment group.
     */
    public DeploymentGroupInfo deploymentGroupInfo() {
        return deploymentGroupInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentGroupInfo() == null) ? 0 : deploymentGroupInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentGroupResponse)) {
            return false;
        }
        GetDeploymentGroupResponse other = (GetDeploymentGroupResponse) obj;
        if (other.deploymentGroupInfo() == null ^ this.deploymentGroupInfo() == null) {
            return false;
        }
        if (other.deploymentGroupInfo() != null && !other.deploymentGroupInfo().equals(this.deploymentGroupInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentGroupInfo() != null) {
            sb.append("DeploymentGroupInfo: ").append(deploymentGroupInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetDeploymentGroupResponse> {
        /**
         * <p>
         * Information about the deployment group.
         * </p>
         * 
         * @param deploymentGroupInfo
         *        Information about the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupInfo(DeploymentGroupInfo deploymentGroupInfo);
    }

    private static final class BuilderImpl implements Builder {
        private DeploymentGroupInfo deploymentGroupInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentGroupResponse model) {
            setDeploymentGroupInfo(model.deploymentGroupInfo);
        }

        public final DeploymentGroupInfo getDeploymentGroupInfo() {
            return deploymentGroupInfo;
        }

        @Override
        public final Builder deploymentGroupInfo(DeploymentGroupInfo deploymentGroupInfo) {
            this.deploymentGroupInfo = deploymentGroupInfo;
            return this;
        }

        public final void setDeploymentGroupInfo(DeploymentGroupInfo deploymentGroupInfo) {
            this.deploymentGroupInfo = deploymentGroupInfo;
        }

        @Override
        public GetDeploymentGroupResponse build() {
            return new GetDeploymentGroupResponse(this);
        }
    }
}
