/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a GetDeploymentConfig operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDeploymentConfigResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDeploymentConfigResponse.Builder, GetDeploymentConfigResponse> {
    private final DeploymentConfigInfo deploymentConfigInfo;

    private GetDeploymentConfigResponse(BuilderImpl builder) {
        this.deploymentConfigInfo = builder.deploymentConfigInfo;
    }

    /**
     * <p>
     * Information about the deployment configuration.
     * </p>
     * 
     * @return Information about the deployment configuration.
     */
    public DeploymentConfigInfo deploymentConfigInfo() {
        return deploymentConfigInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentConfigInfo() == null) ? 0 : deploymentConfigInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentConfigResponse)) {
            return false;
        }
        GetDeploymentConfigResponse other = (GetDeploymentConfigResponse) obj;
        if (other.deploymentConfigInfo() == null ^ this.deploymentConfigInfo() == null) {
            return false;
        }
        if (other.deploymentConfigInfo() != null && !other.deploymentConfigInfo().equals(this.deploymentConfigInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentConfigInfo() != null) {
            sb.append("DeploymentConfigInfo: ").append(deploymentConfigInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetDeploymentConfigResponse> {
        /**
         * <p>
         * Information about the deployment configuration.
         * </p>
         * 
         * @param deploymentConfigInfo
         *        Information about the deployment configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigInfo(DeploymentConfigInfo deploymentConfigInfo);
    }

    private static final class BuilderImpl implements Builder {
        private DeploymentConfigInfo deploymentConfigInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentConfigResponse model) {
            setDeploymentConfigInfo(model.deploymentConfigInfo);
        }

        public final DeploymentConfigInfo getDeploymentConfigInfo() {
            return deploymentConfigInfo;
        }

        @Override
        public final Builder deploymentConfigInfo(DeploymentConfigInfo deploymentConfigInfo) {
            this.deploymentConfigInfo = deploymentConfigInfo;
            return this;
        }

        public final void setDeploymentConfigInfo(DeploymentConfigInfo deploymentConfigInfo) {
            this.deploymentConfigInfo = deploymentConfigInfo;
        }

        @Override
        public GetDeploymentConfigResponse build() {
            return new GetDeploymentConfigResponse(this);
        }
    }
}
