/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a GetApplication operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetApplicationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetApplicationResponse.Builder, GetApplicationResponse> {
    private final ApplicationInfo application;

    private GetApplicationResponse(BuilderImpl builder) {
        this.application = builder.application;
    }

    /**
     * <p>
     * Information about the application.
     * </p>
     * 
     * @return Information about the application.
     */
    public ApplicationInfo application() {
        return application;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((application() == null) ? 0 : application().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse) obj;
        if (other.application() == null ^ this.application() == null) {
            return false;
        }
        if (other.application() != null && !other.application().equals(this.application())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (application() != null) {
            sb.append("Application: ").append(application()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetApplicationResponse> {
        /**
         * <p>
         * Information about the application.
         * </p>
         * 
         * @param application
         *        Information about the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(ApplicationInfo application);
    }

    private static final class BuilderImpl implements Builder {
        private ApplicationInfo application;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            setApplication(model.application);
        }

        public final ApplicationInfo getApplication() {
            return application;
        }

        @Override
        public final Builder application(ApplicationInfo application) {
            this.application = application;
            return this;
        }

        public final void setApplication(ApplicationInfo application) {
            this.application = application;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }
    }
}
