/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.transform.GenericRevisionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an application revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GenericRevisionInfo implements StructuredPojo, ToCopyableBuilder<GenericRevisionInfo.Builder, GenericRevisionInfo> {
    private final String description;

    private final List<String> deploymentGroups;

    private final Date firstUsedTime;

    private final Date lastUsedTime;

    private final Date registerTime;

    private GenericRevisionInfo(BuilderImpl builder) {
        this.description = builder.description;
        this.deploymentGroups = builder.deploymentGroups;
        this.firstUsedTime = builder.firstUsedTime;
        this.lastUsedTime = builder.lastUsedTime;
        this.registerTime = builder.registerTime;
    }

    /**
     * <p>
     * A comment about the revision.
     * </p>
     * 
     * @return A comment about the revision.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The deployment groups for which this is the current target revision.
     * </p>
     * 
     * @return The deployment groups for which this is the current target revision.
     */
    public List<String> deploymentGroups() {
        return deploymentGroups;
    }

    /**
     * <p>
     * When the revision was first used by AWS CodeDeploy.
     * </p>
     * 
     * @return When the revision was first used by AWS CodeDeploy.
     */
    public Date firstUsedTime() {
        return firstUsedTime;
    }

    /**
     * <p>
     * When the revision was last used by AWS CodeDeploy.
     * </p>
     * 
     * @return When the revision was last used by AWS CodeDeploy.
     */
    public Date lastUsedTime() {
        return lastUsedTime;
    }

    /**
     * <p>
     * When the revision was registered with AWS CodeDeploy.
     * </p>
     * 
     * @return When the revision was registered with AWS CodeDeploy.
     */
    public Date registerTime() {
        return registerTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((deploymentGroups() == null) ? 0 : deploymentGroups().hashCode());
        hashCode = 31 * hashCode + ((firstUsedTime() == null) ? 0 : firstUsedTime().hashCode());
        hashCode = 31 * hashCode + ((lastUsedTime() == null) ? 0 : lastUsedTime().hashCode());
        hashCode = 31 * hashCode + ((registerTime() == null) ? 0 : registerTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericRevisionInfo)) {
            return false;
        }
        GenericRevisionInfo other = (GenericRevisionInfo) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.deploymentGroups() == null ^ this.deploymentGroups() == null) {
            return false;
        }
        if (other.deploymentGroups() != null && !other.deploymentGroups().equals(this.deploymentGroups())) {
            return false;
        }
        if (other.firstUsedTime() == null ^ this.firstUsedTime() == null) {
            return false;
        }
        if (other.firstUsedTime() != null && !other.firstUsedTime().equals(this.firstUsedTime())) {
            return false;
        }
        if (other.lastUsedTime() == null ^ this.lastUsedTime() == null) {
            return false;
        }
        if (other.lastUsedTime() != null && !other.lastUsedTime().equals(this.lastUsedTime())) {
            return false;
        }
        if (other.registerTime() == null ^ this.registerTime() == null) {
            return false;
        }
        if (other.registerTime() != null && !other.registerTime().equals(this.registerTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (deploymentGroups() != null) {
            sb.append("DeploymentGroups: ").append(deploymentGroups()).append(",");
        }
        if (firstUsedTime() != null) {
            sb.append("FirstUsedTime: ").append(firstUsedTime()).append(",");
        }
        if (lastUsedTime() != null) {
            sb.append("LastUsedTime: ").append(lastUsedTime()).append(",");
        }
        if (registerTime() != null) {
            sb.append("RegisterTime: ").append(registerTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GenericRevisionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, GenericRevisionInfo> {
        /**
         * <p>
         * A comment about the revision.
         * </p>
         * 
         * @param description
         *        A comment about the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The deployment groups for which this is the current target revision.
         * </p>
         * 
         * @param deploymentGroups
         *        The deployment groups for which this is the current target revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroups(Collection<String> deploymentGroups);

        /**
         * <p>
         * The deployment groups for which this is the current target revision.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDeploymentGroups(java.util.Collection)} or {@link #withDeploymentGroups(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param deploymentGroups
         *        The deployment groups for which this is the current target revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroups(String... deploymentGroups);

        /**
         * <p>
         * When the revision was first used by AWS CodeDeploy.
         * </p>
         * 
         * @param firstUsedTime
         *        When the revision was first used by AWS CodeDeploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstUsedTime(Date firstUsedTime);

        /**
         * <p>
         * When the revision was last used by AWS CodeDeploy.
         * </p>
         * 
         * @param lastUsedTime
         *        When the revision was last used by AWS CodeDeploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUsedTime(Date lastUsedTime);

        /**
         * <p>
         * When the revision was registered with AWS CodeDeploy.
         * </p>
         * 
         * @param registerTime
         *        When the revision was registered with AWS CodeDeploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registerTime(Date registerTime);
    }

    private static final class BuilderImpl implements Builder {
        private String description;

        private List<String> deploymentGroups = new SdkInternalList<>();

        private Date firstUsedTime;

        private Date lastUsedTime;

        private Date registerTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GenericRevisionInfo model) {
            setDescription(model.description);
            setDeploymentGroups(model.deploymentGroups);
            setFirstUsedTime(model.firstUsedTime);
            setLastUsedTime(model.lastUsedTime);
            setRegisterTime(model.registerTime);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getDeploymentGroups() {
            return deploymentGroups;
        }

        @Override
        public final Builder deploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroups(String... deploymentGroups) {
            if (this.deploymentGroups == null) {
                this.deploymentGroups = new SdkInternalList<>(deploymentGroups.length);
            }
            for (String e : deploymentGroups) {
                this.deploymentGroups.add(e);
            }
            return this;
        }

        public final void setDeploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
        }

        @SafeVarargs
        public final void setDeploymentGroups(String... deploymentGroups) {
            if (this.deploymentGroups == null) {
                this.deploymentGroups = new SdkInternalList<>(deploymentGroups.length);
            }
            for (String e : deploymentGroups) {
                this.deploymentGroups.add(e);
            }
        }

        public final Date getFirstUsedTime() {
            return firstUsedTime;
        }

        @Override
        public final Builder firstUsedTime(Date firstUsedTime) {
            this.firstUsedTime = StandardMemberCopier.copy(firstUsedTime);
            return this;
        }

        public final void setFirstUsedTime(Date firstUsedTime) {
            this.firstUsedTime = StandardMemberCopier.copy(firstUsedTime);
        }

        public final Date getLastUsedTime() {
            return lastUsedTime;
        }

        @Override
        public final Builder lastUsedTime(Date lastUsedTime) {
            this.lastUsedTime = StandardMemberCopier.copy(lastUsedTime);
            return this;
        }

        public final void setLastUsedTime(Date lastUsedTime) {
            this.lastUsedTime = StandardMemberCopier.copy(lastUsedTime);
        }

        public final Date getRegisterTime() {
            return registerTime;
        }

        @Override
        public final Builder registerTime(Date registerTime) {
            this.registerTime = StandardMemberCopier.copy(registerTime);
            return this;
        }

        public final void setRegisterTime(Date registerTime) {
            this.registerTime = StandardMemberCopier.copy(registerTime);
        }

        @Override
        public GenericRevisionInfo build() {
            return new GenericRevisionInfo(this);
        }
    }
}
