/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.ErrorInformationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ErrorInformation implements StructuredPojo, ToCopyableBuilder<ErrorInformation.Builder, ErrorInformation> {
    private final String code;

    private final String message;

    private ErrorInformation(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * For information about additional error codes, see <a
     * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for AWS CodeDeploy</a>
     * in the <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User Guide</a>.
     * </p>
     * <p>
     * The error code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * APPLICATION_MISSING: The application was missing. This error code will most likely be raised if the application
     * is deleted after the deployment is created but before it is started.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code will most likely be raised if the
     * deployment group is deleted after the deployment is created but before it is started.
     * </p>
     * </li>
     * <li>
     * <p>
     * HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the instance
     * health constraints specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health constraints
     * specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM_ROLE_MISSING: The service role cannot be accessed.
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * INTERNAL_ERROR: There was an internal error.
     * </p>
     * </li>
     * <li>
     * <p>
     * NO_EC2_SUBSCRIPTION: The calling account is not subscribed to the Amazon EC2 service.
     * </p>
     * </li>
     * <li>
     * <p>
     * NO_INSTANCES: No instance were specified, or no instance can be found.
     * </p>
     * </li>
     * <li>
     * <p>
     * OVER_MAX_INSTANCES: The maximum number of instance was exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or more
     * AWS services.
     * </p>
     * </li>
     * <li>
     * <p>
     * TIMEOUT: The deployment has timed out.
     * </p>
     * </li>
     * <li>
     * <p>
     * REVISION_MISSING: The revision ID was missing. This error code will most likely be raised if the revision is
     * deleted after the deployment is created but before it is started.
     * </p>
     * </li>
     * </ul>
     * 
     * @return For information about additional error codes, see <a
     *         href="http://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for AWS
     *         CodeDeploy</a> in the <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy
     *         User Guide</a>.</p>
     *         <p>
     *         The error code:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         APPLICATION_MISSING: The application was missing. This error code will most likely be raised if the
     *         application is deleted after the deployment is created but before it is started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code will most likely be raised if
     *         the deployment group is deleted after the deployment is created but before it is started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the
     *         instance health constraints specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health
     *         constraints specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IAM_ROLE_MISSING: The service role cannot be accessed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INTERNAL_ERROR: There was an internal error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NO_EC2_SUBSCRIPTION: The calling account is not subscribed to the Amazon EC2 service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NO_INSTANCES: No instance were specified, or no instance can be found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OVER_MAX_INSTANCES: The maximum number of instance was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one
     *         or more AWS services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TIMEOUT: The deployment has timed out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REVISION_MISSING: The revision ID was missing. This error code will most likely be raised if the revision
     *         is deleted after the deployment is created but before it is started.
     *         </p>
     *         </li>
     * @see ErrorCode
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * An accompanying error message.
     * </p>
     * 
     * @return An accompanying error message.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((code() == null) ? 0 : code().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorInformation)) {
            return false;
        }
        ErrorInformation other = (ErrorInformation) obj;
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (code() != null) {
            sb.append("Code: ").append(code()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ErrorInformationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ErrorInformation> {
        /**
         * <p>
         * For information about additional error codes, see <a
         * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for AWS
         * CodeDeploy</a> in the <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User
         * Guide</a>.
         * </p>
         * <p>
         * The error code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * APPLICATION_MISSING: The application was missing. This error code will most likely be raised if the
         * application is deleted after the deployment is created but before it is started.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code will most likely be raised if the
         * deployment group is deleted after the deployment is created but before it is started.
         * </p>
         * </li>
         * <li>
         * <p>
         * HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the
         * instance health constraints specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health
         * constraints specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * IAM_ROLE_MISSING: The service role cannot be accessed.
         * </p>
         * </li>
         * <li>
         * <p>
         * IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * INTERNAL_ERROR: There was an internal error.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_EC2_SUBSCRIPTION: The calling account is not subscribed to the Amazon EC2 service.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_INSTANCES: No instance were specified, or no instance can be found.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVER_MAX_INSTANCES: The maximum number of instance was exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or
         * more AWS services.
         * </p>
         * </li>
         * <li>
         * <p>
         * TIMEOUT: The deployment has timed out.
         * </p>
         * </li>
         * <li>
         * <p>
         * REVISION_MISSING: The revision ID was missing. This error code will most likely be raised if the revision is
         * deleted after the deployment is created but before it is started.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        For information about additional error codes, see <a
         *        href="http://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for AWS
         *        CodeDeploy</a> in the <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy
         *        User Guide</a>.</p>
         *        <p>
         *        The error code:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        APPLICATION_MISSING: The application was missing. This error code will most likely be raised if the
         *        application is deleted after the deployment is created but before it is started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code will most likely be raised
         *        if the deployment group is deleted after the deployment is created but before it is started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the
         *        instance health constraints specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health
         *        constraints specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IAM_ROLE_MISSING: The service role cannot be accessed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INTERNAL_ERROR: There was an internal error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_EC2_SUBSCRIPTION: The calling account is not subscribed to the Amazon EC2 service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_INSTANCES: No instance were specified, or no instance can be found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVER_MAX_INSTANCES: The maximum number of instance was exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of
         *        one or more AWS services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TIMEOUT: The deployment has timed out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REVISION_MISSING: The revision ID was missing. This error code will most likely be raised if the
         *        revision is deleted after the deployment is created but before it is started.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * For information about additional error codes, see <a
         * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for AWS
         * CodeDeploy</a> in the <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User
         * Guide</a>.
         * </p>
         * <p>
         * The error code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * APPLICATION_MISSING: The application was missing. This error code will most likely be raised if the
         * application is deleted after the deployment is created but before it is started.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code will most likely be raised if the
         * deployment group is deleted after the deployment is created but before it is started.
         * </p>
         * </li>
         * <li>
         * <p>
         * HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the
         * instance health constraints specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health
         * constraints specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * IAM_ROLE_MISSING: The service role cannot be accessed.
         * </p>
         * </li>
         * <li>
         * <p>
         * IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * INTERNAL_ERROR: There was an internal error.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_EC2_SUBSCRIPTION: The calling account is not subscribed to the Amazon EC2 service.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_INSTANCES: No instance were specified, or no instance can be found.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVER_MAX_INSTANCES: The maximum number of instance was exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or
         * more AWS services.
         * </p>
         * </li>
         * <li>
         * <p>
         * TIMEOUT: The deployment has timed out.
         * </p>
         * </li>
         * <li>
         * <p>
         * REVISION_MISSING: The revision ID was missing. This error code will most likely be raised if the revision is
         * deleted after the deployment is created but before it is started.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        For information about additional error codes, see <a
         *        href="http://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for AWS
         *        CodeDeploy</a> in the <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy
         *        User Guide</a>.</p>
         *        <p>
         *        The error code:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        APPLICATION_MISSING: The application was missing. This error code will most likely be raised if the
         *        application is deleted after the deployment is created but before it is started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code will most likely be raised
         *        if the deployment group is deleted after the deployment is created but before it is started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the
         *        instance health constraints specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health
         *        constraints specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IAM_ROLE_MISSING: The service role cannot be accessed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INTERNAL_ERROR: There was an internal error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_EC2_SUBSCRIPTION: The calling account is not subscribed to the Amazon EC2 service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_INSTANCES: No instance were specified, or no instance can be found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVER_MAX_INSTANCES: The maximum number of instance was exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of
         *        one or more AWS services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TIMEOUT: The deployment has timed out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REVISION_MISSING: The revision ID was missing. This error code will most likely be raised if the
         *        revision is deleted after the deployment is created but before it is started.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder code(ErrorCode code);

        /**
         * <p>
         * An accompanying error message.
         * </p>
         * 
         * @param message
         *        An accompanying error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorInformation model) {
            setCode(model.code);
            setMessage(model.message);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ErrorCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final void setCode(ErrorCode code) {
            this.code(code.toString());
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public ErrorInformation build() {
            return new ErrorInformation(this);
        }
    }
}
