/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.EC2TagFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an EC2 tag filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EC2TagFilter implements StructuredPojo, ToCopyableBuilder<EC2TagFilter.Builder, EC2TagFilter> {
    private final String key;

    private final String value;

    private final String type;

    private EC2TagFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.type = builder.type;
    }

    /**
     * <p>
     * The tag filter key.
     * </p>
     * 
     * @return The tag filter key.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The tag filter value.
     * </p>
     * 
     * @return The tag filter value.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The tag filter type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KEY_ONLY: Key only.
     * </p>
     * </li>
     * <li>
     * <p>
     * VALUE_ONLY: Value only.
     * </p>
     * </li>
     * <li>
     * <p>
     * KEY_AND_VALUE: Key and value.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The tag filter type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         KEY_ONLY: Key only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         VALUE_ONLY: Value only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KEY_AND_VALUE: Key and value.
     *         </p>
     *         </li>
     * @see EC2TagFilterType
     */
    public String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((value() == null) ? 0 : value().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2TagFilter)) {
            return false;
        }
        EC2TagFilter other = (EC2TagFilter) obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EC2TagFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EC2TagFilter> {
        /**
         * <p>
         * The tag filter key.
         * </p>
         * 
         * @param key
         *        The tag filter key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The tag filter value.
         * </p>
         * 
         * @param value
         *        The tag filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The tag filter type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KEY_ONLY: Key only.
         * </p>
         * </li>
         * <li>
         * <p>
         * VALUE_ONLY: Value only.
         * </p>
         * </li>
         * <li>
         * <p>
         * KEY_AND_VALUE: Key and value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The tag filter type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        KEY_ONLY: Key only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VALUE_ONLY: Value only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KEY_AND_VALUE: Key and value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2TagFilterType
         */
        Builder type(String type);

        /**
         * <p>
         * The tag filter type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KEY_ONLY: Key only.
         * </p>
         * </li>
         * <li>
         * <p>
         * VALUE_ONLY: Value only.
         * </p>
         * </li>
         * <li>
         * <p>
         * KEY_AND_VALUE: Key and value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The tag filter type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        KEY_ONLY: Key only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VALUE_ONLY: Value only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KEY_AND_VALUE: Key and value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2TagFilterType
         */
        Builder type(EC2TagFilterType type);
    }

    private static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2TagFilter model) {
            setKey(model.key);
            setValue(model.value);
            setType(model.type);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EC2TagFilterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(EC2TagFilterType type) {
            this.type(type.toString());
        }

        @Override
        public EC2TagFilter build() {
            return new EC2TagFilter(this);
        }
    }
}
