/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.DiagnosticsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Diagnostic information about executable scripts that are part of a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Diagnostics implements StructuredPojo, ToCopyableBuilder<Diagnostics.Builder, Diagnostics> {
    private final String errorCode;

    private final String scriptName;

    private final String message;

    private final String logTail;

    private Diagnostics(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.scriptName = builder.scriptName;
        this.message = builder.message;
        this.logTail = builder.logTail;
    }

    /**
     * <p>
     * The associated error code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Success: The specified script ran.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptMissing: The specified script was not found in the specified location.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptNotExecutable: The specified script is not a recognized executable file type.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptTimedOut: The specified script did not finish running in the specified time period.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptFailed: The specified script failed to run as expected.
     * </p>
     * </li>
     * <li>
     * <p>
     * UnknownError: The specified script did not run for an unknown reason.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The associated error code:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Success: The specified script ran.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptMissing: The specified script was not found in the specified location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptNotExecutable: The specified script is not a recognized executable file type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptTimedOut: The specified script did not finish running in the specified time period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptFailed: The specified script failed to run as expected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UnknownError: The specified script did not run for an unknown reason.
     *         </p>
     *         </li>
     * @see LifecycleErrorCode
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The name of the script.
     * </p>
     * 
     * @return The name of the script.
     */
    public String scriptName() {
        return scriptName;
    }

    /**
     * <p>
     * The message associated with the error.
     * </p>
     * 
     * @return The message associated with the error.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The last portion of the diagnostic log.
     * </p>
     * <p>
     * If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.
     * </p>
     * 
     * @return The last portion of the diagnostic log.</p>
     *         <p>
     *         If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.
     */
    public String logTail() {
        return logTail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((errorCode() == null) ? 0 : errorCode().hashCode());
        hashCode = 31 * hashCode + ((scriptName() == null) ? 0 : scriptName().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((logTail() == null) ? 0 : logTail().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Diagnostics)) {
            return false;
        }
        Diagnostics other = (Diagnostics) obj;
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.scriptName() == null ^ this.scriptName() == null) {
            return false;
        }
        if (other.scriptName() != null && !other.scriptName().equals(this.scriptName())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.logTail() == null ^ this.logTail() == null) {
            return false;
        }
        if (other.logTail() != null && !other.logTail().equals(this.logTail())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (errorCode() != null) {
            sb.append("ErrorCode: ").append(errorCode()).append(",");
        }
        if (scriptName() != null) {
            sb.append("ScriptName: ").append(scriptName()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (logTail() != null) {
            sb.append("LogTail: ").append(logTail()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiagnosticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Diagnostics> {
        /**
         * <p>
         * The associated error code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Success: The specified script ran.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptMissing: The specified script was not found in the specified location.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptNotExecutable: The specified script is not a recognized executable file type.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptTimedOut: The specified script did not finish running in the specified time period.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptFailed: The specified script failed to run as expected.
         * </p>
         * </li>
         * <li>
         * <p>
         * UnknownError: The specified script did not run for an unknown reason.
         * </p>
         * </li>
         * </ul>
         * 
         * @param errorCode
         *        The associated error code:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Success: The specified script ran.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptMissing: The specified script was not found in the specified location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptNotExecutable: The specified script is not a recognized executable file type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptTimedOut: The specified script did not finish running in the specified time period.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptFailed: The specified script failed to run as expected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UnknownError: The specified script did not run for an unknown reason.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The associated error code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Success: The specified script ran.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptMissing: The specified script was not found in the specified location.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptNotExecutable: The specified script is not a recognized executable file type.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptTimedOut: The specified script did not finish running in the specified time period.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptFailed: The specified script failed to run as expected.
         * </p>
         * </li>
         * <li>
         * <p>
         * UnknownError: The specified script did not run for an unknown reason.
         * </p>
         * </li>
         * </ul>
         * 
         * @param errorCode
         *        The associated error code:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Success: The specified script ran.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptMissing: The specified script was not found in the specified location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptNotExecutable: The specified script is not a recognized executable file type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptTimedOut: The specified script did not finish running in the specified time period.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptFailed: The specified script failed to run as expected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UnknownError: The specified script did not run for an unknown reason.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleErrorCode
         */
        Builder errorCode(LifecycleErrorCode errorCode);

        /**
         * <p>
         * The name of the script.
         * </p>
         * 
         * @param scriptName
         *        The name of the script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptName(String scriptName);

        /**
         * <p>
         * The message associated with the error.
         * </p>
         * 
         * @param message
         *        The message associated with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The last portion of the diagnostic log.
         * </p>
         * <p>
         * If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.
         * </p>
         * 
         * @param logTail
         *        The last portion of the diagnostic log.</p>
         *        <p>
         *        If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTail(String logTail);
    }

    private static final class BuilderImpl implements Builder {
        private String errorCode;

        private String scriptName;

        private String message;

        private String logTail;

        private BuilderImpl() {
        }

        private BuilderImpl(Diagnostics model) {
            setErrorCode(model.errorCode);
            setScriptName(model.scriptName);
            setMessage(model.message);
            setLogTail(model.logTail);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(LifecycleErrorCode errorCode) {
            this.errorCode(errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final void setErrorCode(LifecycleErrorCode errorCode) {
            this.errorCode(errorCode.toString());
        }

        public final String getScriptName() {
            return scriptName;
        }

        @Override
        public final Builder scriptName(String scriptName) {
            this.scriptName = scriptName;
            return this;
        }

        public final void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getLogTail() {
            return logTail;
        }

        @Override
        public final Builder logTail(String logTail) {
            this.logTail = logTail;
            return this;
        }

        public final void setLogTail(String logTail) {
            this.logTail = logTail;
        }

        @Override
        public Diagnostics build() {
            return new Diagnostics(this);
        }
    }
}
