/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentStyleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
 * deployment traffic behind a load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeploymentStyle implements StructuredPojo, ToCopyableBuilder<DeploymentStyle.Builder, DeploymentStyle> {
    private final String deploymentType;

    private final String deploymentOption;

    private DeploymentStyle(BuilderImpl builder) {
        this.deploymentType = builder.deploymentType;
        this.deploymentOption = builder.deploymentOption;
    }

    /**
     * <p>
     * Indicates whether to run an in-place deployment or a blue/green deployment.
     * </p>
     * 
     * @return Indicates whether to run an in-place deployment or a blue/green deployment.
     * @see DeploymentType
     */
    public String deploymentType() {
        return deploymentType;
    }

    /**
     * <p>
     * Indicates whether to route deployment traffic behind a load balancer.
     * </p>
     * 
     * @return Indicates whether to route deployment traffic behind a load balancer.
     * @see DeploymentOption
     */
    public String deploymentOption() {
        return deploymentOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentType() == null) ? 0 : deploymentType().hashCode());
        hashCode = 31 * hashCode + ((deploymentOption() == null) ? 0 : deploymentOption().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentStyle)) {
            return false;
        }
        DeploymentStyle other = (DeploymentStyle) obj;
        if (other.deploymentType() == null ^ this.deploymentType() == null) {
            return false;
        }
        if (other.deploymentType() != null && !other.deploymentType().equals(this.deploymentType())) {
            return false;
        }
        if (other.deploymentOption() == null ^ this.deploymentOption() == null) {
            return false;
        }
        if (other.deploymentOption() != null && !other.deploymentOption().equals(this.deploymentOption())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentType() != null) {
            sb.append("DeploymentType: ").append(deploymentType()).append(",");
        }
        if (deploymentOption() != null) {
            sb.append("DeploymentOption: ").append(deploymentOption()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentStyleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeploymentStyle> {
        /**
         * <p>
         * Indicates whether to run an in-place deployment or a blue/green deployment.
         * </p>
         * 
         * @param deploymentType
         *        Indicates whether to run an in-place deployment or a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Indicates whether to run an in-place deployment or a blue/green deployment.
         * </p>
         * 
         * @param deploymentType
         *        Indicates whether to run an in-place deployment or a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(DeploymentType deploymentType);

        /**
         * <p>
         * Indicates whether to route deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentOption
         *        Indicates whether to route deployment traffic behind a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentOption
         */
        Builder deploymentOption(String deploymentOption);

        /**
         * <p>
         * Indicates whether to route deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentOption
         *        Indicates whether to route deployment traffic behind a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentOption
         */
        Builder deploymentOption(DeploymentOption deploymentOption);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentType;

        private String deploymentOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentStyle model) {
            setDeploymentType(model.deploymentType);
            setDeploymentOption(model.deploymentOption);
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final void setDeploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType.toString());
        }

        public final String getDeploymentOption() {
            return deploymentOption;
        }

        @Override
        public final Builder deploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
            return this;
        }

        @Override
        public final Builder deploymentOption(DeploymentOption deploymentOption) {
            this.deploymentOption(deploymentOption.toString());
            return this;
        }

        public final void setDeploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
        }

        public final void setDeploymentOption(DeploymentOption deploymentOption) {
            this.deploymentOption(deploymentOption.toString());
        }

        @Override
        public DeploymentStyle build() {
            return new DeploymentStyle(this);
        }
    }
}
