/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentReadyOptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how traffic is rerouted to instances in a replacement environment in a blue/green deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeploymentReadyOption implements StructuredPojo,
        ToCopyableBuilder<DeploymentReadyOption.Builder, DeploymentReadyOption> {
    private final String actionOnTimeout;

    private final Integer waitTimeInMinutes;

    private DeploymentReadyOption(BuilderImpl builder) {
        this.actionOnTimeout = builder.actionOnTimeout;
        this.waitTimeInMinutes = builder.waitTimeInMinutes;
    }

    /**
     * <p>
     * Information about when to reroute traffic from an original environment to a replacement environment in a
     * blue/green deployment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application revision
     * is installed on the instances in the replacement environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_DEPLOYMENT: Do not register new instances with load balancer unless traffic is rerouted manually. If traffic
     * is not rerouted manually before the end of the specified wait period, the deployment status is changed to
     * Stopped.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about when to reroute traffic from an original environment to a replacement environment in a
     *         blue/green deployment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application
     *         revision is installed on the instances in the replacement environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOP_DEPLOYMENT: Do not register new instances with load balancer unless traffic is rerouted manually. If
     *         traffic is not rerouted manually before the end of the specified wait period, the deployment status is
     *         changed to Stopped.
     *         </p>
     *         </li>
     * @see DeploymentReadyAction
     */
    public String actionOnTimeout() {
        return actionOnTimeout;
    }

    /**
     * <p>
     * The number of minutes to wait before the status of a blue/green deployment changed to Stopped if rerouting is not
     * started manually. Applies only to the STOP_DEPLOYMENT option for actionOnTimeout
     * </p>
     * 
     * @return The number of minutes to wait before the status of a blue/green deployment changed to Stopped if
     *         rerouting is not started manually. Applies only to the STOP_DEPLOYMENT option for actionOnTimeout
     */
    public Integer waitTimeInMinutes() {
        return waitTimeInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((actionOnTimeout() == null) ? 0 : actionOnTimeout().hashCode());
        hashCode = 31 * hashCode + ((waitTimeInMinutes() == null) ? 0 : waitTimeInMinutes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentReadyOption)) {
            return false;
        }
        DeploymentReadyOption other = (DeploymentReadyOption) obj;
        if (other.actionOnTimeout() == null ^ this.actionOnTimeout() == null) {
            return false;
        }
        if (other.actionOnTimeout() != null && !other.actionOnTimeout().equals(this.actionOnTimeout())) {
            return false;
        }
        if (other.waitTimeInMinutes() == null ^ this.waitTimeInMinutes() == null) {
            return false;
        }
        if (other.waitTimeInMinutes() != null && !other.waitTimeInMinutes().equals(this.waitTimeInMinutes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (actionOnTimeout() != null) {
            sb.append("ActionOnTimeout: ").append(actionOnTimeout()).append(",");
        }
        if (waitTimeInMinutes() != null) {
            sb.append("WaitTimeInMinutes: ").append(waitTimeInMinutes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentReadyOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeploymentReadyOption> {
        /**
         * <p>
         * Information about when to reroute traffic from an original environment to a replacement environment in a
         * blue/green deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application
         * revision is installed on the instances in the replacement environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOP_DEPLOYMENT: Do not register new instances with load balancer unless traffic is rerouted manually. If
         * traffic is not rerouted manually before the end of the specified wait period, the deployment status is
         * changed to Stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param actionOnTimeout
         *        Information about when to reroute traffic from an original environment to a replacement environment in
         *        a blue/green deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new
         *        application revision is installed on the instances in the replacement environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOP_DEPLOYMENT: Do not register new instances with load balancer unless traffic is rerouted manually.
         *        If traffic is not rerouted manually before the end of the specified wait period, the deployment status
         *        is changed to Stopped.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentReadyAction
         */
        Builder actionOnTimeout(String actionOnTimeout);

        /**
         * <p>
         * Information about when to reroute traffic from an original environment to a replacement environment in a
         * blue/green deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application
         * revision is installed on the instances in the replacement environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOP_DEPLOYMENT: Do not register new instances with load balancer unless traffic is rerouted manually. If
         * traffic is not rerouted manually before the end of the specified wait period, the deployment status is
         * changed to Stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param actionOnTimeout
         *        Information about when to reroute traffic from an original environment to a replacement environment in
         *        a blue/green deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new
         *        application revision is installed on the instances in the replacement environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOP_DEPLOYMENT: Do not register new instances with load balancer unless traffic is rerouted manually.
         *        If traffic is not rerouted manually before the end of the specified wait period, the deployment status
         *        is changed to Stopped.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentReadyAction
         */
        Builder actionOnTimeout(DeploymentReadyAction actionOnTimeout);

        /**
         * <p>
         * The number of minutes to wait before the status of a blue/green deployment changed to Stopped if rerouting is
         * not started manually. Applies only to the STOP_DEPLOYMENT option for actionOnTimeout
         * </p>
         * 
         * @param waitTimeInMinutes
         *        The number of minutes to wait before the status of a blue/green deployment changed to Stopped if
         *        rerouting is not started manually. Applies only to the STOP_DEPLOYMENT option for actionOnTimeout
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitTimeInMinutes(Integer waitTimeInMinutes);
    }

    private static final class BuilderImpl implements Builder {
        private String actionOnTimeout;

        private Integer waitTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentReadyOption model) {
            setActionOnTimeout(model.actionOnTimeout);
            setWaitTimeInMinutes(model.waitTimeInMinutes);
        }

        public final String getActionOnTimeout() {
            return actionOnTimeout;
        }

        @Override
        public final Builder actionOnTimeout(String actionOnTimeout) {
            this.actionOnTimeout = actionOnTimeout;
            return this;
        }

        @Override
        public final Builder actionOnTimeout(DeploymentReadyAction actionOnTimeout) {
            this.actionOnTimeout(actionOnTimeout.toString());
            return this;
        }

        public final void setActionOnTimeout(String actionOnTimeout) {
            this.actionOnTimeout = actionOnTimeout;
        }

        public final void setActionOnTimeout(DeploymentReadyAction actionOnTimeout) {
            this.actionOnTimeout(actionOnTimeout.toString());
        }

        public final Integer getWaitTimeInMinutes() {
            return waitTimeInMinutes;
        }

        @Override
        public final Builder waitTimeInMinutes(Integer waitTimeInMinutes) {
            this.waitTimeInMinutes = waitTimeInMinutes;
            return this;
        }

        public final void setWaitTimeInMinutes(Integer waitTimeInMinutes) {
            this.waitTimeInMinutes = waitTimeInMinutes;
        }

        @Override
        public DeploymentReadyOption build() {
            return new DeploymentReadyOption(this);
        }
    }
}
