/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentOverviewMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the deployment status of the instances in the deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeploymentOverview implements StructuredPojo, ToCopyableBuilder<DeploymentOverview.Builder, DeploymentOverview> {
    private final Long pending;

    private final Long inProgress;

    private final Long succeeded;

    private final Long failed;

    private final Long skipped;

    private final Long ready;

    private DeploymentOverview(BuilderImpl builder) {
        this.pending = builder.pending;
        this.inProgress = builder.inProgress;
        this.succeeded = builder.succeeded;
        this.failed = builder.failed;
        this.skipped = builder.skipped;
        this.ready = builder.ready;
    }

    /**
     * <p>
     * The number of instances in the deployment in a pending state.
     * </p>
     * 
     * @return The number of instances in the deployment in a pending state.
     */
    public Long pending() {
        return pending;
    }

    /**
     * <p>
     * The number of instances in which the deployment is in progress.
     * </p>
     * 
     * @return The number of instances in which the deployment is in progress.
     */
    public Long inProgress() {
        return inProgress;
    }

    /**
     * <p>
     * The number of instances in the deployment to which revisions have been successfully deployed.
     * </p>
     * 
     * @return The number of instances in the deployment to which revisions have been successfully deployed.
     */
    public Long succeeded() {
        return succeeded;
    }

    /**
     * <p>
     * The number of instances in the deployment in a failed state.
     * </p>
     * 
     * @return The number of instances in the deployment in a failed state.
     */
    public Long failed() {
        return failed;
    }

    /**
     * <p>
     * The number of instances in the deployment in a skipped state.
     * </p>
     * 
     * @return The number of instances in the deployment in a skipped state.
     */
    public Long skipped() {
        return skipped;
    }

    /**
     * <p>
     * The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.
     * </p>
     * 
     * @return The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.
     */
    public Long ready() {
        return ready;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((pending() == null) ? 0 : pending().hashCode());
        hashCode = 31 * hashCode + ((inProgress() == null) ? 0 : inProgress().hashCode());
        hashCode = 31 * hashCode + ((succeeded() == null) ? 0 : succeeded().hashCode());
        hashCode = 31 * hashCode + ((failed() == null) ? 0 : failed().hashCode());
        hashCode = 31 * hashCode + ((skipped() == null) ? 0 : skipped().hashCode());
        hashCode = 31 * hashCode + ((ready() == null) ? 0 : ready().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentOverview)) {
            return false;
        }
        DeploymentOverview other = (DeploymentOverview) obj;
        if (other.pending() == null ^ this.pending() == null) {
            return false;
        }
        if (other.pending() != null && !other.pending().equals(this.pending())) {
            return false;
        }
        if (other.inProgress() == null ^ this.inProgress() == null) {
            return false;
        }
        if (other.inProgress() != null && !other.inProgress().equals(this.inProgress())) {
            return false;
        }
        if (other.succeeded() == null ^ this.succeeded() == null) {
            return false;
        }
        if (other.succeeded() != null && !other.succeeded().equals(this.succeeded())) {
            return false;
        }
        if (other.failed() == null ^ this.failed() == null) {
            return false;
        }
        if (other.failed() != null && !other.failed().equals(this.failed())) {
            return false;
        }
        if (other.skipped() == null ^ this.skipped() == null) {
            return false;
        }
        if (other.skipped() != null && !other.skipped().equals(this.skipped())) {
            return false;
        }
        if (other.ready() == null ^ this.ready() == null) {
            return false;
        }
        if (other.ready() != null && !other.ready().equals(this.ready())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (pending() != null) {
            sb.append("Pending: ").append(pending()).append(",");
        }
        if (inProgress() != null) {
            sb.append("InProgress: ").append(inProgress()).append(",");
        }
        if (succeeded() != null) {
            sb.append("Succeeded: ").append(succeeded()).append(",");
        }
        if (failed() != null) {
            sb.append("Failed: ").append(failed()).append(",");
        }
        if (skipped() != null) {
            sb.append("Skipped: ").append(skipped()).append(",");
        }
        if (ready() != null) {
            sb.append("Ready: ").append(ready()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentOverviewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeploymentOverview> {
        /**
         * <p>
         * The number of instances in the deployment in a pending state.
         * </p>
         * 
         * @param pending
         *        The number of instances in the deployment in a pending state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Long pending);

        /**
         * <p>
         * The number of instances in which the deployment is in progress.
         * </p>
         * 
         * @param inProgress
         *        The number of instances in which the deployment is in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgress(Long inProgress);

        /**
         * <p>
         * The number of instances in the deployment to which revisions have been successfully deployed.
         * </p>
         * 
         * @param succeeded
         *        The number of instances in the deployment to which revisions have been successfully deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeeded(Long succeeded);

        /**
         * <p>
         * The number of instances in the deployment in a failed state.
         * </p>
         * 
         * @param failed
         *        The number of instances in the deployment in a failed state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Long failed);

        /**
         * <p>
         * The number of instances in the deployment in a skipped state.
         * </p>
         * 
         * @param skipped
         *        The number of instances in the deployment in a skipped state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipped(Long skipped);

        /**
         * <p>
         * The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.
         * </p>
         * 
         * @param ready
         *        The number of instances in a replacement environment ready to receive traffic in a blue/green
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ready(Long ready);
    }

    private static final class BuilderImpl implements Builder {
        private Long pending;

        private Long inProgress;

        private Long succeeded;

        private Long failed;

        private Long skipped;

        private Long ready;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentOverview model) {
            setPending(model.pending);
            setInProgress(model.inProgress);
            setSucceeded(model.succeeded);
            setFailed(model.failed);
            setSkipped(model.skipped);
            setReady(model.ready);
        }

        public final Long getPending() {
            return pending;
        }

        @Override
        public final Builder pending(Long pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(Long pending) {
            this.pending = pending;
        }

        public final Long getInProgress() {
            return inProgress;
        }

        @Override
        public final Builder inProgress(Long inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public final void setInProgress(Long inProgress) {
            this.inProgress = inProgress;
        }

        public final Long getSucceeded() {
            return succeeded;
        }

        @Override
        public final Builder succeeded(Long succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        public final void setSucceeded(Long succeeded) {
            this.succeeded = succeeded;
        }

        public final Long getFailed() {
            return failed;
        }

        @Override
        public final Builder failed(Long failed) {
            this.failed = failed;
            return this;
        }

        public final void setFailed(Long failed) {
            this.failed = failed;
        }

        public final Long getSkipped() {
            return skipped;
        }

        @Override
        public final Builder skipped(Long skipped) {
            this.skipped = skipped;
            return this;
        }

        public final void setSkipped(Long skipped) {
            this.skipped = skipped;
        }

        public final Long getReady() {
            return ready;
        }

        @Override
        public final Builder ready(Long ready) {
            this.ready = ready;
            return this;
        }

        public final void setReady(Long ready) {
            this.ready = ready;
        }

        @Override
        public DeploymentOverview build() {
            return new DeploymentOverview(this);
        }
    }
}
