/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeploymentInfo implements StructuredPojo, ToCopyableBuilder<DeploymentInfo.Builder, DeploymentInfo> {
    private final String applicationName;

    private final String deploymentGroupName;

    private final String deploymentConfigName;

    private final String deploymentId;

    private final RevisionLocation previousRevision;

    private final RevisionLocation revision;

    private final String status;

    private final ErrorInformation errorInformation;

    private final Date createTime;

    private final Date startTime;

    private final Date completeTime;

    private final DeploymentOverview deploymentOverview;

    private final String description;

    private final String creator;

    private final Boolean ignoreApplicationStopFailures;

    private final AutoRollbackConfiguration autoRollbackConfiguration;

    private final Boolean updateOutdatedInstancesOnly;

    private final RollbackInfo rollbackInfo;

    private final DeploymentStyle deploymentStyle;

    private final TargetInstances targetInstances;

    private final Boolean instanceTerminationWaitTimeStarted;

    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

    private final LoadBalancerInfo loadBalancerInfo;

    private final String additionalDeploymentStatusInfo;

    private final String fileExistsBehavior;

    private DeploymentInfo(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.deploymentId = builder.deploymentId;
        this.previousRevision = builder.previousRevision;
        this.revision = builder.revision;
        this.status = builder.status;
        this.errorInformation = builder.errorInformation;
        this.createTime = builder.createTime;
        this.startTime = builder.startTime;
        this.completeTime = builder.completeTime;
        this.deploymentOverview = builder.deploymentOverview;
        this.description = builder.description;
        this.creator = builder.creator;
        this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.updateOutdatedInstancesOnly = builder.updateOutdatedInstancesOnly;
        this.rollbackInfo = builder.rollbackInfo;
        this.deploymentStyle = builder.deploymentStyle;
        this.targetInstances = builder.targetInstances;
        this.instanceTerminationWaitTimeStarted = builder.instanceTerminationWaitTimeStarted;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.additionalDeploymentStatusInfo = builder.additionalDeploymentStatusInfo;
        this.fileExistsBehavior = builder.fileExistsBehavior;
    }

    /**
     * <p>
     * The application name.
     * </p>
     * 
     * @return The application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The deployment group name.
     * </p>
     * 
     * @return The deployment group name.
     */
    public String deploymentGroupName() {
        return deploymentGroupName;
    }

    /**
     * <p>
     * The deployment configuration name.
     * </p>
     * 
     * @return The deployment configuration name.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * The deployment ID.
     * </p>
     * 
     * @return The deployment ID.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * Information about the application revision that was deployed to the deployment group before the most recent
     * successful deployment.
     * </p>
     * 
     * @return Information about the application revision that was deployed to the deployment group before the most
     *         recent successful deployment.
     */
    public RevisionLocation previousRevision() {
        return previousRevision;
    }

    /**
     * <p>
     * Information about the location of stored application artifacts and the service from which to retrieve them.
     * </p>
     * 
     * @return Information about the location of stored application artifacts and the service from which to retrieve
     *         them.
     */
    public RevisionLocation revision() {
        return revision;
    }

    /**
     * <p>
     * The current state of the deployment as a whole.
     * </p>
     * 
     * @return The current state of the deployment as a whole.
     * @see DeploymentStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * Information about any error associated with this deployment.
     * </p>
     * 
     * @return Information about any error associated with this deployment.
     */
    public ErrorInformation errorInformation() {
        return errorInformation;
    }

    /**
     * <p>
     * A timestamp indicating when the deployment was created.
     * </p>
     * 
     * @return A timestamp indicating when the deployment was created.
     */
    public Date createTime() {
        return createTime;
    }

    /**
     * <p>
     * A timestamp indicating when the deployment was deployed to the deployment group.
     * </p>
     * <p>
     * In some cases, the reported value of the start time may be later than the complete time. This is due to
     * differences in the clock settings of back-end servers that participate in the deployment process.
     * </p>
     * 
     * @return A timestamp indicating when the deployment was deployed to the deployment group.</p>
     *         <p>
     *         In some cases, the reported value of the start time may be later than the complete time. This is due to
     *         differences in the clock settings of back-end servers that participate in the deployment process.
     */
    public Date startTime() {
        return startTime;
    }

    /**
     * <p>
     * A timestamp indicating when the deployment was complete.
     * </p>
     * 
     * @return A timestamp indicating when the deployment was complete.
     */
    public Date completeTime() {
        return completeTime;
    }

    /**
     * <p>
     * A summary of the deployment status of the instances in the deployment.
     * </p>
     * 
     * @return A summary of the deployment status of the instances in the deployment.
     */
    public DeploymentOverview deploymentOverview() {
        return deploymentOverview;
    }

    /**
     * <p>
     * A comment about the deployment.
     * </p>
     * 
     * @return A comment about the deployment.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The means by which the deployment was created:
     * </p>
     * <ul>
     * <li>
     * <p>
     * user: A user created the deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * autoscaling: Auto Scaling created the deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * codeDeployRollback: A rollback process created the deployment.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The means by which the deployment was created:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         user: A user created the deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         autoscaling: Auto Scaling created the deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         codeDeployRollback: A rollback process created the deployment.
     *         </p>
     *         </li>
     * @see DeploymentCreator
     */
    public String creator() {
        return creator;
    }

    /**
     * <p>
     * If true, then if the deployment causes the ApplicationStop deployment lifecycle event to an instance to fail, the
     * deployment to that instance will not be considered to have failed at that point and will continue on to the
     * BeforeInstall deployment lifecycle event.
     * </p>
     * <p>
     * If false or not specified, then if the deployment causes the ApplicationStop deployment lifecycle event to an
     * instance to fail, the deployment to that instance will stop, and the deployment to that instance will be
     * considered to have failed.
     * </p>
     * 
     * @return If true, then if the deployment causes the ApplicationStop deployment lifecycle event to an instance to
     *         fail, the deployment to that instance will not be considered to have failed at that point and will
     *         continue on to the BeforeInstall deployment lifecycle event.</p>
     *         <p>
     *         If false or not specified, then if the deployment causes the ApplicationStop deployment lifecycle event
     *         to an instance to fail, the deployment to that instance will stop, and the deployment to that instance
     *         will be considered to have failed.
     */
    public Boolean ignoreApplicationStopFailures() {
        return ignoreApplicationStopFailures;
    }

    /**
     * <p>
     * Information about the automatic rollback configuration associated with the deployment.
     * </p>
     * 
     * @return Information about the automatic rollback configuration associated with the deployment.
     */
    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    /**
     * <p>
     * Indicates whether only instances that are not running the latest application revision are to be deployed to.
     * </p>
     * 
     * @return Indicates whether only instances that are not running the latest application revision are to be deployed
     *         to.
     */
    public Boolean updateOutdatedInstancesOnly() {
        return updateOutdatedInstancesOnly;
    }

    /**
     * <p>
     * Information about a deployment rollback.
     * </p>
     * 
     * @return Information about a deployment rollback.
     */
    public RollbackInfo rollbackInfo() {
        return rollbackInfo;
    }

    /**
     * <p>
     * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
     * deployment traffic behind a load balancer.
     * </p>
     * 
     * @return Information about the type of deployment, either in-place or blue/green, you want to run and whether to
     *         route deployment traffic behind a load balancer.
     */
    public DeploymentStyle deploymentStyle() {
        return deploymentStyle;
    }

    /**
     * <p>
     * Information about the instances that belong to the replacement environment in a blue/green deployment.
     * </p>
     * 
     * @return Information about the instances that belong to the replacement environment in a blue/green deployment.
     */
    public TargetInstances targetInstances() {
        return targetInstances;
    }

    /**
     * <p>
     * Indicates whether the wait period set for the termination of instances in the original environment has started.
     * Status is 'false' if the KEEP_ALIVE option is specified; otherwise, 'true' as soon as the termination wait period
     * starts.
     * </p>
     * 
     * @return Indicates whether the wait period set for the termination of instances in the original environment has
     *         started. Status is 'false' if the KEEP_ALIVE option is specified; otherwise, 'true' as soon as the
     *         termination wait period starts.
     */
    public Boolean instanceTerminationWaitTimeStarted() {
        return instanceTerminationWaitTimeStarted;
    }

    /**
     * <p>
     * Information about blue/green deployment options for this deployment.
     * </p>
     * 
     * @return Information about blue/green deployment options for this deployment.
     */
    public BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return blueGreenDeploymentConfiguration;
    }

    /**
     * <p>
     * Information about the load balancer used in the deployment.
     * </p>
     * 
     * @return Information about the load balancer used in the deployment.
     */
    public LoadBalancerInfo loadBalancerInfo() {
        return loadBalancerInfo;
    }

    /**
     * <p>
     * Provides information about the results of a deployment, such as whether instances in the original environment in
     * a blue/green deployment were not terminated.
     * </p>
     * 
     * @return Provides information about the results of a deployment, such as whether instances in the original
     *         environment in a blue/green deployment were not terminated.
     */
    public String additionalDeploymentStatusInfo() {
        return additionalDeploymentStatusInfo;
    }

    /**
     * <p>
     * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't
     * part of the previous successful deployment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * OVERWRITE: The version of the file from the application revision currently being deployed replaces the version
     * already on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
     *         weren't part of the previous successful deployment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OVERWRITE: The version of the file from the application revision currently being deployed replaces the
     *         version already on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     *         </p>
     *         </li>
     * @see FileExistsBehavior
     */
    public String fileExistsBehavior() {
        return fileExistsBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((deploymentGroupName() == null) ? 0 : deploymentGroupName().hashCode());
        hashCode = 31 * hashCode + ((deploymentConfigName() == null) ? 0 : deploymentConfigName().hashCode());
        hashCode = 31 * hashCode + ((deploymentId() == null) ? 0 : deploymentId().hashCode());
        hashCode = 31 * hashCode + ((previousRevision() == null) ? 0 : previousRevision().hashCode());
        hashCode = 31 * hashCode + ((revision() == null) ? 0 : revision().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((errorInformation() == null) ? 0 : errorInformation().hashCode());
        hashCode = 31 * hashCode + ((createTime() == null) ? 0 : createTime().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((completeTime() == null) ? 0 : completeTime().hashCode());
        hashCode = 31 * hashCode + ((deploymentOverview() == null) ? 0 : deploymentOverview().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((creator() == null) ? 0 : creator().hashCode());
        hashCode = 31 * hashCode + ((ignoreApplicationStopFailures() == null) ? 0 : ignoreApplicationStopFailures().hashCode());
        hashCode = 31 * hashCode + ((autoRollbackConfiguration() == null) ? 0 : autoRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + ((updateOutdatedInstancesOnly() == null) ? 0 : updateOutdatedInstancesOnly().hashCode());
        hashCode = 31 * hashCode + ((rollbackInfo() == null) ? 0 : rollbackInfo().hashCode());
        hashCode = 31 * hashCode + ((deploymentStyle() == null) ? 0 : deploymentStyle().hashCode());
        hashCode = 31 * hashCode + ((targetInstances() == null) ? 0 : targetInstances().hashCode());
        hashCode = 31 * hashCode
                + ((instanceTerminationWaitTimeStarted() == null) ? 0 : instanceTerminationWaitTimeStarted().hashCode());
        hashCode = 31 * hashCode
                + ((blueGreenDeploymentConfiguration() == null) ? 0 : blueGreenDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + ((loadBalancerInfo() == null) ? 0 : loadBalancerInfo().hashCode());
        hashCode = 31 * hashCode + ((additionalDeploymentStatusInfo() == null) ? 0 : additionalDeploymentStatusInfo().hashCode());
        hashCode = 31 * hashCode + ((fileExistsBehavior() == null) ? 0 : fileExistsBehavior().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentInfo)) {
            return false;
        }
        DeploymentInfo other = (DeploymentInfo) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroupName() == null ^ this.deploymentGroupName() == null) {
            return false;
        }
        if (other.deploymentGroupName() != null && !other.deploymentGroupName().equals(this.deploymentGroupName())) {
            return false;
        }
        if (other.deploymentConfigName() == null ^ this.deploymentConfigName() == null) {
            return false;
        }
        if (other.deploymentConfigName() != null && !other.deploymentConfigName().equals(this.deploymentConfigName())) {
            return false;
        }
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.previousRevision() == null ^ this.previousRevision() == null) {
            return false;
        }
        if (other.previousRevision() != null && !other.previousRevision().equals(this.previousRevision())) {
            return false;
        }
        if (other.revision() == null ^ this.revision() == null) {
            return false;
        }
        if (other.revision() != null && !other.revision().equals(this.revision())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.errorInformation() == null ^ this.errorInformation() == null) {
            return false;
        }
        if (other.errorInformation() != null && !other.errorInformation().equals(this.errorInformation())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.completeTime() == null ^ this.completeTime() == null) {
            return false;
        }
        if (other.completeTime() != null && !other.completeTime().equals(this.completeTime())) {
            return false;
        }
        if (other.deploymentOverview() == null ^ this.deploymentOverview() == null) {
            return false;
        }
        if (other.deploymentOverview() != null && !other.deploymentOverview().equals(this.deploymentOverview())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.creator() == null ^ this.creator() == null) {
            return false;
        }
        if (other.creator() != null && !other.creator().equals(this.creator())) {
            return false;
        }
        if (other.ignoreApplicationStopFailures() == null ^ this.ignoreApplicationStopFailures() == null) {
            return false;
        }
        if (other.ignoreApplicationStopFailures() != null
                && !other.ignoreApplicationStopFailures().equals(this.ignoreApplicationStopFailures())) {
            return false;
        }
        if (other.autoRollbackConfiguration() == null ^ this.autoRollbackConfiguration() == null) {
            return false;
        }
        if (other.autoRollbackConfiguration() != null
                && !other.autoRollbackConfiguration().equals(this.autoRollbackConfiguration())) {
            return false;
        }
        if (other.updateOutdatedInstancesOnly() == null ^ this.updateOutdatedInstancesOnly() == null) {
            return false;
        }
        if (other.updateOutdatedInstancesOnly() != null
                && !other.updateOutdatedInstancesOnly().equals(this.updateOutdatedInstancesOnly())) {
            return false;
        }
        if (other.rollbackInfo() == null ^ this.rollbackInfo() == null) {
            return false;
        }
        if (other.rollbackInfo() != null && !other.rollbackInfo().equals(this.rollbackInfo())) {
            return false;
        }
        if (other.deploymentStyle() == null ^ this.deploymentStyle() == null) {
            return false;
        }
        if (other.deploymentStyle() != null && !other.deploymentStyle().equals(this.deploymentStyle())) {
            return false;
        }
        if (other.targetInstances() == null ^ this.targetInstances() == null) {
            return false;
        }
        if (other.targetInstances() != null && !other.targetInstances().equals(this.targetInstances())) {
            return false;
        }
        if (other.instanceTerminationWaitTimeStarted() == null ^ this.instanceTerminationWaitTimeStarted() == null) {
            return false;
        }
        if (other.instanceTerminationWaitTimeStarted() != null
                && !other.instanceTerminationWaitTimeStarted().equals(this.instanceTerminationWaitTimeStarted())) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() == null ^ this.blueGreenDeploymentConfiguration() == null) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() != null
                && !other.blueGreenDeploymentConfiguration().equals(this.blueGreenDeploymentConfiguration())) {
            return false;
        }
        if (other.loadBalancerInfo() == null ^ this.loadBalancerInfo() == null) {
            return false;
        }
        if (other.loadBalancerInfo() != null && !other.loadBalancerInfo().equals(this.loadBalancerInfo())) {
            return false;
        }
        if (other.additionalDeploymentStatusInfo() == null ^ this.additionalDeploymentStatusInfo() == null) {
            return false;
        }
        if (other.additionalDeploymentStatusInfo() != null
                && !other.additionalDeploymentStatusInfo().equals(this.additionalDeploymentStatusInfo())) {
            return false;
        }
        if (other.fileExistsBehavior() == null ^ this.fileExistsBehavior() == null) {
            return false;
        }
        if (other.fileExistsBehavior() != null && !other.fileExistsBehavior().equals(this.fileExistsBehavior())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (deploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(deploymentGroupName()).append(",");
        }
        if (deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(deploymentConfigName()).append(",");
        }
        if (deploymentId() != null) {
            sb.append("DeploymentId: ").append(deploymentId()).append(",");
        }
        if (previousRevision() != null) {
            sb.append("PreviousRevision: ").append(previousRevision()).append(",");
        }
        if (revision() != null) {
            sb.append("Revision: ").append(revision()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (errorInformation() != null) {
            sb.append("ErrorInformation: ").append(errorInformation()).append(",");
        }
        if (createTime() != null) {
            sb.append("CreateTime: ").append(createTime()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (completeTime() != null) {
            sb.append("CompleteTime: ").append(completeTime()).append(",");
        }
        if (deploymentOverview() != null) {
            sb.append("DeploymentOverview: ").append(deploymentOverview()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (creator() != null) {
            sb.append("Creator: ").append(creator()).append(",");
        }
        if (ignoreApplicationStopFailures() != null) {
            sb.append("IgnoreApplicationStopFailures: ").append(ignoreApplicationStopFailures()).append(",");
        }
        if (autoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(autoRollbackConfiguration()).append(",");
        }
        if (updateOutdatedInstancesOnly() != null) {
            sb.append("UpdateOutdatedInstancesOnly: ").append(updateOutdatedInstancesOnly()).append(",");
        }
        if (rollbackInfo() != null) {
            sb.append("RollbackInfo: ").append(rollbackInfo()).append(",");
        }
        if (deploymentStyle() != null) {
            sb.append("DeploymentStyle: ").append(deploymentStyle()).append(",");
        }
        if (targetInstances() != null) {
            sb.append("TargetInstances: ").append(targetInstances()).append(",");
        }
        if (instanceTerminationWaitTimeStarted() != null) {
            sb.append("InstanceTerminationWaitTimeStarted: ").append(instanceTerminationWaitTimeStarted()).append(",");
        }
        if (blueGreenDeploymentConfiguration() != null) {
            sb.append("BlueGreenDeploymentConfiguration: ").append(blueGreenDeploymentConfiguration()).append(",");
        }
        if (loadBalancerInfo() != null) {
            sb.append("LoadBalancerInfo: ").append(loadBalancerInfo()).append(",");
        }
        if (additionalDeploymentStatusInfo() != null) {
            sb.append("AdditionalDeploymentStatusInfo: ").append(additionalDeploymentStatusInfo()).append(",");
        }
        if (fileExistsBehavior() != null) {
            sb.append("FileExistsBehavior: ").append(fileExistsBehavior()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeploymentInfo> {
        /**
         * <p>
         * The application name.
         * </p>
         * 
         * @param applicationName
         *        The application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The deployment group name.
         * </p>
         * 
         * @param deploymentGroupName
         *        The deployment group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupName(String deploymentGroupName);

        /**
         * <p>
         * The deployment configuration name.
         * </p>
         * 
         * @param deploymentConfigName
         *        The deployment configuration name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * The deployment ID.
         * </p>
         * 
         * @param deploymentId
         *        The deployment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * Information about the application revision that was deployed to the deployment group before the most recent
         * successful deployment.
         * </p>
         * 
         * @param previousRevision
         *        Information about the application revision that was deployed to the deployment group before the most
         *        recent successful deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousRevision(RevisionLocation previousRevision);

        /**
         * <p>
         * Information about the location of stored application artifacts and the service from which to retrieve them.
         * </p>
         * 
         * @param revision
         *        Information about the location of stored application artifacts and the service from which to retrieve
         *        them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(RevisionLocation revision);

        /**
         * <p>
         * The current state of the deployment as a whole.
         * </p>
         * 
         * @param status
         *        The current state of the deployment as a whole.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the deployment as a whole.
         * </p>
         * 
         * @param status
         *        The current state of the deployment as a whole.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(DeploymentStatus status);

        /**
         * <p>
         * Information about any error associated with this deployment.
         * </p>
         * 
         * @param errorInformation
         *        Information about any error associated with this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInformation(ErrorInformation errorInformation);

        /**
         * <p>
         * A timestamp indicating when the deployment was created.
         * </p>
         * 
         * @param createTime
         *        A timestamp indicating when the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Date createTime);

        /**
         * <p>
         * A timestamp indicating when the deployment was deployed to the deployment group.
         * </p>
         * <p>
         * In some cases, the reported value of the start time may be later than the complete time. This is due to
         * differences in the clock settings of back-end servers that participate in the deployment process.
         * </p>
         * 
         * @param startTime
         *        A timestamp indicating when the deployment was deployed to the deployment group.</p>
         *        <p>
         *        In some cases, the reported value of the start time may be later than the complete time. This is due
         *        to differences in the clock settings of back-end servers that participate in the deployment process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Date startTime);

        /**
         * <p>
         * A timestamp indicating when the deployment was complete.
         * </p>
         * 
         * @param completeTime
         *        A timestamp indicating when the deployment was complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completeTime(Date completeTime);

        /**
         * <p>
         * A summary of the deployment status of the instances in the deployment.
         * </p>
         * 
         * @param deploymentOverview
         *        A summary of the deployment status of the instances in the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentOverview(DeploymentOverview deploymentOverview);

        /**
         * <p>
         * A comment about the deployment.
         * </p>
         * 
         * @param description
         *        A comment about the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The means by which the deployment was created:
         * </p>
         * <ul>
         * <li>
         * <p>
         * user: A user created the deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * autoscaling: Auto Scaling created the deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * codeDeployRollback: A rollback process created the deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param creator
         *        The means by which the deployment was created:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        user: A user created the deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        autoscaling: Auto Scaling created the deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        codeDeployRollback: A rollback process created the deployment.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentCreator
         */
        Builder creator(String creator);

        /**
         * <p>
         * The means by which the deployment was created:
         * </p>
         * <ul>
         * <li>
         * <p>
         * user: A user created the deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * autoscaling: Auto Scaling created the deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * codeDeployRollback: A rollback process created the deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param creator
         *        The means by which the deployment was created:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        user: A user created the deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        autoscaling: Auto Scaling created the deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        codeDeployRollback: A rollback process created the deployment.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentCreator
         */
        Builder creator(DeploymentCreator creator);

        /**
         * <p>
         * If true, then if the deployment causes the ApplicationStop deployment lifecycle event to an instance to fail,
         * the deployment to that instance will not be considered to have failed at that point and will continue on to
         * the BeforeInstall deployment lifecycle event.
         * </p>
         * <p>
         * If false or not specified, then if the deployment causes the ApplicationStop deployment lifecycle event to an
         * instance to fail, the deployment to that instance will stop, and the deployment to that instance will be
         * considered to have failed.
         * </p>
         * 
         * @param ignoreApplicationStopFailures
         *        If true, then if the deployment causes the ApplicationStop deployment lifecycle event to an instance
         *        to fail, the deployment to that instance will not be considered to have failed at that point and will
         *        continue on to the BeforeInstall deployment lifecycle event.</p>
         *        <p>
         *        If false or not specified, then if the deployment causes the ApplicationStop deployment lifecycle
         *        event to an instance to fail, the deployment to that instance will stop, and the deployment to that
         *        instance will be considered to have failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures);

        /**
         * <p>
         * Information about the automatic rollback configuration associated with the deployment.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Information about the automatic rollback configuration associated with the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration);

        /**
         * <p>
         * Indicates whether only instances that are not running the latest application revision are to be deployed to.
         * </p>
         * 
         * @param updateOutdatedInstancesOnly
         *        Indicates whether only instances that are not running the latest application revision are to be
         *        deployed to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly);

        /**
         * <p>
         * Information about a deployment rollback.
         * </p>
         * 
         * @param rollbackInfo
         *        Information about a deployment rollback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackInfo(RollbackInfo rollbackInfo);

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentStyle
         *        Information about the type of deployment, either in-place or blue/green, you want to run and whether
         *        to route deployment traffic behind a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStyle(DeploymentStyle deploymentStyle);

        /**
         * <p>
         * Information about the instances that belong to the replacement environment in a blue/green deployment.
         * </p>
         * 
         * @param targetInstances
         *        Information about the instances that belong to the replacement environment in a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetInstances(TargetInstances targetInstances);

        /**
         * <p>
         * Indicates whether the wait period set for the termination of instances in the original environment has
         * started. Status is 'false' if the KEEP_ALIVE option is specified; otherwise, 'true' as soon as the
         * termination wait period starts.
         * </p>
         * 
         * @param instanceTerminationWaitTimeStarted
         *        Indicates whether the wait period set for the termination of instances in the original environment has
         *        started. Status is 'false' if the KEEP_ALIVE option is specified; otherwise, 'true' as soon as the
         *        termination wait period starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted);

        /**
         * <p>
         * Information about blue/green deployment options for this deployment.
         * </p>
         * 
         * @param blueGreenDeploymentConfiguration
         *        Information about blue/green deployment options for this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration);

        /**
         * <p>
         * Information about the load balancer used in the deployment.
         * </p>
         * 
         * @param loadBalancerInfo
         *        Information about the load balancer used in the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo);

        /**
         * <p>
         * Provides information about the results of a deployment, such as whether instances in the original environment
         * in a blue/green deployment were not terminated.
         * </p>
         * 
         * @param additionalDeploymentStatusInfo
         *        Provides information about the results of a deployment, such as whether instances in the original
         *        environment in a blue/green deployment were not terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDeploymentStatusInfo(String additionalDeploymentStatusInfo);

        /**
         * <p>
         * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
         * weren't part of the previous successful deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         * version already on the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileExistsBehavior
         *        Information about how AWS CodeDeploy handles files that already exist in a deployment target location
         *        but weren't part of the previous successful deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         *        version already on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RETAIN: The version of the file already on the instance is kept and used as part of the new
         *        deployment.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileExistsBehavior
         */
        Builder fileExistsBehavior(String fileExistsBehavior);

        /**
         * <p>
         * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
         * weren't part of the previous successful deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         * version already on the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileExistsBehavior
         *        Information about how AWS CodeDeploy handles files that already exist in a deployment target location
         *        but weren't part of the previous successful deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         *        version already on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RETAIN: The version of the file already on the instance is kept and used as part of the new
         *        deployment.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileExistsBehavior
         */
        Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private String deploymentGroupName;

        private String deploymentConfigName;

        private String deploymentId;

        private RevisionLocation previousRevision;

        private RevisionLocation revision;

        private String status;

        private ErrorInformation errorInformation;

        private Date createTime;

        private Date startTime;

        private Date completeTime;

        private DeploymentOverview deploymentOverview;

        private String description;

        private String creator;

        private Boolean ignoreApplicationStopFailures;

        private AutoRollbackConfiguration autoRollbackConfiguration;

        private Boolean updateOutdatedInstancesOnly;

        private RollbackInfo rollbackInfo;

        private DeploymentStyle deploymentStyle;

        private TargetInstances targetInstances;

        private Boolean instanceTerminationWaitTimeStarted;

        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

        private LoadBalancerInfo loadBalancerInfo;

        private String additionalDeploymentStatusInfo;

        private String fileExistsBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentInfo model) {
            setApplicationName(model.applicationName);
            setDeploymentGroupName(model.deploymentGroupName);
            setDeploymentConfigName(model.deploymentConfigName);
            setDeploymentId(model.deploymentId);
            setPreviousRevision(model.previousRevision);
            setRevision(model.revision);
            setStatus(model.status);
            setErrorInformation(model.errorInformation);
            setCreateTime(model.createTime);
            setStartTime(model.startTime);
            setCompleteTime(model.completeTime);
            setDeploymentOverview(model.deploymentOverview);
            setDescription(model.description);
            setCreator(model.creator);
            setIgnoreApplicationStopFailures(model.ignoreApplicationStopFailures);
            setAutoRollbackConfiguration(model.autoRollbackConfiguration);
            setUpdateOutdatedInstancesOnly(model.updateOutdatedInstancesOnly);
            setRollbackInfo(model.rollbackInfo);
            setDeploymentStyle(model.deploymentStyle);
            setTargetInstances(model.targetInstances);
            setInstanceTerminationWaitTimeStarted(model.instanceTerminationWaitTimeStarted);
            setBlueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            setLoadBalancerInfo(model.loadBalancerInfo);
            setAdditionalDeploymentStatusInfo(model.additionalDeploymentStatusInfo);
            setFileExistsBehavior(model.fileExistsBehavior);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final RevisionLocation getPreviousRevision() {
            return previousRevision;
        }

        @Override
        public final Builder previousRevision(RevisionLocation previousRevision) {
            this.previousRevision = previousRevision;
            return this;
        }

        public final void setPreviousRevision(RevisionLocation previousRevision) {
            this.previousRevision = previousRevision;
        }

        public final RevisionLocation getRevision() {
            return revision;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation revision) {
            this.revision = revision;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(DeploymentStatus status) {
            this.status(status.toString());
        }

        public final ErrorInformation getErrorInformation() {
            return errorInformation;
        }

        @Override
        public final Builder errorInformation(ErrorInformation errorInformation) {
            this.errorInformation = errorInformation;
            return this;
        }

        public final void setErrorInformation(ErrorInformation errorInformation) {
            this.errorInformation = errorInformation;
        }

        public final Date getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Date createTime) {
            this.createTime = StandardMemberCopier.copy(createTime);
            return this;
        }

        public final void setCreateTime(Date createTime) {
            this.createTime = StandardMemberCopier.copy(createTime);
        }

        public final Date getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
        }

        public final Date getCompleteTime() {
            return completeTime;
        }

        @Override
        public final Builder completeTime(Date completeTime) {
            this.completeTime = StandardMemberCopier.copy(completeTime);
            return this;
        }

        public final void setCompleteTime(Date completeTime) {
            this.completeTime = StandardMemberCopier.copy(completeTime);
        }

        public final DeploymentOverview getDeploymentOverview() {
            return deploymentOverview;
        }

        @Override
        public final Builder deploymentOverview(DeploymentOverview deploymentOverview) {
            this.deploymentOverview = deploymentOverview;
            return this;
        }

        public final void setDeploymentOverview(DeploymentOverview deploymentOverview) {
            this.deploymentOverview = deploymentOverview;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCreator() {
            return creator;
        }

        @Override
        public final Builder creator(String creator) {
            this.creator = creator;
            return this;
        }

        @Override
        public final Builder creator(DeploymentCreator creator) {
            this.creator(creator.toString());
            return this;
        }

        public final void setCreator(String creator) {
            this.creator = creator;
        }

        public final void setCreator(DeploymentCreator creator) {
            this.creator(creator.toString());
        }

        public final Boolean getIgnoreApplicationStopFailures() {
            return ignoreApplicationStopFailures;
        }

        @Override
        public final Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            return this;
        }

        public final void setIgnoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
        }

        public final AutoRollbackConfiguration getAutoRollbackConfiguration() {
            return autoRollbackConfiguration;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
        }

        public final Boolean getUpdateOutdatedInstancesOnly() {
            return updateOutdatedInstancesOnly;
        }

        @Override
        public final Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
            return this;
        }

        public final void setUpdateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
        }

        public final RollbackInfo getRollbackInfo() {
            return rollbackInfo;
        }

        @Override
        public final Builder rollbackInfo(RollbackInfo rollbackInfo) {
            this.rollbackInfo = rollbackInfo;
            return this;
        }

        public final void setRollbackInfo(RollbackInfo rollbackInfo) {
            this.rollbackInfo = rollbackInfo;
        }

        public final DeploymentStyle getDeploymentStyle() {
            return deploymentStyle;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final void setDeploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
        }

        public final TargetInstances getTargetInstances() {
            return targetInstances;
        }

        @Override
        public final Builder targetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
            return this;
        }

        public final void setTargetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
        }

        public final Boolean getInstanceTerminationWaitTimeStarted() {
            return instanceTerminationWaitTimeStarted;
        }

        @Override
        public final Builder instanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted) {
            this.instanceTerminationWaitTimeStarted = instanceTerminationWaitTimeStarted;
            return this;
        }

        public final void setInstanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted) {
            this.instanceTerminationWaitTimeStarted = instanceTerminationWaitTimeStarted;
        }

        public final BlueGreenDeploymentConfiguration getBlueGreenDeploymentConfiguration() {
            return blueGreenDeploymentConfiguration;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
        }

        public final LoadBalancerInfo getLoadBalancerInfo() {
            return loadBalancerInfo;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
        }

        public final String getAdditionalDeploymentStatusInfo() {
            return additionalDeploymentStatusInfo;
        }

        @Override
        public final Builder additionalDeploymentStatusInfo(String additionalDeploymentStatusInfo) {
            this.additionalDeploymentStatusInfo = additionalDeploymentStatusInfo;
            return this;
        }

        public final void setAdditionalDeploymentStatusInfo(String additionalDeploymentStatusInfo) {
            this.additionalDeploymentStatusInfo = additionalDeploymentStatusInfo;
        }

        public final String getFileExistsBehavior() {
            return fileExistsBehavior;
        }

        @Override
        public final Builder fileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
            return this;
        }

        @Override
        public final Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior.toString());
            return this;
        }

        public final void setFileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
        }

        public final void setFileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior.toString());
        }

        @Override
        public DeploymentInfo build() {
            return new DeploymentInfo(this);
        }
    }
}
