/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentGroupInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeploymentGroupInfo implements StructuredPojo, ToCopyableBuilder<DeploymentGroupInfo.Builder, DeploymentGroupInfo> {
    private final String applicationName;

    private final String deploymentGroupId;

    private final String deploymentGroupName;

    private final String deploymentConfigName;

    private final List<EC2TagFilter> ec2TagFilters;

    private final List<TagFilter> onPremisesInstanceTagFilters;

    private final List<AutoScalingGroup> autoScalingGroups;

    private final String serviceRoleArn;

    private final RevisionLocation targetRevision;

    private final List<TriggerConfig> triggerConfigurations;

    private final AlarmConfiguration alarmConfiguration;

    private final AutoRollbackConfiguration autoRollbackConfiguration;

    private final DeploymentStyle deploymentStyle;

    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

    private final LoadBalancerInfo loadBalancerInfo;

    private final LastDeploymentInfo lastSuccessfulDeployment;

    private final LastDeploymentInfo lastAttemptedDeployment;

    private DeploymentGroupInfo(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupId = builder.deploymentGroupId;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.ec2TagFilters = builder.ec2TagFilters;
        this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.targetRevision = builder.targetRevision;
        this.triggerConfigurations = builder.triggerConfigurations;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.deploymentStyle = builder.deploymentStyle;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.lastSuccessfulDeployment = builder.lastSuccessfulDeployment;
        this.lastAttemptedDeployment = builder.lastAttemptedDeployment;
    }

    /**
     * <p>
     * The application name.
     * </p>
     * 
     * @return The application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The deployment group ID.
     * </p>
     * 
     * @return The deployment group ID.
     */
    public String deploymentGroupId() {
        return deploymentGroupId;
    }

    /**
     * <p>
     * The deployment group name.
     * </p>
     * 
     * @return The deployment group name.
     */
    public String deploymentGroupName() {
        return deploymentGroupName;
    }

    /**
     * <p>
     * The deployment configuration name.
     * </p>
     * 
     * @return The deployment configuration name.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * The Amazon EC2 tags on which to filter.
     * </p>
     * 
     * @return The Amazon EC2 tags on which to filter.
     */
    public List<EC2TagFilter> ec2TagFilters() {
        return ec2TagFilters;
    }

    /**
     * <p>
     * The on-premises instance tags on which to filter.
     * </p>
     * 
     * @return The on-premises instance tags on which to filter.
     */
    public List<TagFilter> onPremisesInstanceTagFilters() {
        return onPremisesInstanceTagFilters;
    }

    /**
     * <p>
     * A list of associated Auto Scaling groups.
     * </p>
     * 
     * @return A list of associated Auto Scaling groups.
     */
    public List<AutoScalingGroup> autoScalingGroups() {
        return autoScalingGroups;
    }

    /**
     * <p>
     * A service role ARN.
     * </p>
     * 
     * @return A service role ARN.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * Information about the deployment group's target revision, including type and location.
     * </p>
     * 
     * @return Information about the deployment group's target revision, including type and location.
     */
    public RevisionLocation targetRevision() {
        return targetRevision;
    }

    /**
     * <p>
     * Information about triggers associated with the deployment group.
     * </p>
     * 
     * @return Information about triggers associated with the deployment group.
     */
    public List<TriggerConfig> triggerConfigurations() {
        return triggerConfigurations;
    }

    /**
     * <p>
     * A list of alarms associated with the deployment group.
     * </p>
     * 
     * @return A list of alarms associated with the deployment group.
     */
    public AlarmConfiguration alarmConfiguration() {
        return alarmConfiguration;
    }

    /**
     * <p>
     * Information about the automatic rollback configuration associated with the deployment group.
     * </p>
     * 
     * @return Information about the automatic rollback configuration associated with the deployment group.
     */
    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    /**
     * <p>
     * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
     * deployment traffic behind a load balancer.
     * </p>
     * 
     * @return Information about the type of deployment, either in-place or blue/green, you want to run and whether to
     *         route deployment traffic behind a load balancer.
     */
    public DeploymentStyle deploymentStyle() {
        return deploymentStyle;
    }

    /**
     * <p>
     * Information about blue/green deployment options for a deployment group.
     * </p>
     * 
     * @return Information about blue/green deployment options for a deployment group.
     */
    public BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return blueGreenDeploymentConfiguration;
    }

    /**
     * <p>
     * Information about the load balancer to use in a deployment.
     * </p>
     * 
     * @return Information about the load balancer to use in a deployment.
     */
    public LoadBalancerInfo loadBalancerInfo() {
        return loadBalancerInfo;
    }

    /**
     * <p>
     * Information about the most recent successful deployment to the deployment group.
     * </p>
     * 
     * @return Information about the most recent successful deployment to the deployment group.
     */
    public LastDeploymentInfo lastSuccessfulDeployment() {
        return lastSuccessfulDeployment;
    }

    /**
     * <p>
     * Information about the most recent attempted deployment to the deployment group.
     * </p>
     * 
     * @return Information about the most recent attempted deployment to the deployment group.
     */
    public LastDeploymentInfo lastAttemptedDeployment() {
        return lastAttemptedDeployment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((deploymentGroupId() == null) ? 0 : deploymentGroupId().hashCode());
        hashCode = 31 * hashCode + ((deploymentGroupName() == null) ? 0 : deploymentGroupName().hashCode());
        hashCode = 31 * hashCode + ((deploymentConfigName() == null) ? 0 : deploymentConfigName().hashCode());
        hashCode = 31 * hashCode + ((ec2TagFilters() == null) ? 0 : ec2TagFilters().hashCode());
        hashCode = 31 * hashCode + ((onPremisesInstanceTagFilters() == null) ? 0 : onPremisesInstanceTagFilters().hashCode());
        hashCode = 31 * hashCode + ((autoScalingGroups() == null) ? 0 : autoScalingGroups().hashCode());
        hashCode = 31 * hashCode + ((serviceRoleArn() == null) ? 0 : serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + ((targetRevision() == null) ? 0 : targetRevision().hashCode());
        hashCode = 31 * hashCode + ((triggerConfigurations() == null) ? 0 : triggerConfigurations().hashCode());
        hashCode = 31 * hashCode + ((alarmConfiguration() == null) ? 0 : alarmConfiguration().hashCode());
        hashCode = 31 * hashCode + ((autoRollbackConfiguration() == null) ? 0 : autoRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + ((deploymentStyle() == null) ? 0 : deploymentStyle().hashCode());
        hashCode = 31 * hashCode
                + ((blueGreenDeploymentConfiguration() == null) ? 0 : blueGreenDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + ((loadBalancerInfo() == null) ? 0 : loadBalancerInfo().hashCode());
        hashCode = 31 * hashCode + ((lastSuccessfulDeployment() == null) ? 0 : lastSuccessfulDeployment().hashCode());
        hashCode = 31 * hashCode + ((lastAttemptedDeployment() == null) ? 0 : lastAttemptedDeployment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentGroupInfo)) {
            return false;
        }
        DeploymentGroupInfo other = (DeploymentGroupInfo) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroupId() == null ^ this.deploymentGroupId() == null) {
            return false;
        }
        if (other.deploymentGroupId() != null && !other.deploymentGroupId().equals(this.deploymentGroupId())) {
            return false;
        }
        if (other.deploymentGroupName() == null ^ this.deploymentGroupName() == null) {
            return false;
        }
        if (other.deploymentGroupName() != null && !other.deploymentGroupName().equals(this.deploymentGroupName())) {
            return false;
        }
        if (other.deploymentConfigName() == null ^ this.deploymentConfigName() == null) {
            return false;
        }
        if (other.deploymentConfigName() != null && !other.deploymentConfigName().equals(this.deploymentConfigName())) {
            return false;
        }
        if (other.ec2TagFilters() == null ^ this.ec2TagFilters() == null) {
            return false;
        }
        if (other.ec2TagFilters() != null && !other.ec2TagFilters().equals(this.ec2TagFilters())) {
            return false;
        }
        if (other.onPremisesInstanceTagFilters() == null ^ this.onPremisesInstanceTagFilters() == null) {
            return false;
        }
        if (other.onPremisesInstanceTagFilters() != null
                && !other.onPremisesInstanceTagFilters().equals(this.onPremisesInstanceTagFilters())) {
            return false;
        }
        if (other.autoScalingGroups() == null ^ this.autoScalingGroups() == null) {
            return false;
        }
        if (other.autoScalingGroups() != null && !other.autoScalingGroups().equals(this.autoScalingGroups())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.targetRevision() == null ^ this.targetRevision() == null) {
            return false;
        }
        if (other.targetRevision() != null && !other.targetRevision().equals(this.targetRevision())) {
            return false;
        }
        if (other.triggerConfigurations() == null ^ this.triggerConfigurations() == null) {
            return false;
        }
        if (other.triggerConfigurations() != null && !other.triggerConfigurations().equals(this.triggerConfigurations())) {
            return false;
        }
        if (other.alarmConfiguration() == null ^ this.alarmConfiguration() == null) {
            return false;
        }
        if (other.alarmConfiguration() != null && !other.alarmConfiguration().equals(this.alarmConfiguration())) {
            return false;
        }
        if (other.autoRollbackConfiguration() == null ^ this.autoRollbackConfiguration() == null) {
            return false;
        }
        if (other.autoRollbackConfiguration() != null
                && !other.autoRollbackConfiguration().equals(this.autoRollbackConfiguration())) {
            return false;
        }
        if (other.deploymentStyle() == null ^ this.deploymentStyle() == null) {
            return false;
        }
        if (other.deploymentStyle() != null && !other.deploymentStyle().equals(this.deploymentStyle())) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() == null ^ this.blueGreenDeploymentConfiguration() == null) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() != null
                && !other.blueGreenDeploymentConfiguration().equals(this.blueGreenDeploymentConfiguration())) {
            return false;
        }
        if (other.loadBalancerInfo() == null ^ this.loadBalancerInfo() == null) {
            return false;
        }
        if (other.loadBalancerInfo() != null && !other.loadBalancerInfo().equals(this.loadBalancerInfo())) {
            return false;
        }
        if (other.lastSuccessfulDeployment() == null ^ this.lastSuccessfulDeployment() == null) {
            return false;
        }
        if (other.lastSuccessfulDeployment() != null && !other.lastSuccessfulDeployment().equals(this.lastSuccessfulDeployment())) {
            return false;
        }
        if (other.lastAttemptedDeployment() == null ^ this.lastAttemptedDeployment() == null) {
            return false;
        }
        if (other.lastAttemptedDeployment() != null && !other.lastAttemptedDeployment().equals(this.lastAttemptedDeployment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (deploymentGroupId() != null) {
            sb.append("DeploymentGroupId: ").append(deploymentGroupId()).append(",");
        }
        if (deploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(deploymentGroupName()).append(",");
        }
        if (deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(deploymentConfigName()).append(",");
        }
        if (ec2TagFilters() != null) {
            sb.append("Ec2TagFilters: ").append(ec2TagFilters()).append(",");
        }
        if (onPremisesInstanceTagFilters() != null) {
            sb.append("OnPremisesInstanceTagFilters: ").append(onPremisesInstanceTagFilters()).append(",");
        }
        if (autoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(autoScalingGroups()).append(",");
        }
        if (serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(serviceRoleArn()).append(",");
        }
        if (targetRevision() != null) {
            sb.append("TargetRevision: ").append(targetRevision()).append(",");
        }
        if (triggerConfigurations() != null) {
            sb.append("TriggerConfigurations: ").append(triggerConfigurations()).append(",");
        }
        if (alarmConfiguration() != null) {
            sb.append("AlarmConfiguration: ").append(alarmConfiguration()).append(",");
        }
        if (autoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(autoRollbackConfiguration()).append(",");
        }
        if (deploymentStyle() != null) {
            sb.append("DeploymentStyle: ").append(deploymentStyle()).append(",");
        }
        if (blueGreenDeploymentConfiguration() != null) {
            sb.append("BlueGreenDeploymentConfiguration: ").append(blueGreenDeploymentConfiguration()).append(",");
        }
        if (loadBalancerInfo() != null) {
            sb.append("LoadBalancerInfo: ").append(loadBalancerInfo()).append(",");
        }
        if (lastSuccessfulDeployment() != null) {
            sb.append("LastSuccessfulDeployment: ").append(lastSuccessfulDeployment()).append(",");
        }
        if (lastAttemptedDeployment() != null) {
            sb.append("LastAttemptedDeployment: ").append(lastAttemptedDeployment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentGroupInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeploymentGroupInfo> {
        /**
         * <p>
         * The application name.
         * </p>
         * 
         * @param applicationName
         *        The application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The deployment group ID.
         * </p>
         * 
         * @param deploymentGroupId
         *        The deployment group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupId(String deploymentGroupId);

        /**
         * <p>
         * The deployment group name.
         * </p>
         * 
         * @param deploymentGroupName
         *        The deployment group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupName(String deploymentGroupName);

        /**
         * <p>
         * The deployment configuration name.
         * </p>
         * 
         * @param deploymentConfigName
         *        The deployment configuration name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * The Amazon EC2 tags on which to filter.
         * </p>
         * 
         * @param ec2TagFilters
         *        The Amazon EC2 tags on which to filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters);

        /**
         * <p>
         * The Amazon EC2 tags on which to filter.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEc2TagFilters(java.util.Collection)} or {@link #withEc2TagFilters(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param ec2TagFilters
         *        The Amazon EC2 tags on which to filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(EC2TagFilter... ec2TagFilters);

        /**
         * <p>
         * The on-premises instance tags on which to filter.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The on-premises instance tags on which to filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters);

        /**
         * <p>
         * The on-premises instance tags on which to filter.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setOnPremisesInstanceTagFilters(java.util.Collection)} or
         * {@link #withOnPremisesInstanceTagFilters(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The on-premises instance tags on which to filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters);

        /**
         * <p>
         * A list of associated Auto Scaling groups.
         * </p>
         * 
         * @param autoScalingGroups
         *        A list of associated Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups);

        /**
         * <p>
         * A list of associated Auto Scaling groups.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAutoScalingGroups(java.util.Collection)} or {@link #withAutoScalingGroups(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param autoScalingGroups
         *        A list of associated Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(AutoScalingGroup... autoScalingGroups);

        /**
         * <p>
         * A service role ARN.
         * </p>
         * 
         * @param serviceRoleArn
         *        A service role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * Information about the deployment group's target revision, including type and location.
         * </p>
         * 
         * @param targetRevision
         *        Information about the deployment group's target revision, including type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRevision(RevisionLocation targetRevision);

        /**
         * <p>
         * Information about triggers associated with the deployment group.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations);

        /**
         * <p>
         * Information about triggers associated with the deployment group.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTriggerConfigurations(java.util.Collection)} or
         * {@link #withTriggerConfigurations(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(TriggerConfig... triggerConfigurations);

        /**
         * <p>
         * A list of alarms associated with the deployment group.
         * </p>
         * 
         * @param alarmConfiguration
         *        A list of alarms associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfiguration(AlarmConfiguration alarmConfiguration);

        /**
         * <p>
         * Information about the automatic rollback configuration associated with the deployment group.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Information about the automatic rollback configuration associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration);

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentStyle
         *        Information about the type of deployment, either in-place or blue/green, you want to run and whether
         *        to route deployment traffic behind a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStyle(DeploymentStyle deploymentStyle);

        /**
         * <p>
         * Information about blue/green deployment options for a deployment group.
         * </p>
         * 
         * @param blueGreenDeploymentConfiguration
         *        Information about blue/green deployment options for a deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration);

        /**
         * <p>
         * Information about the load balancer to use in a deployment.
         * </p>
         * 
         * @param loadBalancerInfo
         *        Information about the load balancer to use in a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo);

        /**
         * <p>
         * Information about the most recent successful deployment to the deployment group.
         * </p>
         * 
         * @param lastSuccessfulDeployment
         *        Information about the most recent successful deployment to the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment);

        /**
         * <p>
         * Information about the most recent attempted deployment to the deployment group.
         * </p>
         * 
         * @param lastAttemptedDeployment
         *        Information about the most recent attempted deployment to the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private String deploymentGroupId;

        private String deploymentGroupName;

        private String deploymentConfigName;

        private List<EC2TagFilter> ec2TagFilters = new SdkInternalList<>();

        private List<TagFilter> onPremisesInstanceTagFilters = new SdkInternalList<>();

        private List<AutoScalingGroup> autoScalingGroups = new SdkInternalList<>();

        private String serviceRoleArn;

        private RevisionLocation targetRevision;

        private List<TriggerConfig> triggerConfigurations = new SdkInternalList<>();

        private AlarmConfiguration alarmConfiguration;

        private AutoRollbackConfiguration autoRollbackConfiguration;

        private DeploymentStyle deploymentStyle;

        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

        private LoadBalancerInfo loadBalancerInfo;

        private LastDeploymentInfo lastSuccessfulDeployment;

        private LastDeploymentInfo lastAttemptedDeployment;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentGroupInfo model) {
            setApplicationName(model.applicationName);
            setDeploymentGroupId(model.deploymentGroupId);
            setDeploymentGroupName(model.deploymentGroupName);
            setDeploymentConfigName(model.deploymentConfigName);
            setEc2TagFilters(model.ec2TagFilters);
            setOnPremisesInstanceTagFilters(model.onPremisesInstanceTagFilters);
            setAutoScalingGroups(model.autoScalingGroups);
            setServiceRoleArn(model.serviceRoleArn);
            setTargetRevision(model.targetRevision);
            setTriggerConfigurations(model.triggerConfigurations);
            setAlarmConfiguration(model.alarmConfiguration);
            setAutoRollbackConfiguration(model.autoRollbackConfiguration);
            setDeploymentStyle(model.deploymentStyle);
            setBlueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            setLoadBalancerInfo(model.loadBalancerInfo);
            setLastSuccessfulDeployment(model.lastSuccessfulDeployment);
            setLastAttemptedDeployment(model.lastAttemptedDeployment);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupId() {
            return deploymentGroupId;
        }

        @Override
        public final Builder deploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
            return this;
        }

        public final void setDeploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
        }

        public final String getDeploymentGroupName() {
            return deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final Collection<EC2TagFilter> getEc2TagFilters() {
            return ec2TagFilters;
        }

        @Override
        public final Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(EC2TagFilter... ec2TagFilters) {
            if (this.ec2TagFilters == null) {
                this.ec2TagFilters = new SdkInternalList<>(ec2TagFilters.length);
            }
            for (EC2TagFilter e : ec2TagFilters) {
                this.ec2TagFilters.add(e);
            }
            return this;
        }

        public final void setEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
        }

        @SafeVarargs
        public final void setEc2TagFilters(EC2TagFilter... ec2TagFilters) {
            if (this.ec2TagFilters == null) {
                this.ec2TagFilters = new SdkInternalList<>(ec2TagFilters.length);
            }
            for (EC2TagFilter e : ec2TagFilters) {
                this.ec2TagFilters.add(e);
            }
        }

        public final Collection<TagFilter> getOnPremisesInstanceTagFilters() {
            return onPremisesInstanceTagFilters;
        }

        @Override
        public final Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters) {
            if (this.onPremisesInstanceTagFilters == null) {
                this.onPremisesInstanceTagFilters = new SdkInternalList<>(onPremisesInstanceTagFilters.length);
            }
            for (TagFilter e : onPremisesInstanceTagFilters) {
                this.onPremisesInstanceTagFilters.add(e);
            }
            return this;
        }

        public final void setOnPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
        }

        @SafeVarargs
        public final void setOnPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters) {
            if (this.onPremisesInstanceTagFilters == null) {
                this.onPremisesInstanceTagFilters = new SdkInternalList<>(onPremisesInstanceTagFilters.length);
            }
            for (TagFilter e : onPremisesInstanceTagFilters) {
                this.onPremisesInstanceTagFilters.add(e);
            }
        }

        public final Collection<AutoScalingGroup> getAutoScalingGroups() {
            return autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup... autoScalingGroups) {
            if (this.autoScalingGroups == null) {
                this.autoScalingGroups = new SdkInternalList<>(autoScalingGroups.length);
            }
            for (AutoScalingGroup e : autoScalingGroups) {
                this.autoScalingGroups.add(e);
            }
            return this;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
        }

        @SafeVarargs
        public final void setAutoScalingGroups(AutoScalingGroup... autoScalingGroups) {
            if (this.autoScalingGroups == null) {
                this.autoScalingGroups = new SdkInternalList<>(autoScalingGroups.length);
            }
            for (AutoScalingGroup e : autoScalingGroups) {
                this.autoScalingGroups.add(e);
            }
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final RevisionLocation getTargetRevision() {
            return targetRevision;
        }

        @Override
        public final Builder targetRevision(RevisionLocation targetRevision) {
            this.targetRevision = targetRevision;
            return this;
        }

        public final void setTargetRevision(RevisionLocation targetRevision) {
            this.targetRevision = targetRevision;
        }

        public final Collection<TriggerConfig> getTriggerConfigurations() {
            return triggerConfigurations;
        }

        @Override
        public final Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(TriggerConfig... triggerConfigurations) {
            if (this.triggerConfigurations == null) {
                this.triggerConfigurations = new SdkInternalList<>(triggerConfigurations.length);
            }
            for (TriggerConfig e : triggerConfigurations) {
                this.triggerConfigurations.add(e);
            }
            return this;
        }

        public final void setTriggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
        }

        @SafeVarargs
        public final void setTriggerConfigurations(TriggerConfig... triggerConfigurations) {
            if (this.triggerConfigurations == null) {
                this.triggerConfigurations = new SdkInternalList<>(triggerConfigurations.length);
            }
            for (TriggerConfig e : triggerConfigurations) {
                this.triggerConfigurations.add(e);
            }
        }

        public final AlarmConfiguration getAlarmConfiguration() {
            return alarmConfiguration;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final void setAlarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
        }

        public final AutoRollbackConfiguration getAutoRollbackConfiguration() {
            return autoRollbackConfiguration;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
        }

        public final DeploymentStyle getDeploymentStyle() {
            return deploymentStyle;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final void setDeploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
        }

        public final BlueGreenDeploymentConfiguration getBlueGreenDeploymentConfiguration() {
            return blueGreenDeploymentConfiguration;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
        }

        public final LoadBalancerInfo getLoadBalancerInfo() {
            return loadBalancerInfo;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
        }

        public final LastDeploymentInfo getLastSuccessfulDeployment() {
            return lastSuccessfulDeployment;
        }

        @Override
        public final Builder lastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment) {
            this.lastSuccessfulDeployment = lastSuccessfulDeployment;
            return this;
        }

        public final void setLastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment) {
            this.lastSuccessfulDeployment = lastSuccessfulDeployment;
        }

        public final LastDeploymentInfo getLastAttemptedDeployment() {
            return lastAttemptedDeployment;
        }

        @Override
        public final Builder lastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment) {
            this.lastAttemptedDeployment = lastAttemptedDeployment;
            return this;
        }

        public final void setLastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment) {
            this.lastAttemptedDeployment = lastAttemptedDeployment;
        }

        @Override
        public DeploymentGroupInfo build() {
            return new DeploymentGroupInfo(this);
        }
    }
}
