/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentConfigInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeploymentConfigInfo implements StructuredPojo,
        ToCopyableBuilder<DeploymentConfigInfo.Builder, DeploymentConfigInfo> {
    private final String deploymentConfigId;

    private final String deploymentConfigName;

    private final MinimumHealthyHosts minimumHealthyHosts;

    private final Date createTime;

    private DeploymentConfigInfo(BuilderImpl builder) {
        this.deploymentConfigId = builder.deploymentConfigId;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.minimumHealthyHosts = builder.minimumHealthyHosts;
        this.createTime = builder.createTime;
    }

    /**
     * <p>
     * The deployment configuration ID.
     * </p>
     * 
     * @return The deployment configuration ID.
     */
    public String deploymentConfigId() {
        return deploymentConfigId;
    }

    /**
     * <p>
     * The deployment configuration name.
     * </p>
     * 
     * @return The deployment configuration name.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * Information about the number or percentage of minimum healthy instance.
     * </p>
     * 
     * @return Information about the number or percentage of minimum healthy instance.
     */
    public MinimumHealthyHosts minimumHealthyHosts() {
        return minimumHealthyHosts;
    }

    /**
     * <p>
     * The time at which the deployment configuration was created.
     * </p>
     * 
     * @return The time at which the deployment configuration was created.
     */
    public Date createTime() {
        return createTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentConfigId() == null) ? 0 : deploymentConfigId().hashCode());
        hashCode = 31 * hashCode + ((deploymentConfigName() == null) ? 0 : deploymentConfigName().hashCode());
        hashCode = 31 * hashCode + ((minimumHealthyHosts() == null) ? 0 : minimumHealthyHosts().hashCode());
        hashCode = 31 * hashCode + ((createTime() == null) ? 0 : createTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfigInfo)) {
            return false;
        }
        DeploymentConfigInfo other = (DeploymentConfigInfo) obj;
        if (other.deploymentConfigId() == null ^ this.deploymentConfigId() == null) {
            return false;
        }
        if (other.deploymentConfigId() != null && !other.deploymentConfigId().equals(this.deploymentConfigId())) {
            return false;
        }
        if (other.deploymentConfigName() == null ^ this.deploymentConfigName() == null) {
            return false;
        }
        if (other.deploymentConfigName() != null && !other.deploymentConfigName().equals(this.deploymentConfigName())) {
            return false;
        }
        if (other.minimumHealthyHosts() == null ^ this.minimumHealthyHosts() == null) {
            return false;
        }
        if (other.minimumHealthyHosts() != null && !other.minimumHealthyHosts().equals(this.minimumHealthyHosts())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentConfigId() != null) {
            sb.append("DeploymentConfigId: ").append(deploymentConfigId()).append(",");
        }
        if (deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(deploymentConfigName()).append(",");
        }
        if (minimumHealthyHosts() != null) {
            sb.append("MinimumHealthyHosts: ").append(minimumHealthyHosts()).append(",");
        }
        if (createTime() != null) {
            sb.append("CreateTime: ").append(createTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentConfigInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeploymentConfigInfo> {
        /**
         * <p>
         * The deployment configuration ID.
         * </p>
         * 
         * @param deploymentConfigId
         *        The deployment configuration ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigId(String deploymentConfigId);

        /**
         * <p>
         * The deployment configuration name.
         * </p>
         * 
         * @param deploymentConfigName
         *        The deployment configuration name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * Information about the number or percentage of minimum healthy instance.
         * </p>
         * 
         * @param minimumHealthyHosts
         *        Information about the number or percentage of minimum healthy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts);

        /**
         * <p>
         * The time at which the deployment configuration was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the deployment configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Date createTime);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentConfigId;

        private String deploymentConfigName;

        private MinimumHealthyHosts minimumHealthyHosts;

        private Date createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfigInfo model) {
            setDeploymentConfigId(model.deploymentConfigId);
            setDeploymentConfigName(model.deploymentConfigName);
            setMinimumHealthyHosts(model.minimumHealthyHosts);
            setCreateTime(model.createTime);
        }

        public final String getDeploymentConfigId() {
            return deploymentConfigId;
        }

        @Override
        public final Builder deploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
            return this;
        }

        public final void setDeploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final MinimumHealthyHosts getMinimumHealthyHosts() {
            return minimumHealthyHosts;
        }

        @Override
        public final Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        public final void setMinimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
        }

        public final Date getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Date createTime) {
            this.createTime = StandardMemberCopier.copy(createTime);
            return this;
        }

        public final void setCreateTime(Date createTime) {
            this.createTime = StandardMemberCopier.copy(createTime);
        }

        @Override
        public DeploymentConfigInfo build() {
            return new DeploymentConfigInfo(this);
        }
    }
}
