/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a DeleteDeploymentGroup operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteDeploymentGroupResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteDeploymentGroupResponse.Builder, DeleteDeploymentGroupResponse> {
    private final List<AutoScalingGroup> hooksNotCleanedUp;

    private DeleteDeploymentGroupResponse(BuilderImpl builder) {
        this.hooksNotCleanedUp = builder.hooksNotCleanedUp;
    }

    /**
     * <p>
     * If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling group,
     * AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the Amazon EC2
     * instances in the Auto Scaling group. If the output contains data, AWS CodeDeploy could not remove some Auto
     * Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group.
     * </p>
     * 
     * @return If the output contains no data, and the corresponding deployment group contained at least one Auto
     *         Scaling group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks
     *         from the Amazon EC2 instances in the Auto Scaling group. If the output contains data, AWS CodeDeploy
     *         could not remove some Auto Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto
     *         Scaling group.
     */
    public List<AutoScalingGroup> hooksNotCleanedUp() {
        return hooksNotCleanedUp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hooksNotCleanedUp() == null) ? 0 : hooksNotCleanedUp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDeploymentGroupResponse)) {
            return false;
        }
        DeleteDeploymentGroupResponse other = (DeleteDeploymentGroupResponse) obj;
        if (other.hooksNotCleanedUp() == null ^ this.hooksNotCleanedUp() == null) {
            return false;
        }
        if (other.hooksNotCleanedUp() != null && !other.hooksNotCleanedUp().equals(this.hooksNotCleanedUp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hooksNotCleanedUp() != null) {
            sb.append("HooksNotCleanedUp: ").append(hooksNotCleanedUp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteDeploymentGroupResponse> {
        /**
         * <p>
         * If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling
         * group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the
         * Amazon EC2 instances in the Auto Scaling group. If the output contains data, AWS CodeDeploy could not remove
         * some Auto Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group.
         * </p>
         * 
         * @param hooksNotCleanedUp
         *        If the output contains no data, and the corresponding deployment group contained at least one Auto
         *        Scaling group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event
         *        hooks from the Amazon EC2 instances in the Auto Scaling group. If the output contains data, AWS
         *        CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the Amazon EC2 instances in
         *        the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hooksNotCleanedUp(Collection<AutoScalingGroup> hooksNotCleanedUp);

        /**
         * <p>
         * If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling
         * group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the
         * Amazon EC2 instances in the Auto Scaling group. If the output contains data, AWS CodeDeploy could not remove
         * some Auto Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setHooksNotCleanedUp(java.util.Collection)} or {@link #withHooksNotCleanedUp(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param hooksNotCleanedUp
         *        If the output contains no data, and the corresponding deployment group contained at least one Auto
         *        Scaling group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event
         *        hooks from the Amazon EC2 instances in the Auto Scaling group. If the output contains data, AWS
         *        CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the Amazon EC2 instances in
         *        the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hooksNotCleanedUp(AutoScalingGroup... hooksNotCleanedUp);
    }

    private static final class BuilderImpl implements Builder {
        private List<AutoScalingGroup> hooksNotCleanedUp = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDeploymentGroupResponse model) {
            setHooksNotCleanedUp(model.hooksNotCleanedUp);
        }

        public final Collection<AutoScalingGroup> getHooksNotCleanedUp() {
            return hooksNotCleanedUp;
        }

        @Override
        public final Builder hooksNotCleanedUp(Collection<AutoScalingGroup> hooksNotCleanedUp) {
            this.hooksNotCleanedUp = AutoScalingGroupListCopier.copy(hooksNotCleanedUp);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hooksNotCleanedUp(AutoScalingGroup... hooksNotCleanedUp) {
            if (this.hooksNotCleanedUp == null) {
                this.hooksNotCleanedUp = new SdkInternalList<>(hooksNotCleanedUp.length);
            }
            for (AutoScalingGroup e : hooksNotCleanedUp) {
                this.hooksNotCleanedUp.add(e);
            }
            return this;
        }

        public final void setHooksNotCleanedUp(Collection<AutoScalingGroup> hooksNotCleanedUp) {
            this.hooksNotCleanedUp = AutoScalingGroupListCopier.copy(hooksNotCleanedUp);
        }

        @SafeVarargs
        public final void setHooksNotCleanedUp(AutoScalingGroup... hooksNotCleanedUp) {
            if (this.hooksNotCleanedUp == null) {
                this.hooksNotCleanedUp = new SdkInternalList<>(hooksNotCleanedUp.length);
            }
            for (AutoScalingGroup e : hooksNotCleanedUp) {
                this.hooksNotCleanedUp.add(e);
            }
        }

        @Override
        public DeleteDeploymentGroupResponse build() {
            return new DeleteDeploymentGroupResponse(this);
        }
    }
}
