/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a DeleteDeploymentConfig operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteDeploymentConfigRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteDeploymentConfigRequest.Builder, DeleteDeploymentConfigRequest> {
    private final String deploymentConfigName;

    private DeleteDeploymentConfigRequest(BuilderImpl builder) {
        this.deploymentConfigName = builder.deploymentConfigName;
    }

    /**
     * <p>
     * The name of a deployment configuration associated with the applicable IAM user or AWS account.
     * </p>
     * 
     * @return The name of a deployment configuration associated with the applicable IAM user or AWS account.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentConfigName() == null) ? 0 : deploymentConfigName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDeploymentConfigRequest)) {
            return false;
        }
        DeleteDeploymentConfigRequest other = (DeleteDeploymentConfigRequest) obj;
        if (other.deploymentConfigName() == null ^ this.deploymentConfigName() == null) {
            return false;
        }
        if (other.deploymentConfigName() != null && !other.deploymentConfigName().equals(this.deploymentConfigName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(deploymentConfigName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteDeploymentConfigRequest> {
        /**
         * <p>
         * The name of a deployment configuration associated with the applicable IAM user or AWS account.
         * </p>
         * 
         * @param deploymentConfigName
         *        The name of a deployment configuration associated with the applicable IAM user or AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentConfigName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDeploymentConfigRequest model) {
            setDeploymentConfigName(model.deploymentConfigName);
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public DeleteDeploymentConfigRequest build() {
            return new DeleteDeploymentConfigRequest(this);
        }
    }
}
