/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a CreateDeployment operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDeploymentRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateDeploymentRequest.Builder, CreateDeploymentRequest> {
    private final String applicationName;

    private final String deploymentGroupName;

    private final RevisionLocation revision;

    private final String deploymentConfigName;

    private final String description;

    private final Boolean ignoreApplicationStopFailures;

    private final TargetInstances targetInstances;

    private final AutoRollbackConfiguration autoRollbackConfiguration;

    private final Boolean updateOutdatedInstancesOnly;

    private final String fileExistsBehavior;

    private CreateDeploymentRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.revision = builder.revision;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.description = builder.description;
        this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
        this.targetInstances = builder.targetInstances;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.updateOutdatedInstancesOnly = builder.updateOutdatedInstancesOnly;
        this.fileExistsBehavior = builder.fileExistsBehavior;
    }

    /**
     * <p>
     * The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
     * </p>
     * 
     * @return The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The name of the deployment group.
     * </p>
     * 
     * @return The name of the deployment group.
     */
    public String deploymentGroupName() {
        return deploymentGroupName;
    }

    /**
     * <p>
     * The type and location of the revision to deploy.
     * </p>
     * 
     * @return The type and location of the revision to deploy.
     */
    public RevisionLocation revision() {
        return revision;
    }

    /**
     * <p>
     * The name of a deployment configuration associated with the applicable IAM user or AWS account.
     * </p>
     * <p>
     * If not specified, the value configured in the deployment group will be used as the default. If the deployment
     * group does not have a deployment configuration associated with it, then CodeDeployDefault.OneAtATime will be used
     * by default.
     * </p>
     * 
     * @return The name of a deployment configuration associated with the applicable IAM user or AWS account.</p>
     *         <p>
     *         If not specified, the value configured in the deployment group will be used as the default. If the
     *         deployment group does not have a deployment configuration associated with it, then
     *         CodeDeployDefault.OneAtATime will be used by default.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * A comment about the deployment.
     * </p>
     * 
     * @return A comment about the deployment.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * If set to true, then if the deployment causes the ApplicationStop deployment lifecycle event to an instance to
     * fail, the deployment to that instance will not be considered to have failed at that point and will continue on to
     * the BeforeInstall deployment lifecycle event.
     * </p>
     * <p>
     * If set to false or not specified, then if the deployment causes the ApplicationStop deployment lifecycle event to
     * fail to an instance, the deployment to that instance will stop, and the deployment to that instance will be
     * considered to have failed.
     * </p>
     * 
     * @return If set to true, then if the deployment causes the ApplicationStop deployment lifecycle event to an
     *         instance to fail, the deployment to that instance will not be considered to have failed at that point and
     *         will continue on to the BeforeInstall deployment lifecycle event.</p>
     *         <p>
     *         If set to false or not specified, then if the deployment causes the ApplicationStop deployment lifecycle
     *         event to fail to an instance, the deployment to that instance will stop, and the deployment to that
     *         instance will be considered to have failed.
     */
    public Boolean ignoreApplicationStopFailures() {
        return ignoreApplicationStopFailures;
    }

    /**
     * <p>
     * Information about the instances that will belong to the replacement environment in a blue/green deployment.
     * </p>
     * 
     * @return Information about the instances that will belong to the replacement environment in a blue/green
     *         deployment.
     */
    public TargetInstances targetInstances() {
        return targetInstances;
    }

    /**
     * <p>
     * Configuration information for an automatic rollback that is added when a deployment is created.
     * </p>
     * 
     * @return Configuration information for an automatic rollback that is added when a deployment is created.
     */
    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    /**
     * <p>
     * Indicates whether to deploy to all instances or only to instances that are not running the latest application
     * revision.
     * </p>
     * 
     * @return Indicates whether to deploy to all instances or only to instances that are not running the latest
     *         application revision.
     */
    public Boolean updateOutdatedInstancesOnly() {
        return updateOutdatedInstancesOnly;
    }

    /**
     * <p>
     * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't
     * part of the previous successful deployment.
     * </p>
     * <p>
     * The fileExistsBehavior parameter takes any of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * OVERWRITE: The version of the file from the application revision currently being deployed replaces the version
     * already on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
     *         weren't part of the previous successful deployment.</p>
     *         <p>
     *         The fileExistsBehavior parameter takes any of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OVERWRITE: The version of the file from the application revision currently being deployed replaces the
     *         version already on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     *         </p>
     *         </li>
     * @see FileExistsBehavior
     */
    public String fileExistsBehavior() {
        return fileExistsBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((deploymentGroupName() == null) ? 0 : deploymentGroupName().hashCode());
        hashCode = 31 * hashCode + ((revision() == null) ? 0 : revision().hashCode());
        hashCode = 31 * hashCode + ((deploymentConfigName() == null) ? 0 : deploymentConfigName().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((ignoreApplicationStopFailures() == null) ? 0 : ignoreApplicationStopFailures().hashCode());
        hashCode = 31 * hashCode + ((targetInstances() == null) ? 0 : targetInstances().hashCode());
        hashCode = 31 * hashCode + ((autoRollbackConfiguration() == null) ? 0 : autoRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + ((updateOutdatedInstancesOnly() == null) ? 0 : updateOutdatedInstancesOnly().hashCode());
        hashCode = 31 * hashCode + ((fileExistsBehavior() == null) ? 0 : fileExistsBehavior().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroupName() == null ^ this.deploymentGroupName() == null) {
            return false;
        }
        if (other.deploymentGroupName() != null && !other.deploymentGroupName().equals(this.deploymentGroupName())) {
            return false;
        }
        if (other.revision() == null ^ this.revision() == null) {
            return false;
        }
        if (other.revision() != null && !other.revision().equals(this.revision())) {
            return false;
        }
        if (other.deploymentConfigName() == null ^ this.deploymentConfigName() == null) {
            return false;
        }
        if (other.deploymentConfigName() != null && !other.deploymentConfigName().equals(this.deploymentConfigName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.ignoreApplicationStopFailures() == null ^ this.ignoreApplicationStopFailures() == null) {
            return false;
        }
        if (other.ignoreApplicationStopFailures() != null
                && !other.ignoreApplicationStopFailures().equals(this.ignoreApplicationStopFailures())) {
            return false;
        }
        if (other.targetInstances() == null ^ this.targetInstances() == null) {
            return false;
        }
        if (other.targetInstances() != null && !other.targetInstances().equals(this.targetInstances())) {
            return false;
        }
        if (other.autoRollbackConfiguration() == null ^ this.autoRollbackConfiguration() == null) {
            return false;
        }
        if (other.autoRollbackConfiguration() != null
                && !other.autoRollbackConfiguration().equals(this.autoRollbackConfiguration())) {
            return false;
        }
        if (other.updateOutdatedInstancesOnly() == null ^ this.updateOutdatedInstancesOnly() == null) {
            return false;
        }
        if (other.updateOutdatedInstancesOnly() != null
                && !other.updateOutdatedInstancesOnly().equals(this.updateOutdatedInstancesOnly())) {
            return false;
        }
        if (other.fileExistsBehavior() == null ^ this.fileExistsBehavior() == null) {
            return false;
        }
        if (other.fileExistsBehavior() != null && !other.fileExistsBehavior().equals(this.fileExistsBehavior())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (deploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(deploymentGroupName()).append(",");
        }
        if (revision() != null) {
            sb.append("Revision: ").append(revision()).append(",");
        }
        if (deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(deploymentConfigName()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (ignoreApplicationStopFailures() != null) {
            sb.append("IgnoreApplicationStopFailures: ").append(ignoreApplicationStopFailures()).append(",");
        }
        if (targetInstances() != null) {
            sb.append("TargetInstances: ").append(targetInstances()).append(",");
        }
        if (autoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(autoRollbackConfiguration()).append(",");
        }
        if (updateOutdatedInstancesOnly() != null) {
            sb.append("UpdateOutdatedInstancesOnly: ").append(updateOutdatedInstancesOnly()).append(",");
        }
        if (fileExistsBehavior() != null) {
            sb.append("FileExistsBehavior: ").append(fileExistsBehavior()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDeploymentRequest> {
        /**
         * <p>
         * The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
         * </p>
         * 
         * @param applicationName
         *        The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The name of the deployment group.
         * </p>
         * 
         * @param deploymentGroupName
         *        The name of the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupName(String deploymentGroupName);

        /**
         * <p>
         * The type and location of the revision to deploy.
         * </p>
         * 
         * @param revision
         *        The type and location of the revision to deploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(RevisionLocation revision);

        /**
         * <p>
         * The name of a deployment configuration associated with the applicable IAM user or AWS account.
         * </p>
         * <p>
         * If not specified, the value configured in the deployment group will be used as the default. If the deployment
         * group does not have a deployment configuration associated with it, then CodeDeployDefault.OneAtATime will be
         * used by default.
         * </p>
         * 
         * @param deploymentConfigName
         *        The name of a deployment configuration associated with the applicable IAM user or AWS account.</p>
         *        <p>
         *        If not specified, the value configured in the deployment group will be used as the default. If the
         *        deployment group does not have a deployment configuration associated with it, then
         *        CodeDeployDefault.OneAtATime will be used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * A comment about the deployment.
         * </p>
         * 
         * @param description
         *        A comment about the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If set to true, then if the deployment causes the ApplicationStop deployment lifecycle event to an instance
         * to fail, the deployment to that instance will not be considered to have failed at that point and will
         * continue on to the BeforeInstall deployment lifecycle event.
         * </p>
         * <p>
         * If set to false or not specified, then if the deployment causes the ApplicationStop deployment lifecycle
         * event to fail to an instance, the deployment to that instance will stop, and the deployment to that instance
         * will be considered to have failed.
         * </p>
         * 
         * @param ignoreApplicationStopFailures
         *        If set to true, then if the deployment causes the ApplicationStop deployment lifecycle event to an
         *        instance to fail, the deployment to that instance will not be considered to have failed at that point
         *        and will continue on to the BeforeInstall deployment lifecycle event.</p>
         *        <p>
         *        If set to false or not specified, then if the deployment causes the ApplicationStop deployment
         *        lifecycle event to fail to an instance, the deployment to that instance will stop, and the deployment
         *        to that instance will be considered to have failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures);

        /**
         * <p>
         * Information about the instances that will belong to the replacement environment in a blue/green deployment.
         * </p>
         * 
         * @param targetInstances
         *        Information about the instances that will belong to the replacement environment in a blue/green
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetInstances(TargetInstances targetInstances);

        /**
         * <p>
         * Configuration information for an automatic rollback that is added when a deployment is created.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Configuration information for an automatic rollback that is added when a deployment is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration);

        /**
         * <p>
         * Indicates whether to deploy to all instances or only to instances that are not running the latest application
         * revision.
         * </p>
         * 
         * @param updateOutdatedInstancesOnly
         *        Indicates whether to deploy to all instances or only to instances that are not running the latest
         *        application revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly);

        /**
         * <p>
         * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
         * weren't part of the previous successful deployment.
         * </p>
         * <p>
         * The fileExistsBehavior parameter takes any of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         * version already on the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileExistsBehavior
         *        Information about how AWS CodeDeploy handles files that already exist in a deployment target location
         *        but weren't part of the previous successful deployment.</p>
         *        <p>
         *        The fileExistsBehavior parameter takes any of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         *        version already on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RETAIN: The version of the file already on the instance is kept and used as part of the new
         *        deployment.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileExistsBehavior
         */
        Builder fileExistsBehavior(String fileExistsBehavior);

        /**
         * <p>
         * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
         * weren't part of the previous successful deployment.
         * </p>
         * <p>
         * The fileExistsBehavior parameter takes any of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         * version already on the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileExistsBehavior
         *        Information about how AWS CodeDeploy handles files that already exist in a deployment target location
         *        but weren't part of the previous successful deployment.</p>
         *        <p>
         *        The fileExistsBehavior parameter takes any of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         *        version already on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RETAIN: The version of the file already on the instance is kept and used as part of the new
         *        deployment.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileExistsBehavior
         */
        Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private String deploymentGroupName;

        private RevisionLocation revision;

        private String deploymentConfigName;

        private String description;

        private Boolean ignoreApplicationStopFailures;

        private TargetInstances targetInstances;

        private AutoRollbackConfiguration autoRollbackConfiguration;

        private Boolean updateOutdatedInstancesOnly;

        private String fileExistsBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            setApplicationName(model.applicationName);
            setDeploymentGroupName(model.deploymentGroupName);
            setRevision(model.revision);
            setDeploymentConfigName(model.deploymentConfigName);
            setDescription(model.description);
            setIgnoreApplicationStopFailures(model.ignoreApplicationStopFailures);
            setTargetInstances(model.targetInstances);
            setAutoRollbackConfiguration(model.autoRollbackConfiguration);
            setUpdateOutdatedInstancesOnly(model.updateOutdatedInstancesOnly);
            setFileExistsBehavior(model.fileExistsBehavior);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final RevisionLocation getRevision() {
            return revision;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation revision) {
            this.revision = revision;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getIgnoreApplicationStopFailures() {
            return ignoreApplicationStopFailures;
        }

        @Override
        public final Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            return this;
        }

        public final void setIgnoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
        }

        public final TargetInstances getTargetInstances() {
            return targetInstances;
        }

        @Override
        public final Builder targetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
            return this;
        }

        public final void setTargetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
        }

        public final AutoRollbackConfiguration getAutoRollbackConfiguration() {
            return autoRollbackConfiguration;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
        }

        public final Boolean getUpdateOutdatedInstancesOnly() {
            return updateOutdatedInstancesOnly;
        }

        @Override
        public final Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
            return this;
        }

        public final void setUpdateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
        }

        public final String getFileExistsBehavior() {
            return fileExistsBehavior;
        }

        @Override
        public final Builder fileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
            return this;
        }

        @Override
        public final Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior.toString());
            return this;
        }

        public final void setFileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
        }

        public final void setFileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior.toString());
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }
    }
}
