/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a CreateDeploymentGroup operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDeploymentGroupResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateDeploymentGroupResponse.Builder, CreateDeploymentGroupResponse> {
    private final String deploymentGroupId;

    private CreateDeploymentGroupResponse(BuilderImpl builder) {
        this.deploymentGroupId = builder.deploymentGroupId;
    }

    /**
     * <p>
     * A unique deployment group ID.
     * </p>
     * 
     * @return A unique deployment group ID.
     */
    public String deploymentGroupId() {
        return deploymentGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentGroupId() == null) ? 0 : deploymentGroupId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentGroupResponse)) {
            return false;
        }
        CreateDeploymentGroupResponse other = (CreateDeploymentGroupResponse) obj;
        if (other.deploymentGroupId() == null ^ this.deploymentGroupId() == null) {
            return false;
        }
        if (other.deploymentGroupId() != null && !other.deploymentGroupId().equals(this.deploymentGroupId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentGroupId() != null) {
            sb.append("DeploymentGroupId: ").append(deploymentGroupId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDeploymentGroupResponse> {
        /**
         * <p>
         * A unique deployment group ID.
         * </p>
         * 
         * @param deploymentGroupId
         *        A unique deployment group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupId(String deploymentGroupId);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentGroupResponse model) {
            setDeploymentGroupId(model.deploymentGroupId);
        }

        public final String getDeploymentGroupId() {
            return deploymentGroupId;
        }

        @Override
        public final Builder deploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
            return this;
        }

        public final void setDeploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
        }

        @Override
        public CreateDeploymentGroupResponse build() {
            return new CreateDeploymentGroupResponse(this);
        }
    }
}
