/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a CreateDeploymentConfig operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDeploymentConfigResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateDeploymentConfigResponse.Builder, CreateDeploymentConfigResponse> {
    private final String deploymentConfigId;

    private CreateDeploymentConfigResponse(BuilderImpl builder) {
        this.deploymentConfigId = builder.deploymentConfigId;
    }

    /**
     * <p>
     * A unique deployment configuration ID.
     * </p>
     * 
     * @return A unique deployment configuration ID.
     */
    public String deploymentConfigId() {
        return deploymentConfigId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentConfigId() == null) ? 0 : deploymentConfigId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentConfigResponse)) {
            return false;
        }
        CreateDeploymentConfigResponse other = (CreateDeploymentConfigResponse) obj;
        if (other.deploymentConfigId() == null ^ this.deploymentConfigId() == null) {
            return false;
        }
        if (other.deploymentConfigId() != null && !other.deploymentConfigId().equals(this.deploymentConfigId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentConfigId() != null) {
            sb.append("DeploymentConfigId: ").append(deploymentConfigId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDeploymentConfigResponse> {
        /**
         * <p>
         * A unique deployment configuration ID.
         * </p>
         * 
         * @param deploymentConfigId
         *        A unique deployment configuration ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigId(String deploymentConfigId);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentConfigId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentConfigResponse model) {
            setDeploymentConfigId(model.deploymentConfigId);
        }

        public final String getDeploymentConfigId() {
            return deploymentConfigId;
        }

        @Override
        public final Builder deploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
            return this;
        }

        public final void setDeploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
        }

        @Override
        public CreateDeploymentConfigResponse build() {
            return new CreateDeploymentConfigResponse(this);
        }
    }
}
