/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a CreateDeploymentConfig operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDeploymentConfigRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateDeploymentConfigRequest.Builder, CreateDeploymentConfigRequest> {
    private final String deploymentConfigName;

    private final MinimumHealthyHosts minimumHealthyHosts;

    private CreateDeploymentConfigRequest(BuilderImpl builder) {
        this.deploymentConfigName = builder.deploymentConfigName;
        this.minimumHealthyHosts = builder.minimumHealthyHosts;
    }

    /**
     * <p>
     * The name of the deployment configuration to create.
     * </p>
     * 
     * @return The name of the deployment configuration to create.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * The minimum number of healthy instances that should be available at any time during the deployment. There are two
     * parameters expected in the input: type and value.
     * </p>
     * <p>
     * The type parameter takes either of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
     * </p>
     * </li>
     * <li>
     * <p>
     * FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the
     * total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS
     * CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The value parameter takes an integer.
     * </p>
     * <p>
     * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
     * </p>
     * 
     * @return The minimum number of healthy instances that should be available at any time during the deployment. There
     *         are two parameters expected in the input: type and value.</p>
     *         <p>
     *         The type parameter takes either of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of
     *         the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the
     *         deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up
     *         fractional instances.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The value parameter takes an integer.
     *         </p>
     *         <p>
     *         For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
     */
    public MinimumHealthyHosts minimumHealthyHosts() {
        return minimumHealthyHosts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentConfigName() == null) ? 0 : deploymentConfigName().hashCode());
        hashCode = 31 * hashCode + ((minimumHealthyHosts() == null) ? 0 : minimumHealthyHosts().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentConfigRequest)) {
            return false;
        }
        CreateDeploymentConfigRequest other = (CreateDeploymentConfigRequest) obj;
        if (other.deploymentConfigName() == null ^ this.deploymentConfigName() == null) {
            return false;
        }
        if (other.deploymentConfigName() != null && !other.deploymentConfigName().equals(this.deploymentConfigName())) {
            return false;
        }
        if (other.minimumHealthyHosts() == null ^ this.minimumHealthyHosts() == null) {
            return false;
        }
        if (other.minimumHealthyHosts() != null && !other.minimumHealthyHosts().equals(this.minimumHealthyHosts())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(deploymentConfigName()).append(",");
        }
        if (minimumHealthyHosts() != null) {
            sb.append("MinimumHealthyHosts: ").append(minimumHealthyHosts()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDeploymentConfigRequest> {
        /**
         * <p>
         * The name of the deployment configuration to create.
         * </p>
         * 
         * @param deploymentConfigName
         *        The name of the deployment configuration to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * The minimum number of healthy instances that should be available at any time during the deployment. There are
         * two parameters expected in the input: type and value.
         * </p>
         * <p>
         * The type parameter takes either of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the
         * total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment,
         * AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional
         * instances.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The value parameter takes an integer.
         * </p>
         * <p>
         * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
         * </p>
         * 
         * @param minimumHealthyHosts
         *        The minimum number of healthy instances that should be available at any time during the deployment.
         *        There are two parameters expected in the input: type and value.</p>
         *        <p>
         *        The type parameter takes either of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute
         *        value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage
         *        of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the
         *        deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up
         *        fractional instances.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The value parameter takes an integer.
         *        </p>
         *        <p>
         *        For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of
         *        95.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentConfigName;

        private MinimumHealthyHosts minimumHealthyHosts;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentConfigRequest model) {
            setDeploymentConfigName(model.deploymentConfigName);
            setMinimumHealthyHosts(model.minimumHealthyHosts);
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final MinimumHealthyHosts getMinimumHealthyHosts() {
            return minimumHealthyHosts;
        }

        @Override
        public final Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        public final void setMinimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
        }

        @Override
        public CreateDeploymentConfigRequest build() {
            return new CreateDeploymentConfigRequest(this);
        }
    }
}
