/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.BlueInstanceTerminationOptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about whether instances in the original environment are terminated when a blue/green deployment is
 * successful.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BlueInstanceTerminationOption implements StructuredPojo,
        ToCopyableBuilder<BlueInstanceTerminationOption.Builder, BlueInstanceTerminationOption> {
    private final String action;

    private final Integer terminationWaitTimeInMinutes;

    private BlueInstanceTerminationOption(BuilderImpl builder) {
        this.action = builder.action;
        this.terminationWaitTimeInMinutes = builder.terminationWaitTimeInMinutes;
    }

    /**
     * <p>
     * The action to take on instances in the original environment after a successful blue/green deployment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * TERMINATE: Instances are terminated after a specified wait time.
     * </p>
     * </li>
     * <li>
     * <p>
     * KEEP_ALIVE: Instances are left running after they are deregistered from the load balancer and removed from the
     * deployment group.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The action to take on instances in the original environment after a successful blue/green deployment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         TERMINATE: Instances are terminated after a specified wait time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KEEP_ALIVE: Instances are left running after they are deregistered from the load balancer and removed
     *         from the deployment group.
     *         </p>
     *         </li>
     * @see InstanceAction
     */
    public String action() {
        return action;
    }

    /**
     * <p>
     * The number of minutes to wait after a successful blue/green deployment before terminating instances from the
     * original environment.
     * </p>
     * 
     * @return The number of minutes to wait after a successful blue/green deployment before terminating instances from
     *         the original environment.
     */
    public Integer terminationWaitTimeInMinutes() {
        return terminationWaitTimeInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((action() == null) ? 0 : action().hashCode());
        hashCode = 31 * hashCode + ((terminationWaitTimeInMinutes() == null) ? 0 : terminationWaitTimeInMinutes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueInstanceTerminationOption)) {
            return false;
        }
        BlueInstanceTerminationOption other = (BlueInstanceTerminationOption) obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.terminationWaitTimeInMinutes() == null ^ this.terminationWaitTimeInMinutes() == null) {
            return false;
        }
        if (other.terminationWaitTimeInMinutes() != null
                && !other.terminationWaitTimeInMinutes().equals(this.terminationWaitTimeInMinutes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (action() != null) {
            sb.append("Action: ").append(action()).append(",");
        }
        if (terminationWaitTimeInMinutes() != null) {
            sb.append("TerminationWaitTimeInMinutes: ").append(terminationWaitTimeInMinutes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlueInstanceTerminationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BlueInstanceTerminationOption> {
        /**
         * <p>
         * The action to take on instances in the original environment after a successful blue/green deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * TERMINATE: Instances are terminated after a specified wait time.
         * </p>
         * </li>
         * <li>
         * <p>
         * KEEP_ALIVE: Instances are left running after they are deregistered from the load balancer and removed from
         * the deployment group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to take on instances in the original environment after a successful blue/green
         *        deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TERMINATE: Instances are terminated after a specified wait time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KEEP_ALIVE: Instances are left running after they are deregistered from the load balancer and removed
         *        from the deployment group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to take on instances in the original environment after a successful blue/green deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * TERMINATE: Instances are terminated after a specified wait time.
         * </p>
         * </li>
         * <li>
         * <p>
         * KEEP_ALIVE: Instances are left running after they are deregistered from the load balancer and removed from
         * the deployment group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to take on instances in the original environment after a successful blue/green
         *        deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TERMINATE: Instances are terminated after a specified wait time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KEEP_ALIVE: Instances are left running after they are deregistered from the load balancer and removed
         *        from the deployment group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAction
         */
        Builder action(InstanceAction action);

        /**
         * <p>
         * The number of minutes to wait after a successful blue/green deployment before terminating instances from the
         * original environment.
         * </p>
         * 
         * @param terminationWaitTimeInMinutes
         *        The number of minutes to wait after a successful blue/green deployment before terminating instances
         *        from the original environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationWaitTimeInMinutes(Integer terminationWaitTimeInMinutes);
    }

    private static final class BuilderImpl implements Builder {
        private String action;

        private Integer terminationWaitTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueInstanceTerminationOption model) {
            setAction(model.action);
            setTerminationWaitTimeInMinutes(model.terminationWaitTimeInMinutes);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(InstanceAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final void setAction(InstanceAction action) {
            this.action(action.toString());
        }

        public final Integer getTerminationWaitTimeInMinutes() {
            return terminationWaitTimeInMinutes;
        }

        @Override
        public final Builder terminationWaitTimeInMinutes(Integer terminationWaitTimeInMinutes) {
            this.terminationWaitTimeInMinutes = terminationWaitTimeInMinutes;
            return this;
        }

        public final void setTerminationWaitTimeInMinutes(Integer terminationWaitTimeInMinutes) {
            this.terminationWaitTimeInMinutes = terminationWaitTimeInMinutes;
        }

        @Override
        public BlueInstanceTerminationOption build() {
            return new BlueInstanceTerminationOption(this);
        }
    }
}
