/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.BlueGreenDeploymentConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about blue/green deployment options for a deployment group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BlueGreenDeploymentConfiguration implements StructuredPojo,
        ToCopyableBuilder<BlueGreenDeploymentConfiguration.Builder, BlueGreenDeploymentConfiguration> {
    private final BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess;

    private final DeploymentReadyOption deploymentReadyOption;

    private final GreenFleetProvisioningOption greenFleetProvisioningOption;

    private BlueGreenDeploymentConfiguration(BuilderImpl builder) {
        this.terminateBlueInstancesOnDeploymentSuccess = builder.terminateBlueInstancesOnDeploymentSuccess;
        this.deploymentReadyOption = builder.deploymentReadyOption;
        this.greenFleetProvisioningOption = builder.greenFleetProvisioningOption;
    }

    /**
     * <p>
     * Information about whether to terminate instances in the original fleet during a blue/green deployment.
     * </p>
     * 
     * @return Information about whether to terminate instances in the original fleet during a blue/green deployment.
     */
    public BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess() {
        return terminateBlueInstancesOnDeploymentSuccess;
    }

    /**
     * <p>
     * Information about the action to take when newly provisioned instances are ready to receive traffic in a
     * blue/green deployment.
     * </p>
     * 
     * @return Information about the action to take when newly provisioned instances are ready to receive traffic in a
     *         blue/green deployment.
     */
    public DeploymentReadyOption deploymentReadyOption() {
        return deploymentReadyOption;
    }

    /**
     * <p>
     * Information about how instances are provisioned for a replacement environment in a blue/green deployment.
     * </p>
     * 
     * @return Information about how instances are provisioned for a replacement environment in a blue/green deployment.
     */
    public GreenFleetProvisioningOption greenFleetProvisioningOption() {
        return greenFleetProvisioningOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31
                * hashCode
                + ((terminateBlueInstancesOnDeploymentSuccess() == null) ? 0 : terminateBlueInstancesOnDeploymentSuccess()
                        .hashCode());
        hashCode = 31 * hashCode + ((deploymentReadyOption() == null) ? 0 : deploymentReadyOption().hashCode());
        hashCode = 31 * hashCode + ((greenFleetProvisioningOption() == null) ? 0 : greenFleetProvisioningOption().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueGreenDeploymentConfiguration)) {
            return false;
        }
        BlueGreenDeploymentConfiguration other = (BlueGreenDeploymentConfiguration) obj;
        if (other.terminateBlueInstancesOnDeploymentSuccess() == null ^ this.terminateBlueInstancesOnDeploymentSuccess() == null) {
            return false;
        }
        if (other.terminateBlueInstancesOnDeploymentSuccess() != null
                && !other.terminateBlueInstancesOnDeploymentSuccess().equals(this.terminateBlueInstancesOnDeploymentSuccess())) {
            return false;
        }
        if (other.deploymentReadyOption() == null ^ this.deploymentReadyOption() == null) {
            return false;
        }
        if (other.deploymentReadyOption() != null && !other.deploymentReadyOption().equals(this.deploymentReadyOption())) {
            return false;
        }
        if (other.greenFleetProvisioningOption() == null ^ this.greenFleetProvisioningOption() == null) {
            return false;
        }
        if (other.greenFleetProvisioningOption() != null
                && !other.greenFleetProvisioningOption().equals(this.greenFleetProvisioningOption())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (terminateBlueInstancesOnDeploymentSuccess() != null) {
            sb.append("TerminateBlueInstancesOnDeploymentSuccess: ").append(terminateBlueInstancesOnDeploymentSuccess())
                    .append(",");
        }
        if (deploymentReadyOption() != null) {
            sb.append("DeploymentReadyOption: ").append(deploymentReadyOption()).append(",");
        }
        if (greenFleetProvisioningOption() != null) {
            sb.append("GreenFleetProvisioningOption: ").append(greenFleetProvisioningOption()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlueGreenDeploymentConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BlueGreenDeploymentConfiguration> {
        /**
         * <p>
         * Information about whether to terminate instances in the original fleet during a blue/green deployment.
         * </p>
         * 
         * @param terminateBlueInstancesOnDeploymentSuccess
         *        Information about whether to terminate instances in the original fleet during a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess);

        /**
         * <p>
         * Information about the action to take when newly provisioned instances are ready to receive traffic in a
         * blue/green deployment.
         * </p>
         * 
         * @param deploymentReadyOption
         *        Information about the action to take when newly provisioned instances are ready to receive traffic in
         *        a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentReadyOption(DeploymentReadyOption deploymentReadyOption);

        /**
         * <p>
         * Information about how instances are provisioned for a replacement environment in a blue/green deployment.
         * </p>
         * 
         * @param greenFleetProvisioningOption
         *        Information about how instances are provisioned for a replacement environment in a blue/green
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greenFleetProvisioningOption(GreenFleetProvisioningOption greenFleetProvisioningOption);
    }

    private static final class BuilderImpl implements Builder {
        private BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess;

        private DeploymentReadyOption deploymentReadyOption;

        private GreenFleetProvisioningOption greenFleetProvisioningOption;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueGreenDeploymentConfiguration model) {
            setTerminateBlueInstancesOnDeploymentSuccess(model.terminateBlueInstancesOnDeploymentSuccess);
            setDeploymentReadyOption(model.deploymentReadyOption);
            setGreenFleetProvisioningOption(model.greenFleetProvisioningOption);
        }

        public final BlueInstanceTerminationOption getTerminateBlueInstancesOnDeploymentSuccess() {
            return terminateBlueInstancesOnDeploymentSuccess;
        }

        @Override
        public final Builder terminateBlueInstancesOnDeploymentSuccess(
                BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess) {
            this.terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess;
            return this;
        }

        public final void setTerminateBlueInstancesOnDeploymentSuccess(
                BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess) {
            this.terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess;
        }

        public final DeploymentReadyOption getDeploymentReadyOption() {
            return deploymentReadyOption;
        }

        @Override
        public final Builder deploymentReadyOption(DeploymentReadyOption deploymentReadyOption) {
            this.deploymentReadyOption = deploymentReadyOption;
            return this;
        }

        public final void setDeploymentReadyOption(DeploymentReadyOption deploymentReadyOption) {
            this.deploymentReadyOption = deploymentReadyOption;
        }

        public final GreenFleetProvisioningOption getGreenFleetProvisioningOption() {
            return greenFleetProvisioningOption;
        }

        @Override
        public final Builder greenFleetProvisioningOption(GreenFleetProvisioningOption greenFleetProvisioningOption) {
            this.greenFleetProvisioningOption = greenFleetProvisioningOption;
            return this;
        }

        public final void setGreenFleetProvisioningOption(GreenFleetProvisioningOption greenFleetProvisioningOption) {
            this.greenFleetProvisioningOption = greenFleetProvisioningOption;
        }

        @Override
        public BlueGreenDeploymentConfiguration build() {
            return new BlueGreenDeploymentConfiguration(this);
        }
    }
}
