/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a BatchGetOnPremisesInstances operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetOnPremisesInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<BatchGetOnPremisesInstancesResponse.Builder, BatchGetOnPremisesInstancesResponse> {
    private final List<InstanceInfo> instanceInfos;

    private BatchGetOnPremisesInstancesResponse(BuilderImpl builder) {
        this.instanceInfos = builder.instanceInfos;
    }

    /**
     * <p>
     * Information about the on-premises instances.
     * </p>
     * 
     * @return Information about the on-premises instances.
     */
    public List<InstanceInfo> instanceInfos() {
        return instanceInfos;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceInfos() == null) ? 0 : instanceInfos().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetOnPremisesInstancesResponse)) {
            return false;
        }
        BatchGetOnPremisesInstancesResponse other = (BatchGetOnPremisesInstancesResponse) obj;
        if (other.instanceInfos() == null ^ this.instanceInfos() == null) {
            return false;
        }
        if (other.instanceInfos() != null && !other.instanceInfos().equals(this.instanceInfos())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceInfos() != null) {
            sb.append("InstanceInfos: ").append(instanceInfos()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetOnPremisesInstancesResponse> {
        /**
         * <p>
         * Information about the on-premises instances.
         * </p>
         * 
         * @param instanceInfos
         *        Information about the on-premises instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInfos(Collection<InstanceInfo> instanceInfos);

        /**
         * <p>
         * Information about the on-premises instances.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceInfos(java.util.Collection)} or {@link #withInstanceInfos(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param instanceInfos
         *        Information about the on-premises instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInfos(InstanceInfo... instanceInfos);
    }

    private static final class BuilderImpl implements Builder {
        private List<InstanceInfo> instanceInfos = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetOnPremisesInstancesResponse model) {
            setInstanceInfos(model.instanceInfos);
        }

        public final Collection<InstanceInfo> getInstanceInfos() {
            return instanceInfos;
        }

        @Override
        public final Builder instanceInfos(Collection<InstanceInfo> instanceInfos) {
            this.instanceInfos = InstanceInfoListCopier.copy(instanceInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInfos(InstanceInfo... instanceInfos) {
            if (this.instanceInfos == null) {
                this.instanceInfos = new SdkInternalList<>(instanceInfos.length);
            }
            for (InstanceInfo e : instanceInfos) {
                this.instanceInfos.add(e);
            }
            return this;
        }

        public final void setInstanceInfos(Collection<InstanceInfo> instanceInfos) {
            this.instanceInfos = InstanceInfoListCopier.copy(instanceInfos);
        }

        @SafeVarargs
        public final void setInstanceInfos(InstanceInfo... instanceInfos) {
            if (this.instanceInfos == null) {
                this.instanceInfos = new SdkInternalList<>(instanceInfos.length);
            }
            for (InstanceInfo e : instanceInfos) {
                this.instanceInfos.add(e);
            }
        }

        @Override
        public BatchGetOnPremisesInstancesResponse build() {
            return new BatchGetOnPremisesInstancesResponse(this);
        }
    }
}
