/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a BatchGetOnPremisesInstances operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetOnPremisesInstancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<BatchGetOnPremisesInstancesRequest.Builder, BatchGetOnPremisesInstancesRequest> {
    private final List<String> instanceNames;

    private BatchGetOnPremisesInstancesRequest(BuilderImpl builder) {
        this.instanceNames = builder.instanceNames;
    }

    /**
     * <p>
     * The names of the on-premises instances about which to get information.
     * </p>
     * 
     * @return The names of the on-premises instances about which to get information.
     */
    public List<String> instanceNames() {
        return instanceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceNames() == null) ? 0 : instanceNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetOnPremisesInstancesRequest)) {
            return false;
        }
        BatchGetOnPremisesInstancesRequest other = (BatchGetOnPremisesInstancesRequest) obj;
        if (other.instanceNames() == null ^ this.instanceNames() == null) {
            return false;
        }
        if (other.instanceNames() != null && !other.instanceNames().equals(this.instanceNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceNames() != null) {
            sb.append("InstanceNames: ").append(instanceNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetOnPremisesInstancesRequest> {
        /**
         * <p>
         * The names of the on-premises instances about which to get information.
         * </p>
         * 
         * @param instanceNames
         *        The names of the on-premises instances about which to get information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(Collection<String> instanceNames);

        /**
         * <p>
         * The names of the on-premises instances about which to get information.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceNames(java.util.Collection)} or {@link #withInstanceNames(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param instanceNames
         *        The names of the on-premises instances about which to get information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(String... instanceNames);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> instanceNames = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetOnPremisesInstancesRequest model) {
            setInstanceNames(model.instanceNames);
        }

        public final Collection<String> getInstanceNames() {
            return instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String... instanceNames) {
            if (this.instanceNames == null) {
                this.instanceNames = new SdkInternalList<>(instanceNames.length);
            }
            for (String e : instanceNames) {
                this.instanceNames.add(e);
            }
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
        }

        @SafeVarargs
        public final void setInstanceNames(String... instanceNames) {
            if (this.instanceNames == null) {
                this.instanceNames = new SdkInternalList<>(instanceNames.length);
            }
            for (String e : instanceNames) {
                this.instanceNames.add(e);
            }
        }

        @Override
        public BatchGetOnPremisesInstancesRequest build() {
            return new BatchGetOnPremisesInstancesRequest(this);
        }
    }
}
