/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a BatchGetDeployments operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetDeploymentsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<BatchGetDeploymentsResponse.Builder, BatchGetDeploymentsResponse> {
    private final List<DeploymentInfo> deploymentsInfo;

    private BatchGetDeploymentsResponse(BuilderImpl builder) {
        this.deploymentsInfo = builder.deploymentsInfo;
    }

    /**
     * <p>
     * Information about the deployments.
     * </p>
     * 
     * @return Information about the deployments.
     */
    public List<DeploymentInfo> deploymentsInfo() {
        return deploymentsInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentsInfo() == null) ? 0 : deploymentsInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentsResponse)) {
            return false;
        }
        BatchGetDeploymentsResponse other = (BatchGetDeploymentsResponse) obj;
        if (other.deploymentsInfo() == null ^ this.deploymentsInfo() == null) {
            return false;
        }
        if (other.deploymentsInfo() != null && !other.deploymentsInfo().equals(this.deploymentsInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentsInfo() != null) {
            sb.append("DeploymentsInfo: ").append(deploymentsInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetDeploymentsResponse> {
        /**
         * <p>
         * Information about the deployments.
         * </p>
         * 
         * @param deploymentsInfo
         *        Information about the deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentsInfo(Collection<DeploymentInfo> deploymentsInfo);

        /**
         * <p>
         * Information about the deployments.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDeploymentsInfo(java.util.Collection)} or {@link #withDeploymentsInfo(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param deploymentsInfo
         *        Information about the deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentsInfo(DeploymentInfo... deploymentsInfo);
    }

    private static final class BuilderImpl implements Builder {
        private List<DeploymentInfo> deploymentsInfo = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentsResponse model) {
            setDeploymentsInfo(model.deploymentsInfo);
        }

        public final Collection<DeploymentInfo> getDeploymentsInfo() {
            return deploymentsInfo;
        }

        @Override
        public final Builder deploymentsInfo(Collection<DeploymentInfo> deploymentsInfo) {
            this.deploymentsInfo = DeploymentsInfoListCopier.copy(deploymentsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentsInfo(DeploymentInfo... deploymentsInfo) {
            if (this.deploymentsInfo == null) {
                this.deploymentsInfo = new SdkInternalList<>(deploymentsInfo.length);
            }
            for (DeploymentInfo e : deploymentsInfo) {
                this.deploymentsInfo.add(e);
            }
            return this;
        }

        public final void setDeploymentsInfo(Collection<DeploymentInfo> deploymentsInfo) {
            this.deploymentsInfo = DeploymentsInfoListCopier.copy(deploymentsInfo);
        }

        @SafeVarargs
        public final void setDeploymentsInfo(DeploymentInfo... deploymentsInfo) {
            if (this.deploymentsInfo == null) {
                this.deploymentsInfo = new SdkInternalList<>(deploymentsInfo.length);
            }
            for (DeploymentInfo e : deploymentsInfo) {
                this.deploymentsInfo.add(e);
            }
        }

        @Override
        public BatchGetDeploymentsResponse build() {
            return new BatchGetDeploymentsResponse(this);
        }
    }
}
