/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a BatchGetDeployments operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetDeploymentsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<BatchGetDeploymentsRequest.Builder, BatchGetDeploymentsRequest> {
    private final List<String> deploymentIds;

    private BatchGetDeploymentsRequest(BuilderImpl builder) {
        this.deploymentIds = builder.deploymentIds;
    }

    /**
     * <p>
     * A list of deployment IDs, separated by spaces.
     * </p>
     * 
     * @return A list of deployment IDs, separated by spaces.
     */
    public List<String> deploymentIds() {
        return deploymentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentIds() == null) ? 0 : deploymentIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentsRequest)) {
            return false;
        }
        BatchGetDeploymentsRequest other = (BatchGetDeploymentsRequest) obj;
        if (other.deploymentIds() == null ^ this.deploymentIds() == null) {
            return false;
        }
        if (other.deploymentIds() != null && !other.deploymentIds().equals(this.deploymentIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentIds() != null) {
            sb.append("DeploymentIds: ").append(deploymentIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetDeploymentsRequest> {
        /**
         * <p>
         * A list of deployment IDs, separated by spaces.
         * </p>
         * 
         * @param deploymentIds
         *        A list of deployment IDs, separated by spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(Collection<String> deploymentIds);

        /**
         * <p>
         * A list of deployment IDs, separated by spaces.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDeploymentIds(java.util.Collection)} or {@link #withDeploymentIds(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param deploymentIds
         *        A list of deployment IDs, separated by spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(String... deploymentIds);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> deploymentIds = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentsRequest model) {
            setDeploymentIds(model.deploymentIds);
        }

        public final Collection<String> getDeploymentIds() {
            return deploymentIds;
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String... deploymentIds) {
            if (this.deploymentIds == null) {
                this.deploymentIds = new SdkInternalList<>(deploymentIds.length);
            }
            for (String e : deploymentIds) {
                this.deploymentIds.add(e);
            }
            return this;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
        }

        @SafeVarargs
        public final void setDeploymentIds(String... deploymentIds) {
            if (this.deploymentIds == null) {
                this.deploymentIds = new SdkInternalList<>(deploymentIds.length);
            }
            for (String e : deploymentIds) {
                this.deploymentIds.add(e);
            }
        }

        @Override
        public BatchGetDeploymentsRequest build() {
            return new BatchGetDeploymentsRequest(this);
        }
    }
}
