/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a BatchGetDeploymentInstances operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetDeploymentInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<BatchGetDeploymentInstancesResponse.Builder, BatchGetDeploymentInstancesResponse> {
    private final List<InstanceSummary> instancesSummary;

    private final String errorMessage;

    private BatchGetDeploymentInstancesResponse(BuilderImpl builder) {
        this.instancesSummary = builder.instancesSummary;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * Information about the instance.
     * </p>
     * 
     * @return Information about the instance.
     */
    public List<InstanceSummary> instancesSummary() {
        return instancesSummary;
    }

    /**
     * <p>
     * Information about errors that may have occurred during the API call.
     * </p>
     * 
     * @return Information about errors that may have occurred during the API call.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instancesSummary() == null) ? 0 : instancesSummary().hashCode());
        hashCode = 31 * hashCode + ((errorMessage() == null) ? 0 : errorMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentInstancesResponse)) {
            return false;
        }
        BatchGetDeploymentInstancesResponse other = (BatchGetDeploymentInstancesResponse) obj;
        if (other.instancesSummary() == null ^ this.instancesSummary() == null) {
            return false;
        }
        if (other.instancesSummary() != null && !other.instancesSummary().equals(this.instancesSummary())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        if (other.errorMessage() != null && !other.errorMessage().equals(this.errorMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instancesSummary() != null) {
            sb.append("InstancesSummary: ").append(instancesSummary()).append(",");
        }
        if (errorMessage() != null) {
            sb.append("ErrorMessage: ").append(errorMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetDeploymentInstancesResponse> {
        /**
         * <p>
         * Information about the instance.
         * </p>
         * 
         * @param instancesSummary
         *        Information about the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesSummary(Collection<InstanceSummary> instancesSummary);

        /**
         * <p>
         * Information about the instance.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstancesSummary(java.util.Collection)} or {@link #withInstancesSummary(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param instancesSummary
         *        Information about the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesSummary(InstanceSummary... instancesSummary);

        /**
         * <p>
         * Information about errors that may have occurred during the API call.
         * </p>
         * 
         * @param errorMessage
         *        Information about errors that may have occurred during the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    private static final class BuilderImpl implements Builder {
        private List<InstanceSummary> instancesSummary = new SdkInternalList<>();

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentInstancesResponse model) {
            setInstancesSummary(model.instancesSummary);
            setErrorMessage(model.errorMessage);
        }

        public final Collection<InstanceSummary> getInstancesSummary() {
            return instancesSummary;
        }

        @Override
        public final Builder instancesSummary(Collection<InstanceSummary> instancesSummary) {
            this.instancesSummary = InstanceSummaryListCopier.copy(instancesSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancesSummary(InstanceSummary... instancesSummary) {
            if (this.instancesSummary == null) {
                this.instancesSummary = new SdkInternalList<>(instancesSummary.length);
            }
            for (InstanceSummary e : instancesSummary) {
                this.instancesSummary.add(e);
            }
            return this;
        }

        public final void setInstancesSummary(Collection<InstanceSummary> instancesSummary) {
            this.instancesSummary = InstanceSummaryListCopier.copy(instancesSummary);
        }

        @SafeVarargs
        public final void setInstancesSummary(InstanceSummary... instancesSummary) {
            if (this.instancesSummary == null) {
                this.instancesSummary = new SdkInternalList<>(instancesSummary.length);
            }
            for (InstanceSummary e : instancesSummary) {
                this.instancesSummary.add(e);
            }
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public BatchGetDeploymentInstancesResponse build() {
            return new BatchGetDeploymentInstancesResponse(this);
        }
    }
}
