/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a BatchGetDeploymentInstances operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetDeploymentInstancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<BatchGetDeploymentInstancesRequest.Builder, BatchGetDeploymentInstancesRequest> {
    private final String deploymentId;

    private final List<String> instanceIds;

    private BatchGetDeploymentInstancesRequest(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.instanceIds = builder.instanceIds;
    }

    /**
     * <p>
     * The unique ID of a deployment.
     * </p>
     * 
     * @return The unique ID of a deployment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The unique IDs of instances in the deployment group.
     * </p>
     * 
     * @return The unique IDs of instances in the deployment group.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentId() == null) ? 0 : deploymentId().hashCode());
        hashCode = 31 * hashCode + ((instanceIds() == null) ? 0 : instanceIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentInstancesRequest)) {
            return false;
        }
        BatchGetDeploymentInstancesRequest other = (BatchGetDeploymentInstancesRequest) obj;
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentId() != null) {
            sb.append("DeploymentId: ").append(deploymentId()).append(",");
        }
        if (instanceIds() != null) {
            sb.append("InstanceIds: ").append(instanceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetDeploymentInstancesRequest> {
        /**
         * <p>
         * The unique ID of a deployment.
         * </p>
         * 
         * @param deploymentId
         *        The unique ID of a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The unique IDs of instances in the deployment group.
         * </p>
         * 
         * @param instanceIds
         *        The unique IDs of instances in the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The unique IDs of instances in the deployment group.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceIds(java.util.Collection)} or {@link #withInstanceIds(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param instanceIds
         *        The unique IDs of instances in the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentId;

        private List<String> instanceIds = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentInstancesRequest model) {
            setDeploymentId(model.deploymentId);
            setInstanceIds(model.instanceIds);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstancesListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList<>(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstancesListCopier.copy(instanceIds);
        }

        @SafeVarargs
        public final void setInstanceIds(String... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList<>(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
        }

        @Override
        public BatchGetDeploymentInstancesRequest build() {
            return new BatchGetDeploymentInstancesRequest(this);
        }
    }
}
