/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a BatchGetDeploymentGroups operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetDeploymentGroupsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<BatchGetDeploymentGroupsResponse.Builder, BatchGetDeploymentGroupsResponse> {
    private final List<DeploymentGroupInfo> deploymentGroupsInfo;

    private final String errorMessage;

    private BatchGetDeploymentGroupsResponse(BuilderImpl builder) {
        this.deploymentGroupsInfo = builder.deploymentGroupsInfo;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * Information about the deployment groups.
     * </p>
     * 
     * @return Information about the deployment groups.
     */
    public List<DeploymentGroupInfo> deploymentGroupsInfo() {
        return deploymentGroupsInfo;
    }

    /**
     * <p>
     * Information about errors that may have occurred during the API call.
     * </p>
     * 
     * @return Information about errors that may have occurred during the API call.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentGroupsInfo() == null) ? 0 : deploymentGroupsInfo().hashCode());
        hashCode = 31 * hashCode + ((errorMessage() == null) ? 0 : errorMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentGroupsResponse)) {
            return false;
        }
        BatchGetDeploymentGroupsResponse other = (BatchGetDeploymentGroupsResponse) obj;
        if (other.deploymentGroupsInfo() == null ^ this.deploymentGroupsInfo() == null) {
            return false;
        }
        if (other.deploymentGroupsInfo() != null && !other.deploymentGroupsInfo().equals(this.deploymentGroupsInfo())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        if (other.errorMessage() != null && !other.errorMessage().equals(this.errorMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentGroupsInfo() != null) {
            sb.append("DeploymentGroupsInfo: ").append(deploymentGroupsInfo()).append(",");
        }
        if (errorMessage() != null) {
            sb.append("ErrorMessage: ").append(errorMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetDeploymentGroupsResponse> {
        /**
         * <p>
         * Information about the deployment groups.
         * </p>
         * 
         * @param deploymentGroupsInfo
         *        Information about the deployment groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> deploymentGroupsInfo);

        /**
         * <p>
         * Information about the deployment groups.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDeploymentGroupsInfo(java.util.Collection)} or
         * {@link #withDeploymentGroupsInfo(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param deploymentGroupsInfo
         *        Information about the deployment groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupsInfo(DeploymentGroupInfo... deploymentGroupsInfo);

        /**
         * <p>
         * Information about errors that may have occurred during the API call.
         * </p>
         * 
         * @param errorMessage
         *        Information about errors that may have occurred during the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    private static final class BuilderImpl implements Builder {
        private List<DeploymentGroupInfo> deploymentGroupsInfo = new SdkInternalList<>();

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentGroupsResponse model) {
            setDeploymentGroupsInfo(model.deploymentGroupsInfo);
            setErrorMessage(model.errorMessage);
        }

        public final Collection<DeploymentGroupInfo> getDeploymentGroupsInfo() {
            return deploymentGroupsInfo;
        }

        @Override
        public final Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copy(deploymentGroupsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupsInfo(DeploymentGroupInfo... deploymentGroupsInfo) {
            if (this.deploymentGroupsInfo == null) {
                this.deploymentGroupsInfo = new SdkInternalList<>(deploymentGroupsInfo.length);
            }
            for (DeploymentGroupInfo e : deploymentGroupsInfo) {
                this.deploymentGroupsInfo.add(e);
            }
            return this;
        }

        public final void setDeploymentGroupsInfo(Collection<DeploymentGroupInfo> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copy(deploymentGroupsInfo);
        }

        @SafeVarargs
        public final void setDeploymentGroupsInfo(DeploymentGroupInfo... deploymentGroupsInfo) {
            if (this.deploymentGroupsInfo == null) {
                this.deploymentGroupsInfo = new SdkInternalList<>(deploymentGroupsInfo.length);
            }
            for (DeploymentGroupInfo e : deploymentGroupsInfo) {
                this.deploymentGroupsInfo.add(e);
            }
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public BatchGetDeploymentGroupsResponse build() {
            return new BatchGetDeploymentGroupsResponse(this);
        }
    }
}
