/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a BatchGetDeploymentGroups operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetDeploymentGroupsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<BatchGetDeploymentGroupsRequest.Builder, BatchGetDeploymentGroupsRequest> {
    private final String applicationName;

    private final List<String> deploymentGroupNames;

    private BatchGetDeploymentGroupsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupNames = builder.deploymentGroupNames;
    }

    /**
     * <p>
     * The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
     * </p>
     * 
     * @return The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The deployment groups' names.
     * </p>
     * 
     * @return The deployment groups' names.
     */
    public List<String> deploymentGroupNames() {
        return deploymentGroupNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((deploymentGroupNames() == null) ? 0 : deploymentGroupNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentGroupsRequest)) {
            return false;
        }
        BatchGetDeploymentGroupsRequest other = (BatchGetDeploymentGroupsRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroupNames() == null ^ this.deploymentGroupNames() == null) {
            return false;
        }
        if (other.deploymentGroupNames() != null && !other.deploymentGroupNames().equals(this.deploymentGroupNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (deploymentGroupNames() != null) {
            sb.append("DeploymentGroupNames: ").append(deploymentGroupNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetDeploymentGroupsRequest> {
        /**
         * <p>
         * The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
         * </p>
         * 
         * @param applicationName
         *        The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The deployment groups' names.
         * </p>
         * 
         * @param deploymentGroupNames
         *        The deployment groups' names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupNames(Collection<String> deploymentGroupNames);

        /**
         * <p>
         * The deployment groups' names.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDeploymentGroupNames(java.util.Collection)} or
         * {@link #withDeploymentGroupNames(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param deploymentGroupNames
         *        The deployment groups' names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupNames(String... deploymentGroupNames);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private List<String> deploymentGroupNames = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentGroupsRequest model) {
            setApplicationName(model.applicationName);
            setDeploymentGroupNames(model.deploymentGroupNames);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<String> getDeploymentGroupNames() {
            return deploymentGroupNames;
        }

        @Override
        public final Builder deploymentGroupNames(Collection<String> deploymentGroupNames) {
            this.deploymentGroupNames = DeploymentGroupsListCopier.copy(deploymentGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupNames(String... deploymentGroupNames) {
            if (this.deploymentGroupNames == null) {
                this.deploymentGroupNames = new SdkInternalList<>(deploymentGroupNames.length);
            }
            for (String e : deploymentGroupNames) {
                this.deploymentGroupNames.add(e);
            }
            return this;
        }

        public final void setDeploymentGroupNames(Collection<String> deploymentGroupNames) {
            this.deploymentGroupNames = DeploymentGroupsListCopier.copy(deploymentGroupNames);
        }

        @SafeVarargs
        public final void setDeploymentGroupNames(String... deploymentGroupNames) {
            if (this.deploymentGroupNames == null) {
                this.deploymentGroupNames = new SdkInternalList<>(deploymentGroupNames.length);
            }
            for (String e : deploymentGroupNames) {
                this.deploymentGroupNames.add(e);
            }
        }

        @Override
        public BatchGetDeploymentGroupsRequest build() {
            return new BatchGetDeploymentGroupsRequest(this);
        }
    }
}
