/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a BatchGetApplications operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetApplicationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<BatchGetApplicationsResponse.Builder, BatchGetApplicationsResponse> {
    private final List<ApplicationInfo> applicationsInfo;

    private BatchGetApplicationsResponse(BuilderImpl builder) {
        this.applicationsInfo = builder.applicationsInfo;
    }

    /**
     * <p>
     * Information about the applications.
     * </p>
     * 
     * @return Information about the applications.
     */
    public List<ApplicationInfo> applicationsInfo() {
        return applicationsInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationsInfo() == null) ? 0 : applicationsInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationsResponse)) {
            return false;
        }
        BatchGetApplicationsResponse other = (BatchGetApplicationsResponse) obj;
        if (other.applicationsInfo() == null ^ this.applicationsInfo() == null) {
            return false;
        }
        if (other.applicationsInfo() != null && !other.applicationsInfo().equals(this.applicationsInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationsInfo() != null) {
            sb.append("ApplicationsInfo: ").append(applicationsInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetApplicationsResponse> {
        /**
         * <p>
         * Information about the applications.
         * </p>
         * 
         * @param applicationsInfo
         *        Information about the applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationsInfo(Collection<ApplicationInfo> applicationsInfo);

        /**
         * <p>
         * Information about the applications.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setApplicationsInfo(java.util.Collection)} or {@link #withApplicationsInfo(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param applicationsInfo
         *        Information about the applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationsInfo(ApplicationInfo... applicationsInfo);
    }

    private static final class BuilderImpl implements Builder {
        private List<ApplicationInfo> applicationsInfo = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationsResponse model) {
            setApplicationsInfo(model.applicationsInfo);
        }

        public final Collection<ApplicationInfo> getApplicationsInfo() {
            return applicationsInfo;
        }

        @Override
        public final Builder applicationsInfo(Collection<ApplicationInfo> applicationsInfo) {
            this.applicationsInfo = ApplicationsInfoListCopier.copy(applicationsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationsInfo(ApplicationInfo... applicationsInfo) {
            if (this.applicationsInfo == null) {
                this.applicationsInfo = new SdkInternalList<>(applicationsInfo.length);
            }
            for (ApplicationInfo e : applicationsInfo) {
                this.applicationsInfo.add(e);
            }
            return this;
        }

        public final void setApplicationsInfo(Collection<ApplicationInfo> applicationsInfo) {
            this.applicationsInfo = ApplicationsInfoListCopier.copy(applicationsInfo);
        }

        @SafeVarargs
        public final void setApplicationsInfo(ApplicationInfo... applicationsInfo) {
            if (this.applicationsInfo == null) {
                this.applicationsInfo = new SdkInternalList<>(applicationsInfo.length);
            }
            for (ApplicationInfo e : applicationsInfo) {
                this.applicationsInfo.add(e);
            }
        }

        @Override
        public BatchGetApplicationsResponse build() {
            return new BatchGetApplicationsResponse(this);
        }
    }
}
