/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a BatchGetApplications operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetApplicationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<BatchGetApplicationsRequest.Builder, BatchGetApplicationsRequest> {
    private final List<String> applicationNames;

    private BatchGetApplicationsRequest(BuilderImpl builder) {
        this.applicationNames = builder.applicationNames;
    }

    /**
     * <p>
     * A list of application names separated by spaces.
     * </p>
     * 
     * @return A list of application names separated by spaces.
     */
    public List<String> applicationNames() {
        return applicationNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationNames() == null) ? 0 : applicationNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationsRequest)) {
            return false;
        }
        BatchGetApplicationsRequest other = (BatchGetApplicationsRequest) obj;
        if (other.applicationNames() == null ^ this.applicationNames() == null) {
            return false;
        }
        if (other.applicationNames() != null && !other.applicationNames().equals(this.applicationNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationNames() != null) {
            sb.append("ApplicationNames: ").append(applicationNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetApplicationsRequest> {
        /**
         * <p>
         * A list of application names separated by spaces.
         * </p>
         * 
         * @param applicationNames
         *        A list of application names separated by spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationNames(Collection<String> applicationNames);

        /**
         * <p>
         * A list of application names separated by spaces.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setApplicationNames(java.util.Collection)} or {@link #withApplicationNames(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param applicationNames
         *        A list of application names separated by spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationNames(String... applicationNames);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> applicationNames = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationsRequest model) {
            setApplicationNames(model.applicationNames);
        }

        public final Collection<String> getApplicationNames() {
            return applicationNames;
        }

        @Override
        public final Builder applicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationsListCopier.copy(applicationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationNames(String... applicationNames) {
            if (this.applicationNames == null) {
                this.applicationNames = new SdkInternalList<>(applicationNames.length);
            }
            for (String e : applicationNames) {
                this.applicationNames.add(e);
            }
            return this;
        }

        public final void setApplicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationsListCopier.copy(applicationNames);
        }

        @SafeVarargs
        public final void setApplicationNames(String... applicationNames) {
            if (this.applicationNames == null) {
                this.applicationNames = new SdkInternalList<>(applicationNames.length);
            }
            for (String e : applicationNames) {
                this.applicationNames.add(e);
            }
        }

        @Override
        public BatchGetApplicationsRequest build() {
            return new BatchGetApplicationsRequest(this);
        }
    }
}
