/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a BatchGetApplicationRevisions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetApplicationRevisionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<BatchGetApplicationRevisionsResponse.Builder, BatchGetApplicationRevisionsResponse> {
    private final String applicationName;

    private final String errorMessage;

    private final List<RevisionInfo> revisions;

    private BatchGetApplicationRevisionsResponse(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.errorMessage = builder.errorMessage;
        this.revisions = builder.revisions;
    }

    /**
     * <p>
     * The name of the application that corresponds to the revisions.
     * </p>
     * 
     * @return The name of the application that corresponds to the revisions.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Information about errors that may have occurred during the API call.
     * </p>
     * 
     * @return Information about errors that may have occurred during the API call.
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Additional information about the revisions, including the type and location.
     * </p>
     * 
     * @return Additional information about the revisions, including the type and location.
     */
    public List<RevisionInfo> revisions() {
        return revisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((errorMessage() == null) ? 0 : errorMessage().hashCode());
        hashCode = 31 * hashCode + ((revisions() == null) ? 0 : revisions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationRevisionsResponse)) {
            return false;
        }
        BatchGetApplicationRevisionsResponse other = (BatchGetApplicationRevisionsResponse) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        if (other.errorMessage() != null && !other.errorMessage().equals(this.errorMessage())) {
            return false;
        }
        if (other.revisions() == null ^ this.revisions() == null) {
            return false;
        }
        if (other.revisions() != null && !other.revisions().equals(this.revisions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (errorMessage() != null) {
            sb.append("ErrorMessage: ").append(errorMessage()).append(",");
        }
        if (revisions() != null) {
            sb.append("Revisions: ").append(revisions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetApplicationRevisionsResponse> {
        /**
         * <p>
         * The name of the application that corresponds to the revisions.
         * </p>
         * 
         * @param applicationName
         *        The name of the application that corresponds to the revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Information about errors that may have occurred during the API call.
         * </p>
         * 
         * @param errorMessage
         *        Information about errors that may have occurred during the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Additional information about the revisions, including the type and location.
         * </p>
         * 
         * @param revisions
         *        Additional information about the revisions, including the type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(Collection<RevisionInfo> revisions);

        /**
         * <p>
         * Additional information about the revisions, including the type and location.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRevisions(java.util.Collection)} or {@link #withRevisions(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param revisions
         *        Additional information about the revisions, including the type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(RevisionInfo... revisions);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private String errorMessage;

        private List<RevisionInfo> revisions = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationRevisionsResponse model) {
            setApplicationName(model.applicationName);
            setErrorMessage(model.errorMessage);
            setRevisions(model.revisions);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Collection<RevisionInfo> getRevisions() {
            return revisions;
        }

        @Override
        public final Builder revisions(Collection<RevisionInfo> revisions) {
            this.revisions = RevisionInfoListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionInfo... revisions) {
            if (this.revisions == null) {
                this.revisions = new SdkInternalList<>(revisions.length);
            }
            for (RevisionInfo e : revisions) {
                this.revisions.add(e);
            }
            return this;
        }

        public final void setRevisions(Collection<RevisionInfo> revisions) {
            this.revisions = RevisionInfoListCopier.copy(revisions);
        }

        @SafeVarargs
        public final void setRevisions(RevisionInfo... revisions) {
            if (this.revisions == null) {
                this.revisions = new SdkInternalList<>(revisions.length);
            }
            for (RevisionInfo e : revisions) {
                this.revisions.add(e);
            }
        }

        @Override
        public BatchGetApplicationRevisionsResponse build() {
            return new BatchGetApplicationRevisionsResponse(this);
        }
    }
}
