/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a BatchGetApplicationRevisions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetApplicationRevisionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<BatchGetApplicationRevisionsRequest.Builder, BatchGetApplicationRevisionsRequest> {
    private final String applicationName;

    private final List<RevisionLocation> revisions;

    private BatchGetApplicationRevisionsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.revisions = builder.revisions;
    }

    /**
     * <p>
     * The name of an AWS CodeDeploy application about which to get revision information.
     * </p>
     * 
     * @return The name of an AWS CodeDeploy application about which to get revision information.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Information to get about the application revisions, including type and location.
     * </p>
     * 
     * @return Information to get about the application revisions, including type and location.
     */
    public List<RevisionLocation> revisions() {
        return revisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((revisions() == null) ? 0 : revisions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationRevisionsRequest)) {
            return false;
        }
        BatchGetApplicationRevisionsRequest other = (BatchGetApplicationRevisionsRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.revisions() == null ^ this.revisions() == null) {
            return false;
        }
        if (other.revisions() != null && !other.revisions().equals(this.revisions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (revisions() != null) {
            sb.append("Revisions: ").append(revisions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetApplicationRevisionsRequest> {
        /**
         * <p>
         * The name of an AWS CodeDeploy application about which to get revision information.
         * </p>
         * 
         * @param applicationName
         *        The name of an AWS CodeDeploy application about which to get revision information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Information to get about the application revisions, including type and location.
         * </p>
         * 
         * @param revisions
         *        Information to get about the application revisions, including type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(Collection<RevisionLocation> revisions);

        /**
         * <p>
         * Information to get about the application revisions, including type and location.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRevisions(java.util.Collection)} or {@link #withRevisions(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param revisions
         *        Information to get about the application revisions, including type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(RevisionLocation... revisions);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private List<RevisionLocation> revisions = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationRevisionsRequest model) {
            setApplicationName(model.applicationName);
            setRevisions(model.revisions);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<RevisionLocation> getRevisions() {
            return revisions;
        }

        @Override
        public final Builder revisions(Collection<RevisionLocation> revisions) {
            this.revisions = RevisionLocationListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionLocation... revisions) {
            if (this.revisions == null) {
                this.revisions = new SdkInternalList<>(revisions.length);
            }
            for (RevisionLocation e : revisions) {
                this.revisions.add(e);
            }
            return this;
        }

        public final void setRevisions(Collection<RevisionLocation> revisions) {
            this.revisions = RevisionLocationListCopier.copy(revisions);
        }

        @SafeVarargs
        public final void setRevisions(RevisionLocation... revisions) {
            if (this.revisions == null) {
                this.revisions = new SdkInternalList<>(revisions.length);
            }
            for (RevisionLocation e : revisions) {
                this.revisions.add(e);
            }
        }

        @Override
        public BatchGetApplicationRevisionsRequest build() {
            return new BatchGetApplicationRevisionsRequest(this);
        }
    }
}
